# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Invitation(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'created_by': 'int',
        'created_datetime': 'datetime',
        'created_username': 'str',
        'email': 'str',
        'id': 'int',
        'organization': 'int',
        'permission': 'str',
        'status': 'str'
    }

    attribute_map = {
        'created_by': 'created_by',
        'created_datetime': 'created_datetime',
        'created_username': 'created_username',
        'email': 'email',
        'id': 'id',
        'organization': 'organization',
        'permission': 'permission',
        'status': 'status'
    }

    def __init__(self, created_by=None, created_datetime=None, created_username=None, email=None, id=None, organization=None, permission=None, status=None, local_vars_configuration=None):  # noqa: E501
        """Invitation - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._created_by = None
        self._created_datetime = None
        self._created_username = None
        self._email = None
        self._id = None
        self._organization = None
        self._permission = None
        self._status = None
        self.discriminator = None

        if created_by is not None:
            self.created_by = created_by
        if created_datetime is not None:
            self.created_datetime = created_datetime
        if created_username is not None:
            self.created_username = created_username
        if email is not None:
            self.email = email
        if id is not None:
            self.id = id
        if organization is not None:
            self.organization = organization
        if permission is not None:
            self.permission = permission
        if status is not None:
            self.status = status

    @property
    def created_by(self):
        """
        Unique integer identifying a user.

        :return: The created_by of this Invitation. 
        :rtype: int
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Unique integer identifying a user.

        :param created_by: The created_by of this Invitation.
        :type: int
        """

        self._created_by = created_by

    @property
    def created_datetime(self):
        """
        Datetime this invitation was created.

        :return: The created_datetime of this Invitation. 
        :rtype: datetime
        """
        return self._created_datetime

    @created_datetime.setter
    def created_datetime(self, created_datetime):
        """
        Datetime this invitation was created.

        :param created_datetime: The created_datetime of this Invitation.
        :type: datetime
        """

        self._created_datetime = created_datetime

    @property
    def created_username(self):
        """
        Username of creator of the invitation.

        :return: The created_username of this Invitation. 
        :rtype: str
        """
        return self._created_username

    @created_username.setter
    def created_username(self, created_username):
        """
        Username of creator of the invitation.

        :param created_username: The created_username of this Invitation.
        :type: str
        """

        self._created_username = created_username

    @property
    def email(self):
        """
        Unique integer identifying a user.

        :return: The email of this Invitation. 
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Unique integer identifying a user.

        :param email: The email of this Invitation.
        :type: str
        """

        self._email = email

    @property
    def id(self):
        """
        Unique integer identifying an invitation.

        :return: The id of this Invitation. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying an invitation.

        :param id: The id of this Invitation.
        :type: int
        """

        self._id = id

    @property
    def organization(self):
        """
        Unique integer identifying an organization.

        :return: The organization of this Invitation. 
        :rtype: int
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """
        Unique integer identifying an organization.

        :param organization: The organization of this Invitation.
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                organization is not None and organization < 1):  # noqa: E501
            raise ValueError("Invalid value for `organization`, must be a value greater than or equal to `1`")  # noqa: E501

        self._organization = organization

    @property
    def permission(self):
        """
        User permission level for the organization.

        :return: The permission of this Invitation. 
        :rtype: str
        """
        return self._permission

    @permission.setter
    def permission(self, permission):
        """
        User permission level for the organization.

        :param permission: The permission of this Invitation.
        :type: str
        """
        allowed_values = ["Member", "Admin"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and permission not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `permission` ({0}), must be one of {1}"  # noqa: E501
                .format(permission, allowed_values)
            )

        self._permission = permission

    @property
    def status(self):
        """
        Status of the invitation.

        :return: The status of this Invitation. 
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Status of the invitation.

        :param status: The status of this Invitation.
        :type: str
        """
        allowed_values = ["Pending", "Expired", "Accepted"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Invitation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Invitation):
            return True

        return self.to_dict() != other.to_dict()
