# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class MediaIdQuery(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ids': 'list[int]',
        'localization_ids': 'list[int]',
        'state_ids': 'list[int]'
    }

    attribute_map = {
        'ids': 'ids',
        'localization_ids': 'localization_ids',
        'state_ids': 'state_ids'
    }

    def __init__(self, ids=None, localization_ids=None, state_ids=None, local_vars_configuration=None):  # noqa: E501
        """MediaIdQuery - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._ids = None
        self._localization_ids = None
        self._state_ids = None
        self.discriminator = None

        if ids is not None:
            self.ids = ids
        if localization_ids is not None:
            self.localization_ids = localization_ids
        if state_ids is not None:
            self.state_ids = state_ids

    @property
    def ids(self):
        """
        Array of media IDs to retrieve.

        :return: The ids of this MediaIdQuery. 
        :rtype: list[int]
        """
        return self._ids

    @ids.setter
    def ids(self, ids):
        """
        Array of media IDs to retrieve.

        :param ids: The ids of this MediaIdQuery.
        :type: list[int]
        """

        self._ids = ids

    @property
    def localization_ids(self):
        """
        Array of child localization IDs for which media should be retrieved.

        :return: The localization_ids of this MediaIdQuery. 
        :rtype: list[int]
        """
        return self._localization_ids

    @localization_ids.setter
    def localization_ids(self, localization_ids):
        """
        Array of child localization IDs for which media should be retrieved.

        :param localization_ids: The localization_ids of this MediaIdQuery.
        :type: list[int]
        """

        self._localization_ids = localization_ids

    @property
    def state_ids(self):
        """
        Array of child state IDs for which media should be retrieved.

        :return: The state_ids of this MediaIdQuery. 
        :rtype: list[int]
        """
        return self._state_ids

    @state_ids.setter
    def state_ids(self, state_ids):
        """
        Array of child state IDs for which media should be retrieved.

        :param state_ids: The state_ids of this MediaIdQuery.
        :type: list[int]
        """

        self._state_ids = state_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MediaIdQuery):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MediaIdQuery):
            return True

        return self.to_dict() != other.to_dict()
