# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class MultiDefinition(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'ids': 'list[int]',
        'layout': 'list[int]',
        'quality': 'int'
    }

    attribute_map = {
        'ids': 'ids',
        'layout': 'layout',
        'quality': 'quality'
    }

    def __init__(self, ids=None, layout=None, quality=None, local_vars_configuration=None):  # noqa: E501
        """MultiDefinition - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._ids = None
        self._layout = None
        self._quality = None
        self.discriminator = None

        if ids is not None:
            self.ids = ids
        if layout is not None:
            self.layout = layout
        if quality is not None:
            self.quality = quality

    @property
    def ids(self):
        """
        If multi-stream list of ids of sub-videos

        :return: The ids of this MultiDefinition. 
        :rtype: list[int]
        """
        return self._ids

    @ids.setter
    def ids(self, ids):
        """
        If multi-stream list of ids of sub-videos

        :param ids: The ids of this MultiDefinition.
        :type: list[int]
        """

        self._ids = ids

    @property
    def layout(self):
        """
        2-element array to define rxc layout

        :return: The layout of this MultiDefinition. 
        :rtype: list[int]
        """
        return self._layout

    @layout.setter
    def layout(self, layout):
        """
        2-element array to define rxc layout

        :param layout: The layout of this MultiDefinition.
        :type: list[int]
        """

        self._layout = layout

    @property
    def quality(self):
        """
        Resolution to fetch on each sub-video

        :return: The quality of this MultiDefinition. 
        :rtype: int
        """
        return self._quality

    @quality.setter
    def quality(self, quality):
        """
        Resolution to fetch on each sub-video

        :param quality: The quality of this MultiDefinition.
        :type: int
        """

        self._quality = quality

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MultiDefinition):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MultiDefinition):
            return True

        return self.to_dict() != other.to_dict()
