# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class StateSpec(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'frame': 'int',
        'localization_ids': 'list[int]',
        'media_ids': 'list[int]',
        'type': 'int',
        'version': 'int'
    }

    attribute_map = {
        'frame': 'frame',
        'localization_ids': 'localization_ids',
        'media_ids': 'media_ids',
        'type': 'type',
        'version': 'version'
    }

    def __init__(self, frame=None, localization_ids=None, media_ids=None, type=None, version=None, local_vars_configuration=None):  # noqa: E501
        """StateSpec - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._frame = None
        self._localization_ids = None
        self._media_ids = None
        self._type = None
        self._version = None
        self.discriminator = None

        if frame is not None:
            self.frame = frame
        if localization_ids is not None:
            self.localization_ids = localization_ids
        self.media_ids = media_ids
        self.type = type
        if version is not None:
            self.version = version

    @property
    def frame(self):
        """
        Frame number this state applies to.

        :return: The frame of this StateSpec. 
        :rtype: int
        """
        return self._frame

    @frame.setter
    def frame(self, frame):
        """
        Frame number this state applies to.

        :param frame: The frame of this StateSpec.
        :type: int
        """

        self._frame = frame

    @property
    def localization_ids(self):
        """
        List of localization IDs that this state applies to.

        :return: The localization_ids of this StateSpec. 
        :rtype: list[int]
        """
        return self._localization_ids

    @localization_ids.setter
    def localization_ids(self, localization_ids):
        """
        List of localization IDs that this state applies to.

        :param localization_ids: The localization_ids of this StateSpec.
        :type: list[int]
        """

        self._localization_ids = localization_ids

    @property
    def media_ids(self):
        """
        List of media IDs that this state applies to.

        :return: The media_ids of this StateSpec. 
        :rtype: list[int]
        """
        return self._media_ids

    @media_ids.setter
    def media_ids(self, media_ids):
        """
        List of media IDs that this state applies to.

        :param media_ids: The media_ids of this StateSpec.
        :type: list[int]
        """
        if self.local_vars_configuration.client_side_validation and media_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `media_ids`, must not be `None`")  # noqa: E501

        self._media_ids = media_ids

    @property
    def type(self):
        """
        Unique integer identifying a state type.

        :return: The type of this StateSpec. 
        :rtype: int
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Unique integer identifying a state type.

        :param type: The type of this StateSpec.
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and type is None:  # noqa: E501
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501

        self._type = type

    @property
    def version(self):
        """
        Unique integer identifying the version.

        :return: The version of this StateSpec. 
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Unique integer identifying the version.

        :param version: The version of this StateSpec.
        :type: int
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StateSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StateSpec):
            return True

        return self.to_dict() != other.to_dict()
