# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class VideoDefinition(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'bit_rate': 'int',
        'codec': 'str',
        'codec_description': 'str',
        'codec_mime': 'str',
        'host': 'str',
        'http_auth': 'str',
        'path': 'str',
        'resolution': 'list[int]',
        'segment_info': 'str',
        'size': 'int'
    }

    attribute_map = {
        'bit_rate': 'bit_rate',
        'codec': 'codec',
        'codec_description': 'codec_description',
        'codec_mime': 'codec_mime',
        'host': 'host',
        'http_auth': 'http_auth',
        'path': 'path',
        'resolution': 'resolution',
        'segment_info': 'segment_info',
        'size': 'size'
    }

    def __init__(self, bit_rate=None, codec=None, codec_description=None, codec_mime=None, host=None, http_auth=None, path=None, resolution=None, segment_info=None, size=None, local_vars_configuration=None):  # noqa: E501
        """VideoDefinition - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._bit_rate = None
        self._codec = None
        self._codec_description = None
        self._codec_mime = None
        self._host = None
        self._http_auth = None
        self._path = None
        self._resolution = None
        self._segment_info = None
        self._size = None
        self.discriminator = None

        if bit_rate is not None:
            self.bit_rate = bit_rate
        self.codec = codec
        if codec_description is not None:
            self.codec_description = codec_description
        if codec_mime is not None:
            self.codec_mime = codec_mime
        if host is not None:
            self.host = host
        if http_auth is not None:
            self.http_auth = http_auth
        self.path = path
        self.resolution = resolution
        if segment_info is not None:
            self.segment_info = segment_info
        if size is not None:
            self.size = size

    @property
    def bit_rate(self):
        """
        Bit rate in bits per second

        :return: The bit_rate of this VideoDefinition. 
        :rtype: int
        """
        return self._bit_rate

    @bit_rate.setter
    def bit_rate(self, bit_rate):
        """
        Bit rate in bits per second

        :param bit_rate: The bit_rate of this VideoDefinition.
        :type: int
        """

        self._bit_rate = bit_rate

    @property
    def codec(self):
        """
        Human readable codec.

        :return: The codec of this VideoDefinition. 
        :rtype: str
        """
        return self._codec

    @codec.setter
    def codec(self, codec):
        """
        Human readable codec.

        :param codec: The codec of this VideoDefinition.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and codec is None:  # noqa: E501
            raise ValueError("Invalid value for `codec`, must not be `None`")  # noqa: E501

        self._codec = codec

    @property
    def codec_description(self):
        """
        Description other than codec.

        :return: The codec_description of this VideoDefinition. 
        :rtype: str
        """
        return self._codec_description

    @codec_description.setter
    def codec_description(self, codec_description):
        """
        Description other than codec.

        :param codec_description: The codec_description of this VideoDefinition.
        :type: str
        """

        self._codec_description = codec_description

    @property
    def codec_mime(self):
        """
        Example mime: \"video/mp4; codecs=\"avc1.64001e\"\". Only relevant for streaming files, will assume example above if not present.

        :return: The codec_mime of this VideoDefinition. 
        :rtype: str
        """
        return self._codec_mime

    @codec_mime.setter
    def codec_mime(self, codec_mime):
        """
        Example mime: \"video/mp4; codecs=\"avc1.64001e\"\". Only relevant for streaming files, will assume example above if not present.

        :param codec_mime: The codec_mime of this VideoDefinition.
        :type: str
        """

        self._codec_mime = codec_mime

    @property
    def host(self):
        """
        If supplied will use this instead of currently connected host, e.g. https://example.com

        :return: The host of this VideoDefinition. 
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """
        If supplied will use this instead of currently connected host, e.g. https://example.com

        :param host: The host of this VideoDefinition.
        :type: str
        """

        self._host = host

    @property
    def http_auth(self):
        """
        If specified will be used for HTTP authorization in request for media, i.e. \"bearer <token>\".

        :return: The http_auth of this VideoDefinition. 
        :rtype: str
        """
        return self._http_auth

    @http_auth.setter
    def http_auth(self, http_auth):
        """
        If specified will be used for HTTP authorization in request for media, i.e. \"bearer <token>\".

        :param http_auth: The http_auth of this VideoDefinition.
        :type: str
        """

        self._http_auth = http_auth

    @property
    def path(self):
        """
        Relative URL to the file.

        :return: The path of this VideoDefinition. 
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Relative URL to the file.

        :param path: The path of this VideoDefinition.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and path is None:  # noqa: E501
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501

        self._path = path

    @property
    def resolution(self):
        """
        Resolution of the video in pixels (height, width).

        :return: The resolution of this VideoDefinition. 
        :rtype: list[int]
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution):
        """
        Resolution of the video in pixels (height, width).

        :param resolution: The resolution of this VideoDefinition.
        :type: list[int]
        """
        if self.local_vars_configuration.client_side_validation and resolution is None:  # noqa: E501
            raise ValueError("Invalid value for `resolution`, must not be `None`")  # noqa: E501

        self._resolution = resolution

    @property
    def segment_info(self):
        """
        Path to json file containing segment info. Required if media role is `streaming`.

        :return: The segment_info of this VideoDefinition. 
        :rtype: str
        """
        return self._segment_info

    @segment_info.setter
    def segment_info(self, segment_info):
        """
        Path to json file containing segment info. Required if media role is `streaming`.

        :param segment_info: The segment_info of this VideoDefinition.
        :type: str
        """

        self._segment_info = segment_info

    @property
    def size(self):
        """
        File size in bytes.

        :return: The size of this VideoDefinition. 
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """
        File size in bytes.

        :param size: The size of this VideoDefinition.
        :type: int
        """

        self._size = size

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoDefinition):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoDefinition):
            return True

        return self.to_dict() != other.to_dict()
