[uwsgi]
# 必须与nginx配置的一样
{{protocol}} = {{host}}
# uid = root
# pid = root

app_root_path = {{directory}}
app_name = {{project_name}}

# 若使用虚拟环境，配置python虚拟环境地质
#home = %(app_root_path)/venv
home = {{project_venv}}
# 启动文件平级目录
chdir = %(app_root_path)
# python 程序内用以启动的 application 变量名

# python 启动程序文件
wsgi-file = %(app_root_path)/%(app_name)/wsgi.py

callable = app

## 并发数配置（processes 和 threads 与 gevent 2选1）
;# 处理器数
;processes = 4
;# 线程数
;threads = 2
gevent = 2048

# 写入日志
# daemonize =/uwsgi/uwsgi.log

pidfile = /var/run/{{project_name}}.pid

## 请求处理
harakiri = 120
#当一个请求被harakiri杀掉会，会输出一条日志
harakiri-verbose = true

#设置工作进程每处理N个进程就会被回收重启
max-requests = 10000

# buffer-size 默认4k, 4096
buffer-size = 10485760
post-buffering = 10485760
