# Aloy

The content of this repository is currently under development. Eventually, the aim is that this repository will contain a comprehensive suite of algorithms and data structures for artificial intelligence, machine learning, and autonomous robots.

## Current Ideas

- Lead-lag compensators for controllers,
- Control system demonstration and testing GUI,
    - Reimplement master's thesis design, but better!
- Genetic algorithms;
    - Support variable length chromosomes,
    - Support multiple-chromosomes.
- Particle swarm optimisation,
- The Bees algorithm,
- Optimisation test functions,
- Optimisation error surface plotting,
- Optimisation process viewer GUI,
- General reinforcement learning API,
    - Try Ray https://github.com/ray-project/ray and https://docs.ray.io/en/latest/rllib/index.html, and cleanRL https://github.com/vwxyzjn/cleanrl.
- General deep game tree and MCTS API,
- New event flow and command flow system with pub-sub style pattern for GUIs,
- New threadpool system and futures implementation,
- New thread-safe queues implementation,
- Snake game with GUI and RL,
    - Support saving options and highscores,
    - Support recoding games for use as replay and for immitation learning.
- Tetris game with GUI, curses, and RL,
    - Inspiration for GUI https://github.com/janbodnar/PyQt6-Tutorial-Examples, https://doc.qt.io/qt-6/qtwidgets-widgets-tetrix-example.html, and https://gitpress.io/u/1155/pyqt-example-tetrix,
    - Inspiration for curses https://github.com/cSquaerd/CursaTetra, https://github.com/orodley/curses-tetris/blob/master/main.py, https://codereview.stackexchange.com/questions/249326/python-3-curses-terminal-tetris, https://gitlab.com/mkhCurses/tetris-curses-python, https://github.com/adrienmalin/Terminis/tree/master.
- Pacman game with GUI and RL,
- Connect four game with GUI and deep game trees;
    - Take inspiration from http://blog.gamesolver.org/ and https://github.com/PascalPons/connect4.
    - Support playing over socket connection.
- Block breaker game using PyGame,
- Control interface for robots,
- Control and path planning simulator GUI for robots,
- More efficient data holders and multi-table data holders that you can attach to other classse and objects to capture performance statistics,
- Benchmarking tools.
