# Contributing to TorchCraft2
We want to make contributing to this project as easy and transparent as
possible. The `master` branch on this version is considered the source of
truth. All new development of TorchCraft2 should end up as commits or pull
requests here.

## Pull Requests
We actively welcome your pull requests.

## Contributor License Agreement ("CLA")
In order to accept your pull request, we need you to submit a CLA. You only need
to do this once to work on any of Facebook's open source projects.

Complete your CLA here: <https://code.facebook.com/cla>

## Issues
We use GitHub issues to track public bugs. Please ensure your description is
clear and has sufficient instructions to be able to reproduce the issue.

<!--Facebook has a [bounty program](https://www.facebook.com/whitehat/) for the safe
disclosure of security bugs. In those cases, please go through the process
outlined on that page and do not file a public issue.-->

## Coding Style
* for C++: 2 spaces for indentation rather than tabs
* line endings: LF on all files in the repo (be careful not to insert CR LF
  from Windows, configure your editor and/or git client)

## License
By contributing to TorchCraft2, you agree that your contributions will be licensed
under the LICENSE file in the root directory of this source tree.
