import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsManagedZoneConfig extends cdktf.TerraformMetaArguments {
    /**
     * A textual description field. Defaults to 'Managed by Terraform'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#description DnsManagedZone#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The DNS name of this managed zone, for instance "example.com.".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#dns_name DnsManagedZone#dns_name}
     *
     * @stability stable
     */
    readonly dnsName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#force_destroy DnsManagedZone#force_destroy}.
     *
     * @stability stable
     */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
     * A set of key/value label pairs to assign to this ManagedZone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#labels DnsManagedZone#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * User assigned name for this resource. Must be unique within the project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#name DnsManagedZone#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#project DnsManagedZone#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The zone's visibility: public zones are exposed to the Internet, while private zones are visible only to Virtual Private Cloud resources.
     *
     * Default value: "public" Possible values: ["private", "public"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#visibility DnsManagedZone#visibility}
     *
     * @stability stable
     */
    readonly visibility?: string;
    /**
     * dnssec_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#dnssec_config DnsManagedZone#dnssec_config}
     *
     * @stability stable
     */
    readonly dnssecConfig?: DnsManagedZoneDnssecConfig;
    /**
     * forwarding_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#forwarding_config DnsManagedZone#forwarding_config}
     *
     * @stability stable
     */
    readonly forwardingConfig?: DnsManagedZoneForwardingConfig;
    /**
     * peering_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#peering_config DnsManagedZone#peering_config}
     *
     * @stability stable
     */
    readonly peeringConfig?: DnsManagedZonePeeringConfig;
    /**
     * private_visibility_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#private_visibility_config DnsManagedZone#private_visibility_config}
     *
     * @stability stable
     */
    readonly privateVisibilityConfig?: DnsManagedZonePrivateVisibilityConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#timeouts DnsManagedZone#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsManagedZoneTimeouts;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneDnssecConfigDefaultKeySpecs {
    /**
     * String mnemonic specifying the DNSSEC algorithm of this key Possible values: ["ecdsap256sha256", "ecdsap384sha384", "rsasha1", "rsasha256", "rsasha512"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#algorithm DnsManagedZone#algorithm}
     *
     * @stability stable
     */
    readonly algorithm?: string;
    /**
     * Length of the keys in bits.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#key_length DnsManagedZone#key_length}
     *
     * @stability stable
     */
    readonly keyLength?: number;
    /**
     * Specifies whether this is a key signing key (KSK) or a zone signing key (ZSK).
     *
     * Key signing keys have the Secure Entry
     * Point flag set and, when active, will only be used to sign
     * resource record sets of type DNSKEY. Zone signing keys do
     * not have the Secure Entry Point flag set and will be used
     * to sign all other types of resource record sets. Possible values: ["keySigning", "zoneSigning"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#key_type DnsManagedZone#key_type}
     *
     * @stability stable
     */
    readonly keyType?: string;
    /**
     * Identifies what kind of resource this is.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#kind DnsManagedZone#kind}
     *
     * @stability stable
     */
    readonly kind?: string;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneDnssecConfig {
    /**
     * Identifies what kind of resource this is.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#kind DnsManagedZone#kind}
     *
     * @stability stable
     */
    readonly kind?: string;
    /**
     * Specifies the mechanism used to provide authenticated denial-of-existence responses.
     *
     * non_existence can only be updated when the state is 'off'. Possible values: ["nsec", "nsec3"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#non_existence DnsManagedZone#non_existence}
     *
     * @stability stable
     */
    readonly nonExistence?: string;
    /**
     * Specifies whether DNSSEC is enabled, and what mode it is in Possible values: ["off", "on", "transfer"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#state DnsManagedZone#state}
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * default_key_specs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#default_key_specs DnsManagedZone#default_key_specs}
     *
     * @stability stable
     */
    readonly defaultKeySpecs?: DnsManagedZoneDnssecConfigDefaultKeySpecs[];
}
/**
 * @stability stable
 */
export declare class DnsManagedZoneDnssecConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _kind?;
    /**
     * @stability stable
     */
    get kind(): string | undefined;
    /**
     * @stability stable
     */
    set kind(value: string | undefined);
    /**
     * @stability stable
     */
    resetKind(): void;
    /**
     * @stability stable
     */
    get kindInput(): string | undefined;
    private _nonExistence?;
    /**
     * @stability stable
     */
    get nonExistence(): string | undefined;
    /**
     * @stability stable
     */
    set nonExistence(value: string | undefined);
    /**
     * @stability stable
     */
    resetNonExistence(): void;
    /**
     * @stability stable
     */
    get nonExistenceInput(): string | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string | undefined;
    /**
     * @stability stable
     */
    set state(value: string | undefined);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    private _defaultKeySpecs?;
    /**
     * @stability stable
     */
    get defaultKeySpecs(): DnsManagedZoneDnssecConfigDefaultKeySpecs[] | undefined;
    /**
     * @stability stable
     */
    set defaultKeySpecs(value: DnsManagedZoneDnssecConfigDefaultKeySpecs[] | undefined);
    /**
     * @stability stable
     */
    resetDefaultKeySpecs(): void;
    /**
     * @stability stable
     */
    get defaultKeySpecsInput(): DnsManagedZoneDnssecConfigDefaultKeySpecs[] | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneForwardingConfigTargetNameServers {
    /**
     * Forwarding path for this TargetNameServer.
     *
     * If unset or 'default' Cloud DNS will make forwarding
     * decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
     * to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#forwarding_path DnsManagedZone#forwarding_path}
     *
     * @stability stable
     */
    readonly forwardingPath?: string;
    /**
     * IPv4 address of a target name server.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#ipv4_address DnsManagedZone#ipv4_address}
     *
     * @stability stable
     */
    readonly ipv4Address: string;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneForwardingConfig {
    /**
     * target_name_servers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#target_name_servers DnsManagedZone#target_name_servers}
     *
     * @stability stable
     */
    readonly targetNameServers: DnsManagedZoneForwardingConfigTargetNameServers[];
}
/**
 * @stability stable
 */
export declare class DnsManagedZoneForwardingConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _targetNameServers?;
    /**
     * @stability stable
     */
    get targetNameServers(): DnsManagedZoneForwardingConfigTargetNameServers[];
    /**
     * @stability stable
     */
    set targetNameServers(value: DnsManagedZoneForwardingConfigTargetNameServers[]);
    /**
     * @stability stable
     */
    get targetNameServersInput(): DnsManagedZoneForwardingConfigTargetNameServers[] | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZonePeeringConfigTargetNetwork {
    /**
     * The id or fully qualified URL of the VPC network to forward queries to.
     *
     * This should be formatted like 'projects/{project}/global/networks/{network}' or
     * 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#network_url DnsManagedZone#network_url}
     *
     * @stability stable
     */
    readonly networkUrl: string;
}
/**
 * @stability stable
 */
export declare class DnsManagedZonePeeringConfigTargetNetworkOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _networkUrl?;
    /**
     * @stability stable
     */
    get networkUrl(): string;
    /**
     * @stability stable
     */
    set networkUrl(value: string);
    /**
     * @stability stable
     */
    get networkUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZonePeeringConfig {
    /**
     * target_network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#target_network DnsManagedZone#target_network}
     *
     * @stability stable
     */
    readonly targetNetwork: DnsManagedZonePeeringConfigTargetNetwork;
}
/**
 * @stability stable
 */
export declare class DnsManagedZonePeeringConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _targetNetwork?;
    private __targetNetworkOutput;
    /**
     * @stability stable
     */
    get targetNetwork(): DnsManagedZonePeeringConfigTargetNetworkOutputReference;
    /**
     * @stability stable
     */
    putTargetNetwork(value: DnsManagedZonePeeringConfigTargetNetwork): void;
    /**
     * @stability stable
     */
    get targetNetworkInput(): DnsManagedZonePeeringConfigTargetNetwork | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZonePrivateVisibilityConfigNetworks {
    /**
     * The id or fully qualified URL of the VPC network to bind to. This should be formatted like 'projects/{project}/global/networks/{network}' or 'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#network_url DnsManagedZone#network_url}
     *
     * @stability stable
     */
    readonly networkUrl: string;
}
/**
 * @stability stable
 */
export interface DnsManagedZonePrivateVisibilityConfig {
    /**
     * networks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#networks DnsManagedZone#networks}
     *
     * @stability stable
     */
    readonly networks: DnsManagedZonePrivateVisibilityConfigNetworks[];
}
/**
 * @stability stable
 */
export declare class DnsManagedZonePrivateVisibilityConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _networks?;
    /**
     * @stability stable
     */
    get networks(): DnsManagedZonePrivateVisibilityConfigNetworks[];
    /**
     * @stability stable
     */
    set networks(value: DnsManagedZonePrivateVisibilityConfigNetworks[]);
    /**
     * @stability stable
     */
    get networksInput(): DnsManagedZonePrivateVisibilityConfigNetworks[] | undefined;
}
/**
 * @stability stable
 */
export interface DnsManagedZoneTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#create DnsManagedZone#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#delete DnsManagedZone#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html#update DnsManagedZone#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class DnsManagedZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html google_dns_managed_zone}.
 *
 * @stability stable
 */
export declare class DnsManagedZone extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone.html google_dns_managed_zone} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsManagedZoneConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _dnsName?;
    /**
     * @stability stable
     */
    get dnsName(): string;
    /**
     * @stability stable
     */
    set dnsName(value: string);
    /**
     * @stability stable
     */
    get dnsNameInput(): string | undefined;
    private _forceDestroy?;
    /**
     * @stability stable
     */
    get forceDestroy(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set forceDestroy(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetForceDestroy(): void;
    /**
     * @stability stable
     */
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get nameServers(): string[];
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _visibility?;
    /**
     * @stability stable
     */
    get visibility(): string | undefined;
    /**
     * @stability stable
     */
    set visibility(value: string | undefined);
    /**
     * @stability stable
     */
    resetVisibility(): void;
    /**
     * @stability stable
     */
    get visibilityInput(): string | undefined;
    private _dnssecConfig?;
    private __dnssecConfigOutput;
    /**
     * @stability stable
     */
    get dnssecConfig(): DnsManagedZoneDnssecConfigOutputReference;
    /**
     * @stability stable
     */
    putDnssecConfig(value: DnsManagedZoneDnssecConfig | undefined): void;
    /**
     * @stability stable
     */
    resetDnssecConfig(): void;
    /**
     * @stability stable
     */
    get dnssecConfigInput(): DnsManagedZoneDnssecConfig | undefined;
    private _forwardingConfig?;
    private __forwardingConfigOutput;
    /**
     * @stability stable
     */
    get forwardingConfig(): DnsManagedZoneForwardingConfigOutputReference;
    /**
     * @stability stable
     */
    putForwardingConfig(value: DnsManagedZoneForwardingConfig | undefined): void;
    /**
     * @stability stable
     */
    resetForwardingConfig(): void;
    /**
     * @stability stable
     */
    get forwardingConfigInput(): DnsManagedZoneForwardingConfig | undefined;
    private _peeringConfig?;
    private __peeringConfigOutput;
    /**
     * @stability stable
     */
    get peeringConfig(): DnsManagedZonePeeringConfigOutputReference;
    /**
     * @stability stable
     */
    putPeeringConfig(value: DnsManagedZonePeeringConfig | undefined): void;
    /**
     * @stability stable
     */
    resetPeeringConfig(): void;
    /**
     * @stability stable
     */
    get peeringConfigInput(): DnsManagedZonePeeringConfig | undefined;
    private _privateVisibilityConfig?;
    private __privateVisibilityConfigOutput;
    /**
     * @stability stable
     */
    get privateVisibilityConfig(): DnsManagedZonePrivateVisibilityConfigOutputReference;
    /**
     * @stability stable
     */
    putPrivateVisibilityConfig(value: DnsManagedZonePrivateVisibilityConfig | undefined): void;
    /**
     * @stability stable
     */
    resetPrivateVisibilityConfig(): void;
    /**
     * @stability stable
     */
    get privateVisibilityConfigInput(): DnsManagedZonePrivateVisibilityConfig | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): DnsManagedZoneTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DnsManagedZoneTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsManagedZoneTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
