"""Initial migration

Revision ID: 5e787d339651
Revises:
Create Date: 2021-05-30 22:48:16.596998

"""
import basis
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "5e787d339651"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "_basis_data_block_metadata",
        sa.Column("dataspace_key", sa.String(length=64), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.String(length=128), nullable=False),
        sa.Column("inferred_schema_key", sa.String(length=128), nullable=True),
        sa.Column("nominal_schema_key", sa.String(length=128), nullable=True),
        sa.Column("realized_schema_key", sa.String(length=128), nullable=False),
        sa.Column("record_count", sa.Integer(), nullable=True),
        sa.Column("created_by_node_key", sa.String(length=128), nullable=True),
        sa.Column("deleted", sa.Boolean(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "_basis_data_function_log",
        sa.Column("dataspace_key", sa.String(length=64), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("node_key", sa.String(length=128), nullable=False),
        sa.Column("node_start_state", sa.JSON(), nullable=True),
        sa.Column("node_end_state", sa.JSON(), nullable=True),
        sa.Column("function_key", sa.String(length=128), nullable=False),
        sa.Column("function_params", sa.JSON(), nullable=True),
        sa.Column("runtime_url", sa.String(length=128), nullable=True),
        sa.Column("queued_at", sa.DateTime(), nullable=True),
        sa.Column("started_at", sa.DateTime(), nullable=True),
        sa.Column("completed_at", sa.DateTime(), nullable=True),
        sa.Column("error", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "_basis_generated_schema",
        sa.Column("dataspace_key", sa.String(length=64), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("key", sa.String(length=128), nullable=False),
        sa.Column("definition", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("key"),
    )
    op.create_table(
        "_basis_node_state",
        sa.Column("dataspace_key", sa.String(length=64), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("node_key", sa.String(length=128), nullable=True),
        sa.Column("state", sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("dataspace_key", "node_key"),
    )
    op.create_table(
        "_basis_data_block_log",
        sa.Column("dataspace_key", sa.String(length=64), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("function_log_id", sa.Integer(), nullable=False),
        sa.Column("data_block_id", sa.String(length=128), nullable=False),
        sa.Column("stream_name", sa.String(length=128), nullable=True),
        sa.Column(
            "direction",
            sa.Enum("INPUT", "OUTPUT", name="direction", native_enum=False),
            nullable=False,
        ),
        sa.Column("processed_at", sa.DateTime(), nullable=False),
        sa.Column("invalidated", sa.Boolean(), nullable=True),
        sa.ForeignKeyConstraint(["data_block_id"], ["_basis_data_block_metadata.id"],),
        sa.ForeignKeyConstraint(["function_log_id"], ["_basis_data_function_log.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "_basis_stored_data_block_metadata",
        sa.Column("dataspace_key", sa.String(length=64), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.String(length=128), nullable=False),
        sa.Column("name", sa.String(length=128), nullable=True),
        sa.Column("data_block_id", sa.String(length=128), nullable=False),
        sa.Column("storage_url", sa.String(length=128), nullable=False),
        sa.Column(
            "data_format",
            basis.core.persistence.base.DataFormatType(length=128),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(["data_block_id"], ["_basis_data_block_metadata.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "_basis_alias",
        sa.Column("dataspace_key", sa.String(length=64), nullable=True),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(length=128), nullable=True),
        sa.Column("data_block_id", sa.String(length=128), nullable=False),
        sa.Column("stored_data_block_id", sa.String(length=128), nullable=False),
        sa.ForeignKeyConstraint(["data_block_id"], ["_basis_data_block_metadata.id"],),
        sa.ForeignKeyConstraint(
            ["stored_data_block_id"], ["_basis_stored_data_block_metadata.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("dataspace_key", "name"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("_basis_alias")
    op.drop_table("_basis_stored_data_block_metadata")
    op.drop_table("_basis_data_block_log")
    op.drop_table("_basis_node_state")
    op.drop_table("_basis_generated_schema")
    op.drop_table("_basis_data_function_log")
    op.drop_table("_basis_data_block_metadata")
    # ### end Alembic commands ###
