"""Node state

Revision ID: 722cbaa0a8d2
Revises: 5e787d339651
Create Date: 2021-06-02 18:45:13.914083

"""
import basis
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "722cbaa0a8d2"
down_revision = "5e787d339651"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("_basis_node_state", schema=None) as batch_op:
        batch_op.add_column(sa.Column("latest_log_id", sa.Integer(), nullable=True),)
        batch_op.add_column(
            sa.Column("blocks_output_stdout", sa.Integer(), nullable=True),
        )
        batch_op.add_column(
            sa.Column("blocks_output_all", sa.Integer(), nullable=True),
        )
        batch_op.create_foreign_key(
            "fk_node_state_latest_log_id",
            "_basis_data_function_log",
            ["latest_log_id"],
            ["id"],
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "fk_node_state_latest_log_id", "_basis_node_state", type_="foreignkey"
    )
    op.drop_column("_basis_node_state", "blocks_output_all")
    op.drop_column("_basis_node_state", "blocks_output_stdout")
    op.drop_column("_basis_node_state", "latest_log_id")
    # ### end Alembic commands ###
