"""Alias storage url

Revision ID: 83486b160cf0
Revises: 722cbaa0a8d2
Create Date: 2021-06-07 17:18:11.119780

"""
import basis
import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "83486b160cf0"
down_revision = "722cbaa0a8d2"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("_basis_alias", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("storage_url", sa.String(length=128), nullable=True)
        )
        bind = op.get_bind()
        if bind.engine.name != "sqlite":
            batch_op.drop_constraint(
                "_basis_alias_dataspace_key_name_key", type_="unique"
            )
        batch_op.create_unique_constraint(
            "_basis_alias_dataspace_key_name_storage_url_key",
            ["dataspace_key", "name", "storage_url"],
        )
    with op.batch_alter_table(
        "_basis_stored_data_block_metadata", schema=None
    ) as batch_op:
        batch_op.alter_column(
            "name", existing_type=sa.VARCHAR(length=128), nullable=False
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "_basis_stored_data_block_metadata",
        "name",
        existing_type=sa.VARCHAR(length=128),
        nullable=True,
    )
    op.drop_constraint(None, "_basis_alias", type_="unique")
    op.create_unique_constraint(
        "_basis_alias_dataspace_key_name_key",
        "_basis_alias",
        ["dataspace_key", "name"],
    )
    op.drop_column("_basis_alias", "storage_url")
    # ### end Alembic commands ###
