"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
/**
 * Creates an Identity Pool with sane defaults configured.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        if (!props?.userPool) {
            this.userPool = new aws_cognito_1.UserPool(this, "UserPool");
            this.userPoolClient = this.userPool.addClient("WebClient", {
                authFlows: {
                    userPassword: true,
                    userSrp: true,
                },
            });
        }
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", {
            ...props?.identityPoolOptions,
            authenticationProviders: {
                ...props?.identityPoolOptions?.authenticationProviders,
                userPools: [
                    ...(props?.identityPoolOptions?.authenticationProviders?.userPools ||
                        []),
                    ...(this.userPool
                        ? [new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({ userPool: this.userPool })]
                        : []),
                ],
            },
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.2.5" };
//# sourceMappingURL=data:application/json;base64,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