"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Application = exports.ApplicationProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const sae_generated_1 = require("./sae.generated");
Object.defineProperty(exports, "ApplicationProperty", { enumerable: true, get: function () { return sae_generated_1.RosApplication; } });
/**
 * A ROS resource type:  `ALIYUN::SAE::Application`
 */
class Application extends ros.Resource {
    /**
     * Create a new `ALIYUN::SAE::Application`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosApplication = new sae_generated_1.RosApplication(this, id, {
            timezone: props.timezone,
            appDescription: props.appDescription,
            mountDesc: props.mountDesc,
            nasId: props.nasId,
            warStartOptions: props.warStartOptions,
            liveness: props.liveness,
            memory: props.memory,
            webContainer: props.webContainer,
            slsConfigs: props.slsConfigs,
            cpu: props.cpu,
            deploy: props.deploy,
            packageVersion: props.packageVersion,
            appName: props.appName,
            jdk: props.jdk,
            jarStartArgs: props.jarStartArgs,
            preStop: props.preStop,
            readiness: props.readiness,
            packageType: props.packageType,
            commandArgs: props.commandArgs,
            securityGroupId: props.securityGroupId,
            envs: props.envs,
            vSwitchId: props.vSwitchId,
            imageUrl: props.imageUrl,
            postStart: props.postStart,
            jarStartOptions: props.jarStartOptions,
            mountHost: props.mountHost,
            replicas: props.replicas,
            customHostAlias: props.customHostAlias,
            vpcId: props.vpcId,
            command: props.command,
            edasContainerVersion: props.edasContainerVersion,
            packageUrl: props.packageUrl,
            namespaceId: props.namespaceId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosApplication;
        this.attrAppId = rosApplication.attrAppId;
        this.attrChangeOrderId = rosApplication.attrChangeOrderId;
    }
}
exports.Application = Application;
//# sourceMappingURL=data:application/json;base64,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