"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlbBinding = exports.SlbBindingProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const sae_generated_1 = require("./sae.generated");
Object.defineProperty(exports, "SlbBindingProperty", { enumerable: true, get: function () { return sae_generated_1.RosSlbBinding; } });
/**
 * A ROS resource type:  `ALIYUN::SAE::SlbBinding`
 */
class SlbBinding extends ros.Resource {
    /**
     * Create a new `ALIYUN::SAE::SlbBinding`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSlbBinding = new sae_generated_1.RosSlbBinding(this, id, {
            internetSlbId: props.internetSlbId,
            appId: props.appId,
            intranet: props.intranet,
            intranetSlbId: props.intranetSlbId,
            internet: props.internet,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSlbBinding;
        this.attrAppId = rosSlbBinding.attrAppId;
        this.attrChangeOrderId = rosSlbBinding.attrChangeOrderId;
    }
}
exports.SlbBinding = SlbBinding;
//# sourceMappingURL=data:application/json;base64,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