import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeGlobalNetworkEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Fully qualified domain name of network endpoint. This can only be specified when network_endpoint_type of the NEG is INTERNET_FQDN_PORT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html#fqdn ComputeGlobalNetworkEndpoint#fqdn}
     *
     * @stability stable
     */
    readonly fqdn?: string;
    /**
     * The global network endpoint group this endpoint is part of.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html#global_network_endpoint_group ComputeGlobalNetworkEndpoint#global_network_endpoint_group}
     *
     * @stability stable
     */
    readonly globalNetworkEndpointGroup: string;
    /**
     * IPv4 address external endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html#ip_address ComputeGlobalNetworkEndpoint#ip_address}
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Port number of the external endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html#port ComputeGlobalNetworkEndpoint#port}
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html#project ComputeGlobalNetworkEndpoint#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html#timeouts ComputeGlobalNetworkEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeGlobalNetworkEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeGlobalNetworkEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html#create ComputeGlobalNetworkEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html#delete ComputeGlobalNetworkEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
/**
 * @stability stable
 */
export declare class ComputeGlobalNetworkEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html google_compute_global_network_endpoint}.
 *
 * @stability stable
 */
export declare class ComputeGlobalNetworkEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_global_network_endpoint.html google_compute_global_network_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeGlobalNetworkEndpointConfig);
    private _fqdn?;
    /**
     * @stability stable
     */
    get fqdn(): string | undefined;
    /**
     * @stability stable
     */
    set fqdn(value: string | undefined);
    /**
     * @stability stable
     */
    resetFqdn(): void;
    /**
     * @stability stable
     */
    get fqdnInput(): string | undefined;
    private _globalNetworkEndpointGroup?;
    /**
     * @stability stable
     */
    get globalNetworkEndpointGroup(): string;
    /**
     * @stability stable
     */
    set globalNetworkEndpointGroup(value: string);
    /**
     * @stability stable
     */
    get globalNetworkEndpointGroupInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipAddress?;
    /**
     * @stability stable
     */
    get ipAddress(): string | undefined;
    /**
     * @stability stable
     */
    set ipAddress(value: string | undefined);
    /**
     * @stability stable
     */
    resetIpAddress(): void;
    /**
     * @stability stable
     */
    get ipAddressInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): ComputeGlobalNetworkEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeGlobalNetworkEndpointTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeGlobalNetworkEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
