import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HealthcareHl7V2StoreIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#hl7_v2_store_id HealthcareHl7V2StoreIamMember#hl7_v2_store_id}.
     *
     * @stability stable
     */
    readonly hl7V2StoreId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#member HealthcareHl7V2StoreIamMember#member}.
     *
     * @stability stable
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#role HealthcareHl7V2StoreIamMember#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#condition HealthcareHl7V2StoreIamMember#condition}
     *
     * @stability stable
     */
    readonly condition?: HealthcareHl7V2StoreIamMemberCondition;
}
/**
 * @stability stable
 */
export interface HealthcareHl7V2StoreIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#description HealthcareHl7V2StoreIamMember#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#expression HealthcareHl7V2StoreIamMember#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html#title HealthcareHl7V2StoreIamMember#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
/**
 * @stability stable
 */
export declare class HealthcareHl7V2StoreIamMemberConditionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string | undefined;
    /**
     * @stability stable
     */
    set description(value: string | undefined);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html google_healthcare_hl7_v2_store_iam_member}.
 *
 * @stability stable
 */
export declare class HealthcareHl7V2StoreIamMember extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_hl7_v2_store_iam_member.html google_healthcare_hl7_v2_store_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HealthcareHl7V2StoreIamMemberConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    private _hl7V2StoreId?;
    /**
     * @stability stable
     */
    get hl7V2StoreId(): string;
    /**
     * @stability stable
     */
    set hl7V2StoreId(value: string);
    /**
     * @stability stable
     */
    get hl7V2StoreIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _member?;
    /**
     * @stability stable
     */
    get member(): string;
    /**
     * @stability stable
     */
    set member(value: string);
    /**
     * @stability stable
     */
    get memberInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _condition?;
    private __conditionOutput;
    /**
     * @stability stable
     */
    get condition(): HealthcareHl7V2StoreIamMemberConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: HealthcareHl7V2StoreIamMemberCondition | undefined): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): HealthcareHl7V2StoreIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
