import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageBucketAccessControlConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#bucket StorageBucketAccessControl#bucket}
     *
     * @stability stable
     */
    readonly bucket: string;
    /**
     * The entity holding the permission, in one of the following forms: user-userId user-email group-groupId group-email domain-domain project-team-projectId allUsers allAuthenticatedUsers Examples: The user liz@example.com would be user-liz@example.com. The group example@googlegroups.com would be group-example@googlegroups.com. To refer to all members of the Google Apps for Business domain example.com, the entity would be domain-example.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#entity StorageBucketAccessControl#entity}
     *
     * @stability stable
     */
    readonly entity: string;
    /**
     * The access permission for the entity. Possible values: ["OWNER", "READER", "WRITER"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#role StorageBucketAccessControl#role}
     *
     * @stability stable
     */
    readonly role?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#timeouts StorageBucketAccessControl#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: StorageBucketAccessControlTimeouts;
}
/**
 * @stability stable
 */
export interface StorageBucketAccessControlTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#create StorageBucketAccessControl#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#delete StorageBucketAccessControl#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html#update StorageBucketAccessControl#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class StorageBucketAccessControlTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html google_storage_bucket_access_control}.
 *
 * @stability stable
 */
export declare class StorageBucketAccessControl extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_access_control.html google_storage_bucket_access_control} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageBucketAccessControlConfig);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get domain(): string;
    /**
     * @stability stable
     */
    get email(): string;
    private _entity?;
    /**
     * @stability stable
     */
    get entity(): string;
    /**
     * @stability stable
     */
    set entity(value: string);
    /**
     * @stability stable
     */
    get entityInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string | undefined;
    /**
     * @stability stable
     */
    set role(value: string | undefined);
    /**
     * @stability stable
     */
    resetRole(): void;
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): StorageBucketAccessControlTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: StorageBucketAccessControlTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): StorageBucketAccessControlTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
