import pandas as pd
import pytest
from pandas._libs.tslibs.timestamps import Timestamp


@pytest.fixture(scope="module")
def tank_two_input():
    return [
        {
            "product": "UNLEADED 88",
            "read_time": "2020-07-22T12:35:01",
            "run_time": "2020-07-22T12:35:01",
            "store_number": "KT110",
            "tank_id": "1",
            "temperature": 66.5836944411236,
            "volume": 13284.172673874453,
        },
        {
            "product": "UNLEADED 88",
            "read_time": "2020-07-22T12:24:01",
            "run_time": "2020-07-22T12:24:00",
            "store_number": "KT110",
            "tank_id": "1",
            "temperature": 66.5805883403786,
            "volume": 13298.881427020242,
        },
    ]


@pytest.fixture(scope="module")
def tank_little_input():
    return [
        {
            "product": "UNLEADED 88",
            "read_time": "2020-07-22T12:35:01",
            "run_time": "2020-07-22T12:35:01",
            "store_number": "KT110",
            "tank_id": "1",
            "temperature": 66.5836944411236,
            "volume": 13284.172673874453,
        },
        {
            "product": "UNLEADED 88",
            "read_time": "2020-07-22T12:24:01",
            "run_time": "2020-07-22T12:24:00",
            "store_number": "KT110",
            "tank_id": "1",
            "temperature": 66.5805883403786,
            "volume": 13298.881427020242,
        },
        {
            "product": "UNLEADED 88",
            "read_time": "2020-07-22T12:15:01",
            "run_time": "2020-07-22T12:15:00",
            "store_number": "KT110",
            "tank_id": "1",
            "temperature": 66.5805883403786,
            "volume": 1410.881427020242,
        },
        {
            "product": "UNLEADED 88",
            "read_time": "2020-07-22T11:55:01",
            "run_time": "2020-07-22T11:55:00",
            "store_number": "KT110",
            "tank_id": "1",
            "temperature": 66.5805883403786,
            "volume": 1450.881427020242,
        },
        {
            "product": "UNLEADED 88",
            "read_time": "2020-07-22T11:25:01",
            "run_time": "2020-07-22T11:25:00",
            "store_number": "KT110",
            "tank_id": "1",
            "temperature": 66.5805883403786,
            "volume": 1470.881427020242,
        },
    ]


@pytest.fixture(scope="module")
def sales_little_input():
    return [
        {
            "store": "103",
            "date": "2017-06-05",
            "tank_id": "1",
            "tank_type": "304",
            "sales": 23,
        },
        {
            "store": "103",
            "date": "2017-06-04",
            "tank_id": "1",
            "tank_type": "304",
            "sales": 51,
        },
        {
            "store": "103",
            "date": "2017-06-03",
            "tank_id": "1",
            "tank_type": "304",
            "sales": 43,
        },
        {
            "store": "103",
            "date": "2017-06-02",
            "tank_id": "1",
            "tank_type": "304",
            "sales": 10,
        },
    ]


@pytest.fixture(scope="module")
def tank_little_data():
    df = pd.DataFrame(
        data=[
            ["2020-07-04 13:30:00", 25],
            ["2020-07-04 14:00:00", 50],
            ["2020-07-04 14:30:00", 75],
            ["2020-07-04 15:00:00", 50],
            ["2020-07-04 15:30:00", 50],
        ],
        columns=["ds", "y"],
    )

    df.ds = pd.to_datetime(df.ds)

    return df


@pytest.fixture(scope="module")
def tank_full_data():
    df = pd.DataFrame(
        data=[
            {"ds": Timestamp("2020-08-15 00:30:00"), "y": 60.19532441410047},
            {"ds": Timestamp("2020-08-15 01:00:00"), "y": 114.66689292660885},
            {"ds": Timestamp("2020-08-15 01:30:00"), "y": 110.82572737461123},
            {"ds": Timestamp("2020-08-15 02:00:00"), "y": 49.20512941295419},
            {"ds": Timestamp("2020-08-15 02:30:00"), "y": 80.11680515409444},
            {"ds": Timestamp("2020-08-15 03:00:00"), "y": 66.17654127167134},
            {"ds": Timestamp("2020-08-15 03:30:00"), "y": 49.91669913383703},
            {"ds": Timestamp("2020-08-15 04:00:00"), "y": 43.33902194598522},
            {"ds": Timestamp("2020-08-15 04:30:00"), "y": 15.907126098701156},
            {"ds": Timestamp("2020-08-15 05:00:00"), "y": 27.926801826884912},
            {"ds": Timestamp("2020-08-15 05:30:00"), "y": 0.1598226384157897},
            {"ds": Timestamp("2020-08-15 06:00:00"), "y": 0.28052437526184804},
            {"ds": Timestamp("2020-08-15 06:30:00"), "y": 27.57890496766413},
            {"ds": Timestamp("2020-08-15 07:00:00"), "y": 15.087369517258594},
            {"ds": Timestamp("2020-08-15 07:30:00"), "y": 16.318279757390883},
            {"ds": Timestamp("2020-08-15 08:00:00"), "y": 0.20000954591705522},
            {"ds": Timestamp("2020-08-15 08:30:00"), "y": 0.2663348640762706},
            {"ds": Timestamp("2020-08-15 09:00:00"), "y": 0.3189971128676916},
            {"ds": Timestamp("2020-08-15 09:30:00"), "y": 0.2958171985701483},
            {"ds": Timestamp("2020-08-15 10:00:00"), "y": 24.290914856189374},
            {"ds": Timestamp("2020-08-15 10:30:00"), "y": 0.2521618290056722},
            {"ds": Timestamp("2020-08-15 11:00:00"), "y": 31.7458606732298},
            {"ds": Timestamp("2020-08-15 11:30:00"), "y": 41.55954482110246},
            {"ds": Timestamp("2020-08-15 12:00:00"), "y": 85.67254971408966},
            {"ds": Timestamp("2020-08-15 12:30:00"), "y": 121.71649225636975},
            {"ds": Timestamp("2020-08-15 13:00:00"), "y": 99.01991269644986},
            {"ds": Timestamp("2020-08-15 13:30:00"), "y": 33.65552397796364},
            {"ds": Timestamp("2020-08-15 14:00:00"), "y": 314.00573930499013},
            {"ds": Timestamp("2020-08-15 14:30:00"), "y": 68.77085179066307},
            {"ds": Timestamp("2020-08-15 15:00:00"), "y": 297.2495078747015},
            {"ds": Timestamp("2020-08-15 15:30:00"), "y": 228.53148729817258},
            {"ds": Timestamp("2020-08-15 16:00:00"), "y": 171.08460865768757},
            {"ds": Timestamp("2020-08-15 16:30:00"), "y": 244.27456041173537},
            {"ds": Timestamp("2020-08-15 17:00:00"), "y": 215.10884988254838},
            {"ds": Timestamp("2020-08-15 17:30:00"), "y": 357.4258941793323},
            {"ds": Timestamp("2020-08-15 18:00:00"), "y": 126.69954366083948},
            {"ds": Timestamp("2020-08-15 18:30:00"), "y": 170.1417486247392},
            {"ds": Timestamp("2020-08-15 19:00:00"), "y": 230.32968756071205},
            {"ds": Timestamp("2020-08-15 19:30:00"), "y": 334.8857219982201},
            {"ds": Timestamp("2020-08-15 20:00:00"), "y": 92.07115966861602},
            {"ds": Timestamp("2020-08-15 20:30:00"), "y": 216.3223744426923},
            {"ds": Timestamp("2020-08-15 21:00:00"), "y": 158.89114668567163},
            {"ds": Timestamp("2020-08-15 21:30:00"), "y": 67.38125072477487},
            {"ds": Timestamp("2020-08-15 22:00:00"), "y": 168.72399575352028},
            {"ds": Timestamp("2020-08-15 22:30:00"), "y": 137.91929061088558},
            {"ds": Timestamp("2020-08-15 23:00:00"), "y": 78.99010547532453},
            {"ds": Timestamp("2020-08-15 23:30:00"), "y": 34.713934895075},
            {"ds": Timestamp("2020-08-16 00:00:00"), "y": 100.41297789297641},
            {"ds": Timestamp("2020-08-16 00:30:00"), "y": 53.42944093827646},
            {"ds": Timestamp("2020-08-16 01:00:00"), "y": 52.96278883220111},
            {"ds": Timestamp("2020-08-16 01:30:00"), "y": 27.145533988534226},
            {"ds": Timestamp("2020-08-16 02:00:00"), "y": 68.72123493637446},
            {"ds": Timestamp("2020-08-16 02:30:00"), "y": 107.05444107616313},
            {"ds": Timestamp("2020-08-16 03:00:00"), "y": 52.83272048699473},
            {"ds": Timestamp("2020-08-16 03:30:00"), "y": 46.362071457584534},
            {"ds": Timestamp("2020-08-16 04:00:00"), "y": 74.31947877343555},
            {"ds": Timestamp("2020-08-16 04:30:00"), "y": 33.886170441304785},
            {"ds": Timestamp("2020-08-16 05:00:00"), "y": 11.95540073174925},
            {"ds": Timestamp("2020-08-16 05:30:00"), "y": 16.867858009449265},
            {"ds": Timestamp("2020-08-16 06:00:00"), "y": 0.19315645291317196},
            {"ds": Timestamp("2020-08-16 06:30:00"), "y": 0.11562296070405864},
            {"ds": Timestamp("2020-08-16 07:00:00"), "y": 0.17437272896859213},
            {"ds": Timestamp("2020-08-16 07:30:00"), "y": 0.32883342972672835},
            {"ds": Timestamp("2020-08-16 08:00:00"), "y": 10.04914239169375},
            {"ds": Timestamp("2020-08-16 08:30:00"), "y": 12.844455387483322},
            {"ds": Timestamp("2020-08-16 09:00:00"), "y": 0.026255900053001824},
            {"ds": Timestamp("2020-08-16 09:30:00"), "y": 21.981041635101064},
            {"ds": Timestamp("2020-08-16 10:00:00"), "y": 0.4745404823061108},
            {"ds": Timestamp("2020-08-16 10:30:00"), "y": 0.2602453390154551},
            {"ds": Timestamp("2020-08-16 11:00:00"), "y": 64.48285626345387},
            {"ds": Timestamp("2020-08-16 11:30:00"), "y": 27.66179286372062},
            {"ds": Timestamp("2020-08-16 12:00:00"), "y": 26.59753164155154},
            {"ds": Timestamp("2020-08-16 12:30:00"), "y": 51.785724344566916},
            {"ds": Timestamp("2020-08-16 13:00:00"), "y": 78.41907149649887},
            {"ds": Timestamp("2020-08-16 13:30:00"), "y": 110.92858239824454},
            {"ds": Timestamp("2020-08-16 14:00:00"), "y": 133.1805506968194},
            {"ds": Timestamp("2020-08-16 14:30:00"), "y": 267.46103953888087},
            {"ds": Timestamp("2020-08-16 15:00:00"), "y": 241.4192547382154},
            {"ds": Timestamp("2020-08-16 15:30:00"), "y": 165.1260871348586},
            {"ds": Timestamp("2020-08-16 16:00:00"), "y": 133.41208304066822},
            {"ds": Timestamp("2020-08-16 16:30:00"), "y": 252.71330116244098},
            {"ds": Timestamp("2020-08-16 17:00:00"), "y": 272.7450502298216},
            {"ds": Timestamp("2020-08-16 17:30:00"), "y": 252.77830663785699},
            {"ds": Timestamp("2020-08-16 18:00:00"), "y": 128.487561163608},
            {"ds": Timestamp("2020-08-16 18:30:00"), "y": 207.92653692157546},
            {"ds": Timestamp("2020-08-16 19:00:00"), "y": 220.84723049632703},
            {"ds": Timestamp("2020-08-16 19:30:00"), "y": 99.03820093617105},
            {"ds": Timestamp("2020-08-16 20:00:00"), "y": 168.6052617323794},
            {"ds": Timestamp("2020-08-16 20:30:00"), "y": 94.87250752922955},
            {"ds": Timestamp("2020-08-16 21:00:00"), "y": 143.5761479619332},
            {"ds": Timestamp("2020-08-16 21:30:00"), "y": 61.311818369817956},
            {"ds": Timestamp("2020-08-16 22:00:00"), "y": 105.33938651501921},
            {"ds": Timestamp("2020-08-16 22:30:00"), "y": 139.8119799799606},
            {"ds": Timestamp("2020-08-16 23:00:00"), "y": 49.96484778711056},
            {"ds": Timestamp("2020-08-16 23:30:00"), "y": 88.1826157165251},
            {"ds": Timestamp("2020-08-17 00:00:00"), "y": 74.49907696427908},
            {"ds": Timestamp("2020-08-17 00:30:00"), "y": 70.96692315368273},
            {"ds": Timestamp("2020-08-17 01:00:00"), "y": 86.58851932579273},
            {"ds": Timestamp("2020-08-17 01:30:00"), "y": 37.23032042363775},
            {"ds": Timestamp("2020-08-17 02:00:00"), "y": 45.2332924641687},
            {"ds": Timestamp("2020-08-17 02:30:00"), "y": 17.908414596086004},
            {"ds": Timestamp("2020-08-17 03:00:00"), "y": 24.478688306349795},
            {"ds": Timestamp("2020-08-17 03:30:00"), "y": 30.82162158779647},
            {"ds": Timestamp("2020-08-17 04:00:00"), "y": 5.641800662464448},
            {"ds": Timestamp("2020-08-17 04:30:00"), "y": 29.802015213550476},
            {"ds": Timestamp("2020-08-17 05:00:00"), "y": 0.2908613021609199},
            {"ds": Timestamp("2020-08-17 05:30:00"), "y": 0.11400113669333223},
            {"ds": Timestamp("2020-08-17 06:00:00"), "y": 0.3409830959044484},
            {"ds": Timestamp("2020-08-17 06:30:00"), "y": 0.17488685159150918},
            {"ds": Timestamp("2020-08-17 07:00:00"), "y": 0.1743077340815944},
            {"ds": Timestamp("2020-08-17 07:30:00"), "y": 0.3168034630616603},
            {"ds": Timestamp("2020-08-17 08:00:00"), "y": 0.3881226509784028},
            {"ds": Timestamp("2020-08-17 08:30:00"), "y": 11.036719585754327},
            {"ds": Timestamp("2020-08-17 09:00:00"), "y": 0.3391882784617337},
            {"ds": Timestamp("2020-08-17 09:30:00"), "y": 0.1612057937982172},
            {"ds": Timestamp("2020-08-17 10:00:00"), "y": 0.2939138285928493},
            {"ds": Timestamp("2020-08-17 10:30:00"), "y": 40.16404748809509},
            {"ds": Timestamp("2020-08-17 11:00:00"), "y": 112.29787312364897},
            {"ds": Timestamp("2020-08-17 11:30:00"), "y": 21.11366860633825},
            {"ds": Timestamp("2020-08-17 12:00:00"), "y": 75.99646112338087},
            {"ds": Timestamp("2020-08-17 12:30:00"), "y": 102.32787842372272},
            {"ds": Timestamp("2020-08-17 13:00:00"), "y": 138.1037648688507},
            {"ds": Timestamp("2020-08-17 13:30:00"), "y": 205.81722898625594},
            {"ds": Timestamp("2020-08-17 14:00:00"), "y": 89.87593735390146},
            {"ds": Timestamp("2020-08-17 14:30:00"), "y": 116.99626172126227},
            {"ds": Timestamp("2020-08-17 15:00:00"), "y": 233.23769431617075},
            {"ds": Timestamp("2020-08-17 15:30:00"), "y": 251.89929085549375},
            {"ds": Timestamp("2020-08-17 16:00:00"), "y": 115.06816805362178},
            {"ds": Timestamp("2020-08-17 16:30:00"), "y": 180.1167620057622},
            {"ds": Timestamp("2020-08-17 17:00:00"), "y": 277.06012404618014},
            {"ds": Timestamp("2020-08-17 17:30:00"), "y": 59.182855578477756},
            {"ds": Timestamp("2020-08-17 18:00:00"), "y": 148.25860064224798},
            {"ds": Timestamp("2020-08-17 18:30:00"), "y": 219.8383000758913},
            {"ds": Timestamp("2020-08-17 19:00:00"), "y": 259.54847574351334},
            {"ds": Timestamp("2020-08-17 19:30:00"), "y": 67.89000717119598},
            {"ds": Timestamp("2020-08-17 20:00:00"), "y": 164.9657135377056},
            {"ds": Timestamp("2020-08-17 20:30:00"), "y": 257.959704608631},
            {"ds": Timestamp("2020-08-17 21:00:00"), "y": 133.86834538328367},
            {"ds": Timestamp("2020-08-17 21:30:00"), "y": 129.09538175654052},
            {"ds": Timestamp("2020-08-17 22:00:00"), "y": 248.4288239279067},
            {"ds": Timestamp("2020-08-17 22:30:00"), "y": 167.71513984911144},
            {"ds": Timestamp("2020-08-17 23:00:00"), "y": 86.17627147283201},
            {"ds": Timestamp("2020-08-17 23:30:00"), "y": 161.0279716618188},
            {"ds": Timestamp("2020-08-18 00:00:00"), "y": 77.19058000730911},
            {"ds": Timestamp("2020-08-18 00:30:00"), "y": 119.42763081493649},
            {"ds": Timestamp("2020-08-18 01:00:00"), "y": 50.348984895019385},
            {"ds": Timestamp("2020-08-18 01:30:00"), "y": 52.11603405948699},
            {"ds": Timestamp("2020-08-18 02:00:00"), "y": 81.18741569961276},
            {"ds": Timestamp("2020-08-18 02:30:00"), "y": 47.65725224743983},
            {"ds": Timestamp("2020-08-18 03:00:00"), "y": 7.6113983279192325},
            {"ds": Timestamp("2020-08-18 03:30:00"), "y": 53.3820875098063},
            {"ds": Timestamp("2020-08-18 04:00:00"), "y": 12.358944282523225},
            {"ds": Timestamp("2020-08-18 04:30:00"), "y": 0.1948122830781358},
            {"ds": Timestamp("2020-08-18 05:00:00"), "y": 2.6552894891556207},
            {"ds": Timestamp("2020-08-18 05:30:00"), "y": 7.796763913474933},
            {"ds": Timestamp("2020-08-18 06:00:00"), "y": 0.2979706024252664},
            {"ds": Timestamp("2020-08-18 06:30:00"), "y": 10.008544553136744},
            {"ds": Timestamp("2020-08-18 07:00:00"), "y": 23.38687768751697},
            {"ds": Timestamp("2020-08-18 07:30:00"), "y": 0.14706054499220045},
            {"ds": Timestamp("2020-08-18 08:00:00"), "y": 41.886733133109374},
            {"ds": Timestamp("2020-08-18 08:30:00"), "y": 0.23563260583978263},
            {"ds": Timestamp("2020-08-18 09:00:00"), "y": 12.483552223595325},
            {"ds": Timestamp("2020-08-18 09:30:00"), "y": 0.7942585435484943},
            {"ds": Timestamp("2020-08-18 10:00:00"), "y": 12.557129035149046},
            {"ds": Timestamp("2020-08-18 10:30:00"), "y": 64.50047667668696},
            {"ds": Timestamp("2020-08-18 11:00:00"), "y": 24.809586981176835},
            {"ds": Timestamp("2020-08-18 11:30:00"), "y": 96.85911052930715},
            {"ds": Timestamp("2020-08-18 12:00:00"), "y": 33.67966247809909},
            {"ds": Timestamp("2020-08-18 12:30:00"), "y": 111.9754216960273},
            {"ds": Timestamp("2020-08-18 13:00:00"), "y": 107.03073634295197},
            {"ds": Timestamp("2020-08-18 13:30:00"), "y": 137.87485992310303},
            {"ds": Timestamp("2020-08-18 14:00:00"), "y": 53.79107408719028},
            {"ds": Timestamp("2020-08-18 14:30:00"), "y": 32.91283369933626},
            {"ds": Timestamp("2020-08-18 15:00:00"), "y": 99.90386861738625},
            {"ds": Timestamp("2020-08-18 15:30:00"), "y": 113.38043114386164},
            {"ds": Timestamp("2020-08-18 16:00:00"), "y": 0.0},
            {"ds": Timestamp("2020-08-18 16:30:00"), "y": 361.0105103002861},
            {"ds": Timestamp("2020-08-18 17:00:00"), "y": 218.84698521621794},
            {"ds": Timestamp("2020-08-18 17:30:00"), "y": 104.95724859495022},
            {"ds": Timestamp("2020-08-18 18:00:00"), "y": 233.25443169975551},
            {"ds": Timestamp("2020-08-18 18:30:00"), "y": 191.33129240293965},
            {"ds": Timestamp("2020-08-18 19:00:00"), "y": 198.43032740830677},
            {"ds": Timestamp("2020-08-18 19:30:00"), "y": 81.77457088007395},
            {"ds": Timestamp("2020-08-18 20:00:00"), "y": 179.1963069018493},
            {"ds": Timestamp("2020-08-18 20:30:00"), "y": 101.46681870528664},
            {"ds": Timestamp("2020-08-18 21:00:00"), "y": 168.54338342192023},
            {"ds": Timestamp("2020-08-18 21:30:00"), "y": 301.81463727447226},
            {"ds": Timestamp("2020-08-18 22:00:00"), "y": 288.59644442934587},
            {"ds": Timestamp("2020-08-18 22:30:00"), "y": 164.64768447089227},
            {"ds": Timestamp("2020-08-18 23:00:00"), "y": 91.16423999798462},
            {"ds": Timestamp("2020-08-18 23:30:00"), "y": 48.465767883368244},
            {"ds": Timestamp("2020-08-19 00:00:00"), "y": 85.28812912768444},
            {"ds": Timestamp("2020-08-19 00:30:00"), "y": 86.36227564393266},
            {"ds": Timestamp("2020-08-19 01:00:00"), "y": 46.45592040164411},
            {"ds": Timestamp("2020-08-19 01:30:00"), "y": 83.49951601586326},
            {"ds": Timestamp("2020-08-19 02:00:00"), "y": 71.26569300472875},
            {"ds": Timestamp("2020-08-19 02:30:00"), "y": 44.55321214113974},
            {"ds": Timestamp("2020-08-19 03:00:00"), "y": 33.66607074145031},
            {"ds": Timestamp("2020-08-19 03:30:00"), "y": 29.601258688930102},
            {"ds": Timestamp("2020-08-19 04:00:00"), "y": 19.861612127187982},
            {"ds": Timestamp("2020-08-19 04:30:00"), "y": 40.03484736473911},
            {"ds": Timestamp("2020-08-19 05:00:00"), "y": 10.32606328932161},
            {"ds": Timestamp("2020-08-19 05:30:00"), "y": 14.492967266674896},
            {"ds": Timestamp("2020-08-19 06:00:00"), "y": 9.211550140285908},
            {"ds": Timestamp("2020-08-19 06:30:00"), "y": 8.853138538899657},
            {"ds": Timestamp("2020-08-19 07:00:00"), "y": 0.12083702964810072},
            {"ds": Timestamp("2020-08-19 07:30:00"), "y": 2.3991455213035806},
            {"ds": Timestamp("2020-08-19 08:00:00"), "y": 15.431641330384082},
            {"ds": Timestamp("2020-08-19 08:30:00"), "y": 3.3251340998976957},
            {"ds": Timestamp("2020-08-19 09:00:00"), "y": 4.4427830228923995},
            {"ds": Timestamp("2020-08-19 09:30:00"), "y": 8.133882137690307},
            {"ds": Timestamp("2020-08-19 10:00:00"), "y": 0.012670030859226245},
            {"ds": Timestamp("2020-08-19 10:30:00"), "y": 52.5215950477741},
            {"ds": Timestamp("2020-08-19 11:00:00"), "y": 50.16846033566071},
            {"ds": Timestamp("2020-08-19 11:30:00"), "y": 65.01536921995466},
            {"ds": Timestamp("2020-08-19 12:00:00"), "y": 70.70727960556906},
            {"ds": Timestamp("2020-08-19 12:30:00"), "y": 66.01326642632193},
            {"ds": Timestamp("2020-08-19 13:00:00"), "y": 43.34085298489117},
            {"ds": Timestamp("2020-08-19 13:30:00"), "y": 29.701172490613317},
            {"ds": Timestamp("2020-08-19 14:00:00"), "y": 136.84894446316866},
            {"ds": Timestamp("2020-08-19 14:30:00"), "y": 116.99503821460712},
            {"ds": Timestamp("2020-08-19 15:00:00"), "y": 232.17125196054621},
            {"ds": Timestamp("2020-08-19 15:30:00"), "y": 123.74556773812401},
            {"ds": Timestamp("2020-08-19 16:00:00"), "y": 205.7371497988006},
            {"ds": Timestamp("2020-08-19 16:30:00"), "y": 171.9742903566039},
            {"ds": Timestamp("2020-08-19 17:00:00"), "y": 150.09740810667972},
            {"ds": Timestamp("2020-08-19 17:30:00"), "y": 76.54756869428638},
            {"ds": Timestamp("2020-08-19 18:00:00"), "y": 182.96942100547312},
            {"ds": Timestamp("2020-08-19 18:30:00"), "y": 256.05484900309784},
            {"ds": Timestamp("2020-08-19 19:00:00"), "y": 64.05397199462095},
            {"ds": Timestamp("2020-08-19 19:30:00"), "y": 148.5003338292936},
            {"ds": Timestamp("2020-08-19 20:00:00"), "y": 144.86603254455804},
            {"ds": Timestamp("2020-08-19 20:30:00"), "y": 161.70267842707108},
            {"ds": Timestamp("2020-08-19 21:00:00"), "y": 152.49758242682947},
            {"ds": Timestamp("2020-08-19 21:30:00"), "y": 171.70908627923745},
            {"ds": Timestamp("2020-08-19 22:00:00"), "y": 246.45111600741257},
            {"ds": Timestamp("2020-08-19 22:30:00"), "y": 245.26907783480965},
            {"ds": Timestamp("2020-08-19 23:00:00"), "y": 198.02344685765092},
            {"ds": Timestamp("2020-08-19 23:30:00"), "y": 50.59733871895878},
            {"ds": Timestamp("2020-08-20 00:00:00"), "y": 51.54172562808162},
            {"ds": Timestamp("2020-08-20 00:30:00"), "y": 96.12019288500596},
            {"ds": Timestamp("2020-08-20 01:00:00"), "y": 53.2316360296154},
            {"ds": Timestamp("2020-08-20 01:30:00"), "y": 89.72743362082838},
            {"ds": Timestamp("2020-08-20 02:00:00"), "y": 12.773104900799808},
            {"ds": Timestamp("2020-08-20 02:30:00"), "y": 2.9713481861690525},
            {"ds": Timestamp("2020-08-20 03:00:00"), "y": 78.56174449222635},
            {"ds": Timestamp("2020-08-20 03:30:00"), "y": 101.41876955616863},
            {"ds": Timestamp("2020-08-20 04:00:00"), "y": 7.078940314537249},
            {"ds": Timestamp("2020-08-20 04:30:00"), "y": 13.591621889168891},
            {"ds": Timestamp("2020-08-20 05:00:00"), "y": 19.066473927598054},
            {"ds": Timestamp("2020-08-20 05:30:00"), "y": 7.851178331824485},
            {"ds": Timestamp("2020-08-20 06:00:00"), "y": 0.47191981629839574},
            {"ds": Timestamp("2020-08-20 06:30:00"), "y": 0.9359259606044361},
            {"ds": Timestamp("2020-08-20 07:00:00"), "y": 0.30494428474412416},
            {"ds": Timestamp("2020-08-20 07:30:00"), "y": 0.5452675168071437},
            {"ds": Timestamp("2020-08-20 08:00:00"), "y": 4.737482464804998},
            {"ds": Timestamp("2020-08-20 08:30:00"), "y": 0.4822662387196033},
            {"ds": Timestamp("2020-08-20 09:00:00"), "y": 7.182664595287861},
            {"ds": Timestamp("2020-08-20 09:30:00"), "y": 0.8957572271865502},
            {"ds": Timestamp("2020-08-20 10:00:00"), "y": 16.230295875338925},
            {"ds": Timestamp("2020-08-20 10:30:00"), "y": 45.56303021222084},
            {"ds": Timestamp("2020-08-20 11:00:00"), "y": 18.039260320629182},
            {"ds": Timestamp("2020-08-20 11:30:00"), "y": 47.64788944311658},
            {"ds": Timestamp("2020-08-20 12:00:00"), "y": 45.53430348533038},
            {"ds": Timestamp("2020-08-20 12:30:00"), "y": 70.0047756960812},
            {"ds": Timestamp("2020-08-20 13:00:00"), "y": 189.8986957272773},
            {"ds": Timestamp("2020-08-20 13:30:00"), "y": 55.76618416913698},
            {"ds": Timestamp("2020-08-20 14:00:00"), "y": 162.16309269635713},
            {"ds": Timestamp("2020-08-20 14:30:00"), "y": 252.77240345916834},
            {"ds": Timestamp("2020-08-20 15:00:00"), "y": 227.18420990568302},
            {"ds": Timestamp("2020-08-20 15:30:00"), "y": 137.26097615903927},
            {"ds": Timestamp("2020-08-20 16:00:00"), "y": 203.96135427725312},
            {"ds": Timestamp("2020-08-20 16:30:00"), "y": 82.96290155576753},
            {"ds": Timestamp("2020-08-20 17:00:00"), "y": 98.53441685524012},
            {"ds": Timestamp("2020-08-20 17:30:00"), "y": 146.82292179746037},
            {"ds": Timestamp("2020-08-20 18:00:00"), "y": 247.76304693999919},
            {"ds": Timestamp("2020-08-20 18:30:00"), "y": 234.85953670926392},
            {"ds": Timestamp("2020-08-20 19:00:00"), "y": 92.74568254541919},
            {"ds": Timestamp("2020-08-20 19:30:00"), "y": 223.78492283415108},
            {"ds": Timestamp("2020-08-20 20:00:00"), "y": 147.57711467189984},
            {"ds": Timestamp("2020-08-20 20:30:00"), "y": 123.8467429914017},
            {"ds": Timestamp("2020-08-20 21:00:00"), "y": 326.01623891530653},
            {"ds": Timestamp("2020-08-20 21:30:00"), "y": 155.93342033578847},
            {"ds": Timestamp("2020-08-20 22:00:00"), "y": 272.7070683960028},
            {"ds": Timestamp("2020-08-20 22:30:00"), "y": 243.13987774161615},
            {"ds": Timestamp("2020-08-20 23:00:00"), "y": 227.838035642857},
            {"ds": Timestamp("2020-08-20 23:30:00"), "y": 89.82779034002124},
            {"ds": Timestamp("2020-08-21 00:00:00"), "y": 41.26213318972805},
            {"ds": Timestamp("2020-08-21 00:30:00"), "y": 148.65069835174108},
            {"ds": Timestamp("2020-08-21 01:00:00"), "y": 104.28436058752413},
            {"ds": Timestamp("2020-08-21 01:30:00"), "y": 48.68328267724792},
            {"ds": Timestamp("2020-08-21 02:00:00"), "y": 44.816512129082184},
            {"ds": Timestamp("2020-08-21 02:30:00"), "y": 49.1983444170437},
            {"ds": Timestamp("2020-08-21 03:00:00"), "y": 34.680494367195934},
            {"ds": Timestamp("2020-08-21 03:30:00"), "y": 49.125562468512726},
            {"ds": Timestamp("2020-08-21 04:00:00"), "y": 48.58495916860011},
            {"ds": Timestamp("2020-08-21 04:30:00"), "y": 20.569194994552163},
            {"ds": Timestamp("2020-08-21 05:00:00"), "y": 0.3115911168843013},
            {"ds": Timestamp("2020-08-21 05:30:00"), "y": 17.662436183734826},
            {"ds": Timestamp("2020-08-21 06:00:00"), "y": 14.2957876726432},
            {"ds": Timestamp("2020-08-21 06:30:00"), "y": 0.413614415907432},
            {"ds": Timestamp("2020-08-21 07:00:00"), "y": 0.26913745925412513},
            {"ds": Timestamp("2020-08-21 07:30:00"), "y": 5.064956300191625},
            {"ds": Timestamp("2020-08-21 08:00:00"), "y": 14.911169190090732},
            {"ds": Timestamp("2020-08-21 08:30:00"), "y": 0.41625237295193074},
            {"ds": Timestamp("2020-08-21 09:00:00"), "y": 0.22811117177116103},
            {"ds": Timestamp("2020-08-21 09:30:00"), "y": 19.497034506743148},
            {"ds": Timestamp("2020-08-21 10:00:00"), "y": 0.25903458478933317},
            {"ds": Timestamp("2020-08-21 10:30:00"), "y": 76.50609747764611},
            {"ds": Timestamp("2020-08-21 11:00:00"), "y": 115.93164438494023},
            {"ds": Timestamp("2020-08-21 11:30:00"), "y": 42.317864459753764},
            {"ds": Timestamp("2020-08-21 12:00:00"), "y": 77.8038425218565},
            {"ds": Timestamp("2020-08-21 12:30:00"), "y": 128.39843749635656},
            {"ds": Timestamp("2020-08-21 13:00:00"), "y": 146.17166107819867},
            {"ds": Timestamp("2020-08-21 13:30:00"), "y": 170.93517597313803},
            {"ds": Timestamp("2020-08-21 14:00:00"), "y": 149.2219423059887},
            {"ds": Timestamp("2020-08-21 14:30:00"), "y": 261.40413562588947},
            {"ds": Timestamp("2020-08-21 15:00:00"), "y": 240.21234744547655},
            {"ds": Timestamp("2020-08-21 15:30:00"), "y": 204.87721627204883},
            {"ds": Timestamp("2020-08-21 16:00:00"), "y": 77.85283123687441},
            {"ds": Timestamp("2020-08-21 16:30:00"), "y": 279.86280737290144},
            {"ds": Timestamp("2020-08-21 17:00:00"), "y": 192.24320514765895},
            {"ds": Timestamp("2020-08-21 17:30:00"), "y": 311.95573290511857},
            {"ds": Timestamp("2020-08-21 18:00:00"), "y": 166.8948572152658},
            {"ds": Timestamp("2020-08-21 18:30:00"), "y": 166.83766125555667},
            {"ds": Timestamp("2020-08-21 19:00:00"), "y": 285.70224831422456},
            {"ds": Timestamp("2020-08-21 19:30:00"), "y": 284.8797020892089},
            {"ds": Timestamp("2020-08-21 20:00:00"), "y": 190.69433487067545},
            {"ds": Timestamp("2020-08-21 20:30:00"), "y": 195.1212749284532},
            {"ds": Timestamp("2020-08-21 21:00:00"), "y": 292.3063116342182},
            {"ds": Timestamp("2020-08-21 21:30:00"), "y": 172.73176091031928},
            {"ds": Timestamp("2020-08-21 22:00:00"), "y": 208.7456687697777},
            {"ds": Timestamp("2020-08-21 22:30:00"), "y": 175.28052107741132},
            {"ds": Timestamp("2020-08-21 23:00:00"), "y": 122.57477220702276},
            {"ds": Timestamp("2020-08-21 23:30:00"), "y": 101.69839513248917},
            {"ds": Timestamp("2020-08-22 00:00:00"), "y": 100.8898204824327},
            {"ds": Timestamp("2020-08-22 00:30:00"), "y": 67.22117071633875},
            {"ds": Timestamp("2020-08-22 01:00:00"), "y": 95.75139520699304},
            {"ds": Timestamp("2020-08-22 01:30:00"), "y": 42.17491866031196},
            {"ds": Timestamp("2020-08-22 02:00:00"), "y": 48.904660491436516},
            {"ds": Timestamp("2020-08-22 02:30:00"), "y": 28.62673972783341},
            {"ds": Timestamp("2020-08-22 03:00:00"), "y": 41.999052920109534},
            {"ds": Timestamp("2020-08-22 03:30:00"), "y": 39.55639660863562},
            {"ds": Timestamp("2020-08-22 04:00:00"), "y": 1.386445232121332},
            {"ds": Timestamp("2020-08-22 04:30:00"), "y": 35.61201192043154},
            {"ds": Timestamp("2020-08-22 05:00:00"), "y": 0.008229852919612313},
            {"ds": Timestamp("2020-08-22 05:30:00"), "y": 0.11412699225002143},
            {"ds": Timestamp("2020-08-22 06:00:00"), "y": 9.584736785964196},
            {"ds": Timestamp("2020-08-22 06:30:00"), "y": 25.07080980466344},
            {"ds": Timestamp("2020-08-22 07:00:00"), "y": 0.28100563081716246},
            {"ds": Timestamp("2020-08-22 07:30:00"), "y": 12.014659160535302},
            {"ds": Timestamp("2020-08-22 08:00:00"), "y": 0.33148484590492444},
            {"ds": Timestamp("2020-08-22 08:30:00"), "y": 9.672680725348982},
            {"ds": Timestamp("2020-08-22 09:00:00"), "y": 13.04575345590274},
            {"ds": Timestamp("2020-08-22 09:30:00"), "y": 0.18334348535245226},
            {"ds": Timestamp("2020-08-22 10:00:00"), "y": 25.429873244773262},
            {"ds": Timestamp("2020-08-22 10:30:00"), "y": 0.20060526584165927},
            {"ds": Timestamp("2020-08-22 11:00:00"), "y": 39.6189175753334},
            {"ds": Timestamp("2020-08-22 11:30:00"), "y": 60.39190163308558},
            {"ds": Timestamp("2020-08-22 12:00:00"), "y": 54.08926442166194},
            {"ds": Timestamp("2020-08-22 12:30:00"), "y": 8.069821840223085},
            {"ds": Timestamp("2020-08-22 13:00:00"), "y": 113.48855299756906},
            {"ds": Timestamp("2020-08-22 13:30:00"), "y": 148.5032277388691},
            {"ds": Timestamp("2020-08-22 14:00:00"), "y": 152.65181391087754},
            {"ds": Timestamp("2020-08-22 14:30:00"), "y": 212.61826523596937},
            {"ds": Timestamp("2020-08-22 15:00:00"), "y": 206.70088973817838},
            {"ds": Timestamp("2020-08-22 15:30:00"), "y": 364.3817311064631},
            {"ds": Timestamp("2020-08-22 16:00:00"), "y": 111.35143844999766},
            {"ds": Timestamp("2020-08-22 16:30:00"), "y": 224.8231106209205},
            {"ds": Timestamp("2020-08-22 17:00:00"), "y": 299.2186708164463},
            {"ds": Timestamp("2020-08-22 17:30:00"), "y": 268.3299581095507},
            {"ds": Timestamp("2020-08-22 18:00:00"), "y": 160.5301506572814},
            {"ds": Timestamp("2020-08-22 18:30:00"), "y": 119.8495973150657},
            {"ds": Timestamp("2020-08-22 19:00:00"), "y": 258.4976593609881},
            {"ds": Timestamp("2020-08-22 19:30:00"), "y": 120.64367924397811},
            {"ds": Timestamp("2020-08-22 20:00:00"), "y": 156.1472431314305},
            {"ds": Timestamp("2020-08-22 20:30:00"), "y": 119.9764883929347},
            {"ds": Timestamp("2020-08-22 21:00:00"), "y": 231.62174068779132},
            {"ds": Timestamp("2020-08-22 21:30:00"), "y": 72.44540852566206},
            {"ds": Timestamp("2020-08-22 22:00:00"), "y": 139.64907207466422},
            {"ds": Timestamp("2020-08-22 22:30:00"), "y": 157.0070722062428},
            {"ds": Timestamp("2020-08-22 23:00:00"), "y": 186.8031993828481},
            {"ds": Timestamp("2020-08-22 23:30:00"), "y": 65.48921994423108},
            {"ds": Timestamp("2020-08-23 00:00:00"), "y": 124.81523417017524},
            {"ds": Timestamp("2020-08-23 00:30:00"), "y": 107.41076998025528},
            {"ds": Timestamp("2020-08-23 01:00:00"), "y": 65.26064839047922},
            {"ds": Timestamp("2020-08-23 01:30:00"), "y": 97.09702215196467},
            {"ds": Timestamp("2020-08-23 02:00:00"), "y": 68.10062914009632},
            {"ds": Timestamp("2020-08-23 02:30:00"), "y": 20.31235778271821},
            {"ds": Timestamp("2020-08-23 03:00:00"), "y": 5.592383181526202},
            {"ds": Timestamp("2020-08-23 03:30:00"), "y": 4.884286868889831},
            {"ds": Timestamp("2020-08-23 04:00:00"), "y": 16.278553885950714},
            {"ds": Timestamp("2020-08-23 04:30:00"), "y": 24.177462689216554},
            {"ds": Timestamp("2020-08-23 05:00:00"), "y": 22.664668874903327},
            {"ds": Timestamp("2020-08-23 05:30:00"), "y": 0.14916523926240188},
            {"ds": Timestamp("2020-08-23 06:00:00"), "y": 0.25843589264786715},
            {"ds": Timestamp("2020-08-23 06:30:00"), "y": 0.0340526449463141},
            {"ds": Timestamp("2020-08-23 07:00:00"), "y": 1.4625355161251719},
            {"ds": Timestamp("2020-08-23 07:30:00"), "y": 20.80653955344951},
            {"ds": Timestamp("2020-08-23 08:00:00"), "y": 20.2493412168742},
            {"ds": Timestamp("2020-08-23 08:30:00"), "y": 0.2877782625873806},
            {"ds": Timestamp("2020-08-23 09:00:00"), "y": 8.708569451994663},
            {"ds": Timestamp("2020-08-23 09:30:00"), "y": 4.988726416523605},
            {"ds": Timestamp("2020-08-23 10:00:00"), "y": 0.24593628118145716},
            {"ds": Timestamp("2020-08-23 10:30:00"), "y": 5.5869871621980565},
            {"ds": Timestamp("2020-08-23 11:00:00"), "y": 3.7331897340600335},
            {"ds": Timestamp("2020-08-23 11:30:00"), "y": 41.87291166812793},
            {"ds": Timestamp("2020-08-23 12:00:00"), "y": 73.94171124967215},
            {"ds": Timestamp("2020-08-23 12:30:00"), "y": 34.942879457144045},
            {"ds": Timestamp("2020-08-23 13:00:00"), "y": 101.0003967933435},
            {"ds": Timestamp("2020-08-23 13:30:00"), "y": 107.56740791424636},
            {"ds": Timestamp("2020-08-23 14:00:00"), "y": 139.6582999773691},
            {"ds": Timestamp("2020-08-23 14:30:00"), "y": 228.08031180951275},
            {"ds": Timestamp("2020-08-23 15:00:00"), "y": 256.1650075402222},
            {"ds": Timestamp("2020-08-23 15:30:00"), "y": 218.50712289997318},
            {"ds": Timestamp("2020-08-23 16:00:00"), "y": 183.40791140084184},
            {"ds": Timestamp("2020-08-23 16:30:00"), "y": 204.52815195717267},
            {"ds": Timestamp("2020-08-23 17:00:00"), "y": 0.0},
            {"ds": Timestamp("2020-08-23 17:30:00"), "y": 46.67764366456686},
            {"ds": Timestamp("2020-08-23 18:00:00"), "y": 224.03284591727606},
            {"ds": Timestamp("2020-08-23 18:30:00"), "y": 191.006386635745},
            {"ds": Timestamp("2020-08-23 19:00:00"), "y": 325.17361898999116},
            {"ds": Timestamp("2020-08-23 19:30:00"), "y": 137.8194022206335},
            {"ds": Timestamp("2020-08-23 20:00:00"), "y": 226.9826226819896},
            {"ds": Timestamp("2020-08-23 20:30:00"), "y": 166.258079554882},
            {"ds": Timestamp("2020-08-23 21:00:00"), "y": 198.56598268128437},
            {"ds": Timestamp("2020-08-23 21:30:00"), "y": 96.21487942649037},
            {"ds": Timestamp("2020-08-23 22:00:00"), "y": 196.21055460317257},
            {"ds": Timestamp("2020-08-23 22:30:00"), "y": 169.40627703927748},
            {"ds": Timestamp("2020-08-23 23:00:00"), "y": 177.73352386766965},
            {"ds": Timestamp("2020-08-23 23:30:00"), "y": 59.19744522276778},
            {"ds": Timestamp("2020-08-24 00:00:00"), "y": 168.04237456715236},
            {"ds": Timestamp("2020-08-24 00:30:00"), "y": 40.31845323628295},
            {"ds": Timestamp("2020-08-24 01:00:00"), "y": 90.48179172105483},
            {"ds": Timestamp("2020-08-24 01:30:00"), "y": 63.04083985137004},
            {"ds": Timestamp("2020-08-24 02:00:00"), "y": 64.35533606255376},
            {"ds": Timestamp("2020-08-24 02:30:00"), "y": 32.49962908376256},
            {"ds": Timestamp("2020-08-24 03:00:00"), "y": 1.391404432752097},
            {"ds": Timestamp("2020-08-24 03:30:00"), "y": 13.247364587468837},
            {"ds": Timestamp("2020-08-24 04:00:00"), "y": 14.917734710503282},
            {"ds": Timestamp("2020-08-24 04:30:00"), "y": 0.09696989843723713},
            {"ds": Timestamp("2020-08-24 05:00:00"), "y": 14.720907184349926},
            {"ds": Timestamp("2020-08-24 05:30:00"), "y": 0.32791257131975726},
            {"ds": Timestamp("2020-08-24 06:00:00"), "y": 2.753361034694535},
            {"ds": Timestamp("2020-08-24 06:30:00"), "y": 0.3015439059872733},
            {"ds": Timestamp("2020-08-24 07:00:00"), "y": 0.44553352833645476},
            {"ds": Timestamp("2020-08-24 07:30:00"), "y": 10.491678329806746},
            {"ds": Timestamp("2020-08-24 08:00:00"), "y": 15.871340997722655},
            {"ds": Timestamp("2020-08-24 08:30:00"), "y": 25.24045252648466},
            {"ds": Timestamp("2020-08-24 09:00:00"), "y": 0.20535479853060679},
            {"ds": Timestamp("2020-08-24 09:30:00"), "y": 24.264673940566354},
            {"ds": Timestamp("2020-08-24 10:00:00"), "y": 26.353821204622363},
            {"ds": Timestamp("2020-08-24 10:30:00"), "y": 17.45278695668094},
            {"ds": Timestamp("2020-08-24 11:00:00"), "y": 69.38659760236078},
            {"ds": Timestamp("2020-08-24 11:30:00"), "y": 89.91395099139118},
            {"ds": Timestamp("2020-08-24 12:00:00"), "y": 51.13147066354759},
            {"ds": Timestamp("2020-08-24 12:30:00"), "y": 123.64125412034082},
            {"ds": Timestamp("2020-08-24 13:00:00"), "y": 106.01528289513044},
            {"ds": Timestamp("2020-08-24 13:30:00"), "y": 52.5215320228981},
            {"ds": Timestamp("2020-08-24 14:00:00"), "y": 53.4083535378486},
            {"ds": Timestamp("2020-08-24 14:30:00"), "y": 178.0868028285604},
            {"ds": Timestamp("2020-08-24 15:00:00"), "y": 263.7124068268131},
            {"ds": Timestamp("2020-08-24 15:30:00"), "y": 128.878397056249},
            {"ds": Timestamp("2020-08-24 16:00:00"), "y": 190.55326399136902},
            {"ds": Timestamp("2020-08-24 16:30:00"), "y": 198.08159205657284},
            {"ds": Timestamp("2020-08-24 17:00:00"), "y": 78.26659645822656},
            {"ds": Timestamp("2020-08-24 17:30:00"), "y": 88.14855061268099},
            {"ds": Timestamp("2020-08-24 18:00:00"), "y": 133.89673637554006},
            {"ds": Timestamp("2020-08-24 18:30:00"), "y": 121.24105502117891},
            {"ds": Timestamp("2020-08-24 19:00:00"), "y": 136.98074123744482},
            {"ds": Timestamp("2020-08-24 19:30:00"), "y": 97.81650656102101},
            {"ds": Timestamp("2020-08-24 20:00:00"), "y": 267.36255381500087},
            {"ds": Timestamp("2020-08-24 20:30:00"), "y": 189.90762773863025},
            {"ds": Timestamp("2020-08-24 21:00:00"), "y": 71.26246459890899},
            {"ds": Timestamp("2020-08-24 21:30:00"), "y": 275.7419424949803},
            {"ds": Timestamp("2020-08-24 22:00:00"), "y": 147.62901818933824},
            {"ds": Timestamp("2020-08-24 22:30:00"), "y": 225.0865735665593},
            {"ds": Timestamp("2020-08-24 23:00:00"), "y": 48.744126049552506},
            {"ds": Timestamp("2020-08-24 23:30:00"), "y": 77.47722559478825},
            {"ds": Timestamp("2020-08-25 00:00:00"), "y": 89.44896760400752},
            {"ds": Timestamp("2020-08-25 00:30:00"), "y": 27.48929690566547},
            {"ds": Timestamp("2020-08-25 01:00:00"), "y": 59.69789459342246},
            {"ds": Timestamp("2020-08-25 01:30:00"), "y": 144.31941143924632},
            {"ds": Timestamp("2020-08-25 02:00:00"), "y": 90.28334293738953},
            {"ds": Timestamp("2020-08-25 02:30:00"), "y": 25.180132663062977},
            {"ds": Timestamp("2020-08-25 03:00:00"), "y": 18.464156551197448},
            {"ds": Timestamp("2020-08-25 03:30:00"), "y": 27.7913238821875},
            {"ds": Timestamp("2020-08-25 04:00:00"), "y": 13.045903533435194},
            {"ds": Timestamp("2020-08-25 04:30:00"), "y": 0.012673675062615075},
            {"ds": Timestamp("2020-08-25 05:00:00"), "y": 5.230397637045826},
            {"ds": Timestamp("2020-08-25 05:30:00"), "y": 1.9513446015716909},
            {"ds": Timestamp("2020-08-25 06:00:00"), "y": 8.285850334503266},
            {"ds": Timestamp("2020-08-25 06:30:00"), "y": 0.039406066738592926},
            {"ds": Timestamp("2020-08-25 07:00:00"), "y": 10.884281304497563},
            {"ds": Timestamp("2020-08-25 07:30:00"), "y": 0.2046936005626776},
            {"ds": Timestamp("2020-08-25 08:00:00"), "y": 0.058689087700258824},
            {"ds": Timestamp("2020-08-25 08:30:00"), "y": 0.5046974261349533},
            {"ds": Timestamp("2020-08-25 09:00:00"), "y": 0.1328376088913501},
            {"ds": Timestamp("2020-08-25 09:30:00"), "y": 28.81968911164404},
            {"ds": Timestamp("2020-08-25 10:00:00"), "y": 0.05954493790886772},
            {"ds": Timestamp("2020-08-25 10:30:00"), "y": 82.83666020521741},
            {"ds": Timestamp("2020-08-25 11:00:00"), "y": 88.20184695962234},
            {"ds": Timestamp("2020-08-25 11:30:00"), "y": 48.107284122690544},
            {"ds": Timestamp("2020-08-25 12:00:00"), "y": 61.51516195072327},
            {"ds": Timestamp("2020-08-25 12:30:00"), "y": 166.25785052393803},
            {"ds": Timestamp("2020-08-25 13:00:00"), "y": 132.12722741765538},
            {"ds": Timestamp("2020-08-25 13:30:00"), "y": 51.67929784173066},
            {"ds": Timestamp("2020-08-25 14:00:00"), "y": 89.84665919611507},
            {"ds": Timestamp("2020-08-25 14:30:00"), "y": 140.34906860243245},
            {"ds": Timestamp("2020-08-25 15:00:00"), "y": 190.4575744951835},
            {"ds": Timestamp("2020-08-25 15:30:00"), "y": 80.1896720788609},
            {"ds": Timestamp("2020-08-25 16:00:00"), "y": 157.23517451026964},
            {"ds": Timestamp("2020-08-25 16:30:00"), "y": 213.75375496263405},
            {"ds": Timestamp("2020-08-25 17:00:00"), "y": 166.62190444422959},
            {"ds": Timestamp("2020-08-25 17:30:00"), "y": 153.47352890100046},
            {"ds": Timestamp("2020-08-25 18:00:00"), "y": 211.8457216951865},
            {"ds": Timestamp("2020-08-25 18:30:00"), "y": 126.6013212530197},
            {"ds": Timestamp("2020-08-25 19:00:00"), "y": 104.5695436734004},
            {"ds": Timestamp("2020-08-25 19:30:00"), "y": 123.44137184924875},
            {"ds": Timestamp("2020-08-25 20:00:00"), "y": 173.70207367199328},
            {"ds": Timestamp("2020-08-25 20:30:00"), "y": 281.00026282504587},
            {"ds": Timestamp("2020-08-25 21:00:00"), "y": 153.9018765478413},
            {"ds": Timestamp("2020-08-25 21:30:00"), "y": 271.246986899243},
            {"ds": Timestamp("2020-08-25 22:00:00"), "y": 52.812789933233944},
            {"ds": Timestamp("2020-08-25 22:30:00"), "y": 119.37916058330666},
            {"ds": Timestamp("2020-08-25 23:00:00"), "y": 114.15637420781422},
            {"ds": Timestamp("2020-08-25 23:30:00"), "y": 112.1528659173382},
            {"ds": Timestamp("2020-08-26 00:00:00"), "y": 62.40762803627149},
            {"ds": Timestamp("2020-08-26 00:30:00"), "y": 32.23446044165394},
            {"ds": Timestamp("2020-08-26 01:00:00"), "y": 87.57607680790716},
            {"ds": Timestamp("2020-08-26 01:30:00"), "y": 48.3316219661192},
            {"ds": Timestamp("2020-08-26 02:00:00"), "y": 33.502005682505114},
            {"ds": Timestamp("2020-08-26 02:30:00"), "y": 2.995749402403817},
            {"ds": Timestamp("2020-08-26 03:00:00"), "y": 4.901880459203312},
            {"ds": Timestamp("2020-08-26 03:30:00"), "y": 32.87215650992039},
            {"ds": Timestamp("2020-08-26 04:00:00"), "y": 18.449335766837976},
            {"ds": Timestamp("2020-08-26 04:30:00"), "y": 2.392290549025347},
            {"ds": Timestamp("2020-08-26 05:00:00"), "y": 9.343031601300027},
            {"ds": Timestamp("2020-08-26 05:30:00"), "y": 11.631658868021987},
            {"ds": Timestamp("2020-08-26 06:00:00"), "y": 0.33522621999327384},
            {"ds": Timestamp("2020-08-26 06:30:00"), "y": 0.5203676741584786},
            {"ds": Timestamp("2020-08-26 07:00:00"), "y": 5.260711058694142},
            {"ds": Timestamp("2020-08-26 07:30:00"), "y": 7.472692770588765},
            {"ds": Timestamp("2020-08-26 08:00:00"), "y": 0.3502954943542136},
            {"ds": Timestamp("2020-08-26 08:30:00"), "y": 2.4601066056475247},
            {"ds": Timestamp("2020-08-26 09:00:00"), "y": 0.31706823350941704},
            {"ds": Timestamp("2020-08-26 09:30:00"), "y": 0.2873748949441506},
            {"ds": Timestamp("2020-08-26 10:00:00"), "y": 0.1997629206016427},
            {"ds": Timestamp("2020-08-26 10:30:00"), "y": 40.26183717314234},
            {"ds": Timestamp("2020-08-26 11:00:00"), "y": 66.76873392963535},
            {"ds": Timestamp("2020-08-26 11:30:00"), "y": 62.73791336965223},
            {"ds": Timestamp("2020-08-26 12:00:00"), "y": 140.83128675904663},
            {"ds": Timestamp("2020-08-26 12:30:00"), "y": 80.69537335952009},
            {"ds": Timestamp("2020-08-26 13:00:00"), "y": 79.58367357123461},
            {"ds": Timestamp("2020-08-26 13:30:00"), "y": 117.0756445926163},
            {"ds": Timestamp("2020-08-26 14:00:00"), "y": 173.6436859322912},
            {"ds": Timestamp("2020-08-26 14:30:00"), "y": 74.0436160319714},
            {"ds": Timestamp("2020-08-26 15:00:00"), "y": 154.0220150445548},
            {"ds": Timestamp("2020-08-26 15:30:00"), "y": 147.43331317863704},
            {"ds": Timestamp("2020-08-26 16:00:00"), "y": 209.71752770739113},
            {"ds": Timestamp("2020-08-26 16:30:00"), "y": 193.22206328816537},
            {"ds": Timestamp("2020-08-26 17:00:00"), "y": 113.714356877721},
            {"ds": Timestamp("2020-08-26 17:30:00"), "y": 135.33599259434777},
            {"ds": Timestamp("2020-08-26 18:00:00"), "y": 164.6925164557888},
            {"ds": Timestamp("2020-08-26 18:30:00"), "y": 110.83917473019574},
            {"ds": Timestamp("2020-08-26 19:00:00"), "y": 29.95095913755904},
            {"ds": Timestamp("2020-08-26 19:30:00"), "y": 84.63492593905357},
            {"ds": Timestamp("2020-08-26 20:00:00"), "y": 242.2196563279358},
            {"ds": Timestamp("2020-08-26 20:30:00"), "y": 149.4761003636031},
            {"ds": Timestamp("2020-08-26 21:00:00"), "y": 127.10781815345399},
            {"ds": Timestamp("2020-08-26 21:30:00"), "y": 231.017226369735},
            {"ds": Timestamp("2020-08-26 22:00:00"), "y": 243.80514644675532},
            {"ds": Timestamp("2020-08-26 22:30:00"), "y": 61.52965891500389},
            {"ds": Timestamp("2020-08-26 23:00:00"), "y": 139.11946667338998},
            {"ds": Timestamp("2020-08-26 23:30:00"), "y": 50.71760436323348},
            {"ds": Timestamp("2020-08-27 00:00:00"), "y": 72.76584614064814},
            {"ds": Timestamp("2020-08-27 00:30:00"), "y": 62.01755956542547},
            {"ds": Timestamp("2020-08-27 01:00:00"), "y": 22.947850239290347},
            {"ds": Timestamp("2020-08-27 01:30:00"), "y": 52.84817601369832},
            {"ds": Timestamp("2020-08-27 02:00:00"), "y": 35.83546778872551},
            {"ds": Timestamp("2020-08-27 02:30:00"), "y": 9.062434505347483},
            {"ds": Timestamp("2020-08-27 03:00:00"), "y": 57.02789590586053},
            {"ds": Timestamp("2020-08-27 03:30:00"), "y": 0.31822874946192314},
            {"ds": Timestamp("2020-08-27 04:00:00"), "y": 30.81426189463309},
            {"ds": Timestamp("2020-08-27 04:30:00"), "y": 23.856584329359066},
            {"ds": Timestamp("2020-08-27 05:00:00"), "y": 9.587506983638377},
            {"ds": Timestamp("2020-08-27 05:30:00"), "y": 0.43795008373854216},
            {"ds": Timestamp("2020-08-27 06:00:00"), "y": 4.9346776220172615},
            {"ds": Timestamp("2020-08-27 06:30:00"), "y": 0.15243874502903054},
            {"ds": Timestamp("2020-08-27 07:00:00"), "y": 4.585049010813236},
            {"ds": Timestamp("2020-08-27 07:30:00"), "y": 14.842680861011104},
            {"ds": Timestamp("2020-08-27 08:00:00"), "y": 21.642895964198033},
            {"ds": Timestamp("2020-08-27 08:30:00"), "y": 14.528575267981068},
            {"ds": Timestamp("2020-08-27 09:00:00"), "y": 13.748284160591538},
            {"ds": Timestamp("2020-08-27 09:30:00"), "y": 0.12434745790233137},
            {"ds": Timestamp("2020-08-27 10:00:00"), "y": 9.058865643286481},
            {"ds": Timestamp("2020-08-27 10:30:00"), "y": 57.36078957369591},
            {"ds": Timestamp("2020-08-27 11:00:00"), "y": 4.61401614348415},
            {"ds": Timestamp("2020-08-27 11:30:00"), "y": 13.628358820595167},
            {"ds": Timestamp("2020-08-27 12:00:00"), "y": 96.16971935894799},
            {"ds": Timestamp("2020-08-27 12:30:00"), "y": 62.12258430057773},
            {"ds": Timestamp("2020-08-27 13:00:00"), "y": 157.4522443410915},
            {"ds": Timestamp("2020-08-27 13:30:00"), "y": 21.85192316116445},
            {"ds": Timestamp("2020-08-27 14:00:00"), "y": 56.447098271257346},
            {"ds": Timestamp("2020-08-27 14:30:00"), "y": 100.68883155724507},
            {"ds": Timestamp("2020-08-27 15:00:00"), "y": 98.45425695653648},
        ],
        columns=["ds", "y"],
    )
    return df


@pytest.fixture(scope="module")
def sales_little_data():
    df = pd.DataFrame(
        data=[
            ["2020-07-04", 25],
            ["2020-07-03", 50],
            ["2020-07-02", 75],
            ["2020-07-01", 50],
        ],
        columns=["ds", "y"],
    )

    df.ds = pd.to_datetime(df.ds)

    return df
