"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CrossBuild = exports.DockerizedCargoBuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path_1 = require("path");
const cdktf_local_exec_1 = require("cdktf-local-exec");
const toml = require("toml");
const docker_1 = require("./docker");
/**
 * Builds a binary using cargo inside a docker container.
 * It is built to support https://github.com/awslabs/aws-lambda-rust-runtime
 */
class DockerizedCargoBuild extends docker_1.DockerizedBuild {
    constructor(scope, name, options) {
        const rustVersion = options.rustVersion || "1.58";
        const image = options.arch === "arm"
            ? `arm64v8/rust:${rustVersion}-slim`
            : `rust:${rustVersion}`;
        const platform = options.arch === "arm" ? "linux/arm64" : "linux/x86";
        const target = options.arch === "arm"
            ? "aarch64-unknown-linux-gnu"
            : "x86_64-unknown-linux-gnu";
        super(scope, name, {
            cwd: options.cwd,
            platform,
            command: `cargo build --release --target ${target}`,
            image,
            imageHomeDirectory: `/usr/src/${options.projectName}`,
            setUser: true,
        });
    }
    get binaryPath() {
        return path_1.resolve(this.cwd, "binary");
    }
}
exports.DockerizedCargoBuild = DockerizedCargoBuild;
_a = JSII_RTTI_SYMBOL_1;
DockerizedCargoBuild[_a] = { fqn: "cdktf-local-build.DockerizedCargoBuild", version: "0.0.29" };
class CrossBuild extends cdktf_local_exec_1.LocalExec {
    constructor(scope, name, config) {
        const target = config.arch === "arm"
            ? "aarch64-unknown-linux-gnu"
            : "x86_64-unknown-linux-gnu";
        const tomlPath = path_1.resolve(config.cwd, "Cargo.toml");
        let parsedToml;
        try {
            parsedToml = toml.parse(fs.readFileSync(tomlPath, "utf8"));
        }
        catch (e) {
            throw new Error("Could not find Cargo.toml in " + config.cwd);
        }
        super(scope, name, {
            command: `cross build --target ${target} --release`,
            cwd: config.cwd,
            dependsOn: config.dependsOn,
            provider: config.provider,
            lifecycle: config.lifecycle,
            triggers: config.triggers,
        });
        this.target = target;
        this.projectName = config.projectName || parsedToml.package.name;
    }
    get binaryPath() {
        return path_1.resolve(this.cwd, "target", this.target, "release", this.projectName);
    }
}
exports.CrossBuild = CrossBuild;
_b = JSII_RTTI_SYMBOL_1;
CrossBuild[_b] = { fqn: "cdktf-local-build.CrossBuild", version: "0.0.29" };
//# sourceMappingURL=data:application/json;base64,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