"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerizedBuild = exports.DockerBuild = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf_local_exec_1 = require("cdktf-local-exec");
class DockerBuild extends cdktf_local_exec_1.LocalExec {
    constructor(scope, name, { cwd, dockerfile, tag, push, auth }) {
        const commands = [];
        if (auth) {
            commands.push(`docker login -u ${auth.userName} -p ${auth.password} ${auth.proxyEndpoint}`);
        }
        commands.push(`docker build ${dockerfile ? `-f ${dockerfile}` : ""} -t ${tag} .`);
        if (push !== false) {
            commands.push(`docker push ${tag}`);
        }
        super(scope, name, {
            cwd: cwd,
            command: commands.join(" && "),
            copyBeforeRun: false,
        });
    }
}
exports.DockerBuild = DockerBuild;
_a = JSII_RTTI_SYMBOL_1;
DockerBuild[_a] = { fqn: "cdktf-local-build.DockerBuild", version: "0.0.29" };
// Runs an arbitrary build inside a docker container
class DockerizedBuild extends cdktf_local_exec_1.LocalExec {
    constructor(scope, name, options) {
        super(scope, name, {
            ...options,
            command: `docker run --rm ${options.platform ? `--platform=${options.platform}` : ""} ${options.setUser ? '--user="$(id -u)":"$(id -g)"' : ""} -v ${options.cwd}:${options.imageHomeDirectory} -w ${options.imageHomeDirectory} ${options.image} ${options.command}`,
        });
    }
}
exports.DockerizedBuild = DockerizedBuild;
_b = JSII_RTTI_SYMBOL_1;
DockerizedBuild[_b] = { fqn: "cdktf-local-build.DockerizedBuild", version: "0.0.29" };
//# sourceMappingURL=data:application/json;base64,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