![GitHub Workflow Status](https://img.shields.io/github/actions/workflow/status/OmniSpective/OmniBridge/tests.yml)
![PyPI - License](https://img.shields.io/pypi/l/omnibridge)
![GitHub Pipenv locked Python version](https://img.shields.io/github/pipenv/locked/python-version/OmniSpective/OmniBridge)
![PyPI - Downloads](https://img.shields.io/pypi/dd/omnibridge?style=plastic)

# OmniBridge

OmniBridge is a CLI tool that bridges between different AI models. It helps you can access different AI models in a centralized place.

# Install

```
> pip install omnibridge
```

# Usage

Available in CLI with the following arguments:

* -m / --model
* -p / --prompt
* -l / --load-config

single model example:
```
python main.py -m chatgpt -p hello
```

multi model example:
```
python main.py -m chatgpt -p hello -m dalle -p goodbye
```

Note that the order of specification matters, meaning that in the above example, chatgpt will get the prompt `hello` and dalle will get the prompt `goodbye`

The configurations can be set in a .json file and given to the CLI tool with the flag `-l <PATH_TO_CONFIG_FILE>`.

For example:

```
{
    "chatgpt": {
        "api_key": "...",
        "model": "..."
    },
    "hugging_face": {
        "api_key": "...",
        "model_id": "..."
    },
    "dalle": {
        "api_key": "...",
        "num_of_images": ...,
        "resolution": "..."
    }
}
```

# Contribute:

requirerments:
* Python 3.11

steps:
1. Fork and clone this repository
2. pip install pipenv
3. pipenv install (in the root folder)
4. pipenv shell

### Run linter locally
inside pipenv shell, execute 
```
ruff check ./
```

### Run tests locally
```
pipenv run python -m pytest
```



