import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeAddressConfig extends cdktf.TerraformMetaArguments {
    /**
     * The static external IP address represented by this resource.
     *
     * Only
     * IPv4 is supported. An address may only be specified for INTERNAL
     * address types. The IP address must be inside the specified subnetwork,
     * if any.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#address ComputeAddress#address}
     *
     * @stability stable
     */
    readonly address?: string;
    /**
     * The type of address to reserve. Default value: "EXTERNAL" Possible values: ["INTERNAL", "EXTERNAL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#address_type ComputeAddress#address_type}
     *
     * @stability stable
     */
    readonly addressType?: string;
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#description ComputeAddress#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Name of the resource.
     *
     * The name must be 1-63 characters long, and
     * comply with RFC1035. Specifically, the name must be 1-63 characters
     * long and match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?'
     * which means the first character must be a lowercase letter, and all
     * following characters must be a dash, lowercase letter, or digit,
     * except the last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#name ComputeAddress#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The URL of the network in which to reserve the address.
     *
     * This field
     * can only be used with INTERNAL type with the VPC_PEERING and
     * IPSEC_INTERCONNECT purposes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#network ComputeAddress#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * The networking tier used for configuring this address.
     *
     * If this field is not
     * specified, it is assumed to be PREMIUM. Possible values: ["PREMIUM", "STANDARD"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#network_tier ComputeAddress#network_tier}
     *
     * @stability stable
     */
    readonly networkTier?: string;
    /**
     * The prefix length if the resource represents an IP range.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#prefix_length ComputeAddress#prefix_length}
     *
     * @stability stable
     */
    readonly prefixLength?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#project ComputeAddress#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The purpose of this resource, which can be one of the following values:.
     *
     * GCE_ENDPOINT for addresses that are used by VM instances, alias IP
     * ranges, internal load balancers, and similar resources.
     *
     * SHARED_LOADBALANCER_VIP for an address that can be used by multiple
     * internal load balancers.
     *
     * VPC_PEERING for addresses that are reserved for VPC peer networks.
     *
     * IPSEC_INTERCONNECT for addresses created from a private IP range
     * that are reserved for a VLAN attachment in an IPsec-encrypted Cloud
     * Interconnect configuration. These addresses are regional resources.
     *
     * PRIVATE_SERVICE_CONNECT for a private network address that is used
     * to configure Private Service Connect. Only global internal addresses
     * can use this purpose.
     *
     * This should only be set when using an Internal address.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#purpose ComputeAddress#purpose}
     *
     * @stability stable
     */
    readonly purpose?: string;
    /**
     * The Region in which the created address should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#region ComputeAddress#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The URL of the subnetwork in which to reserve the address.
     *
     * If an IP
     * address is specified, it must be within the subnetwork's IP range.
     * This field can only be used with INTERNAL type with
     * GCE_ENDPOINT/DNS_RESOLVER purposes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#subnetwork ComputeAddress#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#timeouts ComputeAddress#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeAddressTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeAddressTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#create ComputeAddress#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_address.html#delete ComputeAddress#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeAddressTimeoutsToTerraform(struct?: ComputeAddressTimeoutsOutputReference | ComputeAddressTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeAddressTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeAddressTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeAddressTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_address.html google_compute_address}.
 *
 * @stability stable
 */
export declare class ComputeAddress extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_address.html google_compute_address} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeAddressConfig);
    private _address?;
    /**
     * @stability stable
     */
    get address(): string;
    /**
     * @stability stable
     */
    set address(value: string);
    /**
     * @stability stable
     */
    resetAddress(): void;
    /**
     * @stability stable
     */
    get addressInput(): string | undefined;
    private _addressType?;
    /**
     * @stability stable
     */
    get addressType(): string;
    /**
     * @stability stable
     */
    set addressType(value: string);
    /**
     * @stability stable
     */
    resetAddressType(): void;
    /**
     * @stability stable
     */
    get addressTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _networkTier?;
    /**
     * @stability stable
     */
    get networkTier(): string;
    /**
     * @stability stable
     */
    set networkTier(value: string);
    /**
     * @stability stable
     */
    resetNetworkTier(): void;
    /**
     * @stability stable
     */
    get networkTierInput(): string | undefined;
    private _prefixLength?;
    /**
     * @stability stable
     */
    get prefixLength(): number;
    /**
     * @stability stable
     */
    set prefixLength(value: number);
    /**
     * @stability stable
     */
    resetPrefixLength(): void;
    /**
     * @stability stable
     */
    get prefixLengthInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _purpose?;
    /**
     * @stability stable
     */
    get purpose(): string;
    /**
     * @stability stable
     */
    set purpose(value: string);
    /**
     * @stability stable
     */
    resetPurpose(): void;
    /**
     * @stability stable
     */
    get purposeInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _subnetwork?;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    set subnetwork(value: string);
    /**
     * @stability stable
     */
    resetSubnetwork(): void;
    /**
     * @stability stable
     */
    get subnetworkInput(): string | undefined;
    /**
     * @stability stable
     */
    get users(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeAddressTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeAddressTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeAddressTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
