import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSslPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Profile specifies the set of SSL features that can be used by the load balancer when negotiating SSL with clients.
     *
     * This can be one of
     * 'COMPATIBLE', 'MODERN', 'RESTRICTED', or 'CUSTOM'. If using 'CUSTOM',
     * the set of SSL features to enable must be specified in the
     * 'customFeatures' field.
     *
     * See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
     * for which ciphers are available to use. **Note**: this argument
     * must* be present when using the 'CUSTOM' profile. This argument
     * must not* be present when using any other profile.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#custom_features ComputeSslPolicy#custom_features}
     *
     * @stability stable
     */
    readonly customFeatures?: string[];
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#description ComputeSslPolicy#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The minimum version of SSL protocol that can be used by the clients to establish a connection with the load balancer.
     *
     * Default value: "TLS_1_0" Possible values: ["TLS_1_0", "TLS_1_1", "TLS_1_2"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#min_tls_version ComputeSslPolicy#min_tls_version}
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#name ComputeSslPolicy#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Profile specifies the set of SSL features that can be used by the load balancer when negotiating SSL with clients.
     *
     * If using 'CUSTOM',
     * the set of SSL features to enable must be specified in the
     * 'customFeatures' field.
     *
     * See the [official documentation](https://cloud.google.com/compute/docs/load-balancing/ssl-policies#profilefeaturesupport)
     * for information on what cipher suites each profile provides. If
     * 'CUSTOM' is used, the 'custom_features' attribute **must be set**. Default value: "COMPATIBLE" Possible values: ["COMPATIBLE", "MODERN", "RESTRICTED", "CUSTOM"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#profile ComputeSslPolicy#profile}
     *
     * @stability stable
     */
    readonly profile?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#project ComputeSslPolicy#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#timeouts ComputeSslPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSslPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeSslPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#create ComputeSslPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#delete ComputeSslPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html#update ComputeSslPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeSslPolicyTimeoutsToTerraform(struct?: ComputeSslPolicyTimeoutsOutputReference | ComputeSslPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeSslPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSslPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSslPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html google_compute_ssl_policy}.
 *
 * @stability stable
 */
export declare class ComputeSslPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_ssl_policy.html google_compute_ssl_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSslPolicyConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _customFeatures?;
    /**
     * @stability stable
     */
    get customFeatures(): string[];
    /**
     * @stability stable
     */
    set customFeatures(value: string[]);
    /**
     * @stability stable
     */
    resetCustomFeatures(): void;
    /**
     * @stability stable
     */
    get customFeaturesInput(): string[] | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get enabledFeatures(): string[];
    /**
     * @stability stable
     */
    get fingerprint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _profile?;
    /**
     * @stability stable
     */
    get profile(): string;
    /**
     * @stability stable
     */
    set profile(value: string);
    /**
     * @stability stable
     */
    resetProfile(): void;
    /**
     * @stability stable
     */
    get profileInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSslPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeSslPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSslPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
