import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleNetblockIpRangesConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/netblock_ip_ranges.html#range_type DataGoogleNetblockIpRanges#range_type}.
     *
     * @stability stable
     */
    readonly rangeType?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/netblock_ip_ranges.html google_netblock_ip_ranges}.
 *
 * @stability stable
 */
export declare class DataGoogleNetblockIpRanges extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/netblock_ip_ranges.html google_netblock_ip_ranges} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleNetblockIpRangesConfig);
    /**
     * @stability stable
     */
    get cidrBlocks(): string[];
    /**
     * @stability stable
     */
    get cidrBlocksIpv4(): string[];
    /**
     * @stability stable
     */
    get cidrBlocksIpv6(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    private _rangeType?;
    /**
     * @stability stable
     */
    get rangeType(): string;
    /**
     * @stability stable
     */
    set rangeType(value: string);
    /**
     * @stability stable
     */
    resetRangeType(): void;
    /**
     * @stability stable
     */
    get rangeTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
