import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGooglePubsubTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic.html#name DataGooglePubsubTopic#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic.html#project DataGooglePubsubTopic#project}.
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGooglePubsubTopicMessageStoragePolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get allowedPersistenceRegions(): string[];
}
/**
 * @stability stable
 */
export declare class DataGooglePubsubTopicSchemaSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get encoding(): string;
    /**
     * @stability stable
     */
    get schema(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic.html google_pubsub_topic}.
 *
 * @stability stable
 */
export declare class DataGooglePubsubTopic extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/pubsub_topic.html google_pubsub_topic} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGooglePubsubTopicConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    labels(key: string): string;
    /**
     * @stability stable
     */
    messageStoragePolicy(index: string): DataGooglePubsubTopicMessageStoragePolicy;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    schemaSettings(index: string): DataGooglePubsubTopicSchemaSettings;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
