import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DialogflowFulfillmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * The human-readable name of the fulfillment, unique within the agent.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#display_name DialogflowFulfillment#display_name}
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Whether fulfillment is enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#enabled DialogflowFulfillment#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#project DialogflowFulfillment#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * features block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#features DialogflowFulfillment#features}
     *
     * @stability stable
     */
    readonly features?: DialogflowFulfillmentFeatures[];
    /**
     * generic_web_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#generic_web_service DialogflowFulfillment#generic_web_service}
     *
     * @stability stable
     */
    readonly genericWebService?: DialogflowFulfillmentGenericWebService;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#timeouts DialogflowFulfillment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DialogflowFulfillmentTimeouts;
}
/**
 * @stability stable
 */
export interface DialogflowFulfillmentFeatures {
    /**
     * The type of the feature that enabled for fulfillment. SMALLTALK: Fulfillment is enabled for SmallTalk. Possible values: ["SMALLTALK"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#type DialogflowFulfillment#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function dialogflowFulfillmentFeaturesToTerraform(struct?: DialogflowFulfillmentFeatures): any;
/**
 * @stability stable
 */
export interface DialogflowFulfillmentGenericWebService {
    /**
     * The password for HTTP Basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#password DialogflowFulfillment#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * The HTTP request headers to send together with fulfillment requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#request_headers DialogflowFulfillment#request_headers}
     *
     * @stability stable
     */
    readonly requestHeaders?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The fulfillment URI for receiving POST requests. It must use https protocol.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#uri DialogflowFulfillment#uri}
     *
     * @stability stable
     */
    readonly uri: string;
    /**
     * The user name for HTTP Basic authentication.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#username DialogflowFulfillment#username}
     *
     * @stability stable
     */
    readonly username?: string;
}
export declare function dialogflowFulfillmentGenericWebServiceToTerraform(struct?: DialogflowFulfillmentGenericWebServiceOutputReference | DialogflowFulfillmentGenericWebService): any;
/**
 * @stability stable
 */
export declare class DialogflowFulfillmentGenericWebServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowFulfillmentGenericWebService | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowFulfillmentGenericWebService | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _requestHeaders?;
    /**
     * @stability stable
     */
    get requestHeaders(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requestHeaders(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequestHeaders(): void;
    /**
     * @stability stable
     */
    get requestHeadersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _uri?;
    /**
     * @stability stable
     */
    get uri(): string;
    /**
     * @stability stable
     */
    set uri(value: string);
    /**
     * @stability stable
     */
    get uriInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    resetUsername(): void;
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DialogflowFulfillmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#create DialogflowFulfillment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#delete DialogflowFulfillment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html#update DialogflowFulfillment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dialogflowFulfillmentTimeoutsToTerraform(struct?: DialogflowFulfillmentTimeoutsOutputReference | DialogflowFulfillmentTimeouts): any;
/**
 * @stability stable
 */
export declare class DialogflowFulfillmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DialogflowFulfillmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DialogflowFulfillmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html google_dialogflow_fulfillment}.
 *
 * @stability stable
 */
export declare class DialogflowFulfillment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment.html google_dialogflow_fulfillment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DialogflowFulfillmentConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _features?;
    /**
     * @stability stable
     */
    get features(): DialogflowFulfillmentFeatures[];
    /**
     * @stability stable
     */
    set features(value: DialogflowFulfillmentFeatures[]);
    /**
     * @stability stable
     */
    resetFeatures(): void;
    /**
     * @stability stable
     */
    get featuresInput(): DialogflowFulfillmentFeatures[] | undefined;
    private _genericWebService;
    /**
     * @stability stable
     */
    get genericWebService(): DialogflowFulfillmentGenericWebServiceOutputReference;
    /**
     * @stability stable
     */
    putGenericWebService(value: DialogflowFulfillmentGenericWebService): void;
    /**
     * @stability stable
     */
    resetGenericWebService(): void;
    /**
     * @stability stable
     */
    get genericWebServiceInput(): DialogflowFulfillmentGenericWebService | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DialogflowFulfillmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DialogflowFulfillmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DialogflowFulfillmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
