"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotSql = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Defines AWS IoT SQL.
 *
 * @experimental
 */
class IotSql {
    /**
     * (experimental) Uses the original SQL version built on 2015-10-08.
     *
     * @param sql The actual SQL-like syntax query.
     * @returns Instance of IotSql
     * @experimental
     */
    static fromStringAsVer20151008(sql) {
        return new IotSqlImpl('2015-10-08', sql);
    }
    /**
     * (experimental) Uses the SQL version built on 2016-03-23.
     *
     * @param sql The actual SQL-like syntax query.
     * @returns Instance of IotSql
     * @experimental
     */
    static fromStringAsVer20160323(sql) {
        return new IotSqlImpl('2016-03-23', sql);
    }
    /**
     * (experimental) Uses the most recent beta SQL version.
     *
     * If you use this version, it might
     * introduce breaking changes to your rules.
     *
     * @param sql The actual SQL-like syntax query.
     * @returns Instance of IotSql
     * @experimental
     */
    static fromStringAsVerNewestUnstable(sql) {
        return new IotSqlImpl('beta', sql);
    }
}
exports.IotSql = IotSql;
_a = JSII_RTTI_SYMBOL_1;
IotSql[_a] = { fqn: "@aws-cdk/aws-iot.IotSql", version: "1.141.0" };
class IotSqlImpl extends IotSql {
    constructor(version, sql) {
        super();
        this.version = version;
        this.sql = sql;
        if (sql === '') {
            throw new Error('IoT SQL string cannot be empty');
        }
    }
    bind(_scope) {
        return {
            awsIotSqlVersion: this.version,
            sql: this.sql,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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