# Generated by Django 2.2.9 on 2020-05-12 09:31

from django.conf import settings
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import gm2m.fields
from outputs import settings as outputs_settings


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    for dependency in outputs_settings.MIGRATION_DEPENDENCIES:
        dependencies.append(dependency)

    operations = [
        migrations.CreateModel(
            name='Scheduler',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('format', models.CharField(max_length=7)),
                ('context', models.CharField(max_length=10)),
                ('fields', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=40), blank=True, default=list, size=None)),
                ('query_string', models.TextField(blank=True, default='')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('routine', models.CharField(max_length=7)),
                ('is_active', models.BooleanField(default=True)),
                ('executions', django.contrib.postgres.fields.ArrayField(base_field=models.DateTimeField(), blank=True, default=list, size=None)),
                ('job_id', models.CharField(blank=True, max_length=36)),
                ('language', models.CharField(db_index=True, default='en', max_length=2)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('creator', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='scheduler_where_creator', to=settings.AUTH_USER_MODEL)),
                ('recipients', models.ManyToManyField(related_name='scheduler_where_recipient', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'scheduler',
                'verbose_name_plural': 'schedulers',
                'ordering': ('created',),
                'default_permissions': ('list', 'view', 'add', 'change', 'delete'),
            },
        ),
        migrations.CreateModel(
            name='Export',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False)),
                ('format', models.CharField(max_length=7)),
                ('context', models.CharField(max_length=10)),
                ('fields', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=40), blank=True, default=list, size=None)),
                ('query_string', models.TextField(blank=True, default='')),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(default='PENDING', max_length=10)),
                ('total', models.PositiveIntegerField(default=0)),
                ('content_type', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('creator', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='export_where_creator', to=settings.AUTH_USER_MODEL)),
                ('items', gm2m.fields.GM2MField(*outputs_settings.RELATED_MODELS, related_name='exports_where_item', through_fields=('gm2m_src', 'gm2m_tgt', 'gm2m_ct', 'gm2m_pk'))),
                ('recipients', models.ManyToManyField(related_name='export_where_recipient', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'export',
                'verbose_name_plural': 'exports',
                'ordering': ('created',),
                'default_permissions': ('list', 'view', 'add', 'change', 'delete'),
            },
        ),
    ]
