from collections.abc import Sequence
from typing import Any

from .fonts import FontFace, FontOptions, ScaledFont
from .matrix import Matrix
from .patterns import Pattern
from .surfaces import Surface

_Glyph = tuple[int, float, float]
_Rectangle = tuple[float, float, float, float]

class Context:
    def __init__(self, target: Surface) -> None: ...
    def get_target(self) -> Surface: ...
    def save(self) -> None: ...
    def restore(self) -> None: ...
    def __enter__(self) -> Context: ...
    def __exit__(self, exc_type: Any, exc_val: Any, exc_tb: Any) -> None: ...
    def push_group(self) -> None: ...
    def push_group_with_content(self, content: int) -> None: ...
    def pop_group(self) -> Pattern: ...
    def pop_group_to_source(self) -> None: ...
    def get_group_target(self) -> Surface: ...
    def set_source_rgba(
        self, red: float, green: float, blue: float, alpha: int = ...
    ) -> None: ...
    def set_source_rgb(self, red: float, green: float, blue: float) -> None: ...
    def set_source_surface(
        self, surface: Surface, x: float = ..., y: float = ...
    ) -> None: ...
    def set_source(self, source: Pattern) -> None: ...
    def get_source(self) -> Pattern: ...
    def set_antialias(self, antialias: int) -> None: ...
    def get_antialias(self) -> int: ...
    def set_dash(self, dashes: Sequence[float], offset: float = ...) -> None: ...
    def get_dash(self) -> tuple[list[float], float]: ...
    def get_dash_count(self) -> int: ...
    def set_fill_rule(self, fill_rule: int) -> None: ...
    def get_fill_rule(self) -> int: ...
    def set_line_cap(self, line_cap: int) -> None: ...
    def get_line_cap(self) -> int: ...
    def set_line_join(self, line_join: int) -> None: ...
    def get_line_join(self) -> int: ...
    def set_line_width(self, width: float) -> None: ...
    def get_line_width(self) -> float: ...
    def set_miter_limit(self, limit: float) -> None: ...
    def get_miter_limit(self) -> float: ...
    def set_operator(self, operator: int) -> None: ...
    def get_operator(self) -> int: ...
    def set_tolerance(self, tolerance: float) -> None: ...
    def get_tolerance(self) -> float: ...
    def translate(self, tx: float, ty: float) -> None: ...
    def scale(self, sx: float, sy: float | None = ...) -> None: ...
    def rotate(self, radians: float) -> None: ...
    def transform(self, matrix: Matrix) -> None: ...
    def set_matrix(self, matrix: Matrix) -> None: ...
    def get_matrix(self) -> Matrix: ...
    def identity_matrix(self) -> None: ...
    def user_to_device(self, x: float, y: float) -> tuple[float, float]: ...
    def user_to_device_distance(self, dx: float, dy: float) -> tuple[float, float]: ...
    def device_to_user(self, x: float, y: float) -> tuple[float, float]: ...
    def device_to_user_distance(self, dx: float, dy: float) -> tuple[float, float]: ...
    def has_current_point(self) -> bool: ...
    def get_current_point(self) -> tuple[float, float]: ...
    def new_path(self) -> None: ...
    def new_sub_path(self) -> None: ...
    def move_to(self, x: float, y: float) -> None: ...
    def rel_move_to(self, dx: float, dy: float) -> None: ...
    def line_to(self, x: float, y: float) -> None: ...
    def rel_line_to(self, dx: float, dy: float) -> None: ...
    def rectangle(self, x: float, y: float, width: float, height: float) -> None: ...
    def arc(
        self, xc: float, yc: float, radius: float, angle1: float, angle2: float
    ) -> None: ...
    def arc_negative(
        self, xc: float, yc: float, radius: float, angle1: float, angle2: float
    ) -> None: ...
    def curve_to(
        self, x1: float, y1: float, x2: float, y2: float, x3: float, y3: float
    ) -> None: ...
    def rel_curve_to(
        self, dx1: float, dy1: float, dx2: float, dy2: float, dx3: float, dy3: float
    ) -> None: ...
    def text_path(self, text: str) -> None: ...
    def glyph_path(self, glyphs: Sequence[_Glyph]) -> None: ...
    def close_path(self) -> None: ...
    def copy_path(self) -> list[tuple[int, tuple[int, ...]]]: ...
    def copy_path_flat(self) -> list[tuple[int, tuple[int, ...]]]: ...
    def append_path(self, path: Sequence[tuple[int, tuple[int, ...]]]) -> None: ...
    def path_extents(self) -> _Rectangle: ...
    def paint(self) -> None: ...
    def paint_with_alpha(self, alpha: float) -> None: ...
    def mask(self, pattern: Pattern) -> None: ...
    def mask_surface(
        self, surface: Surface, surface_x: float = ..., surface_y: float = ...
    ) -> None: ...
    def fill(self) -> None: ...
    def fill_preserve(self) -> None: ...
    def fill_extents(self) -> _Rectangle: ...
    def in_fill(self, x: float, y: float) -> bool: ...
    def stroke(self) -> None: ...
    def stroke_preserve(self) -> None: ...
    def stroke_extents(self) -> _Rectangle: ...
    def in_stroke(self, x: float, y: float) -> bool: ...
    def clip(self) -> None: ...
    def clip_preserve(self) -> None: ...
    def clip_extents(self) -> _Rectangle: ...
    def copy_clip_rectangle_list(self) -> list[_Rectangle]: ...
    def in_clip(self, x: float, y: float) -> bool: ...
    def reset_clip(self) -> None: ...
    def select_font_face(
        self, family: str = ..., slant: int = ..., weight: int = ...
    ) -> None: ...
    def set_font_face(self, font_face: FontFace) -> None: ...
    def get_font_face(self) -> FontFace: ...
    def set_font_size(self, size: float) -> None: ...
    def set_font_matrix(self, matrix: Matrix) -> None: ...
    def get_font_matrix(self) -> Matrix: ...
    def set_font_options(self, font_options: FontOptions) -> None: ...
    def get_font_options(self) -> FontOptions: ...
    def set_scaled_font(self, scaled_font: ScaledFont) -> None: ...
    def get_scaled_font(self) -> ScaledFont: ...
    def font_extents(self) -> tuple[float, float, float, float, float]: ...
    def text_extents(
        self, text: str
    ) -> tuple[float, float, float, float, float, float]: ...
    def glyph_extents(
        self, glyphs: Sequence[_Glyph]
    ) -> tuple[float, float, float, float, float, float]: ...
    def show_text(self, text: str) -> None: ...
    def show_glyphs(self, glyphs: Sequence[_Glyph]) -> None: ...
    def show_text_glyphs(
        self,
        text: str,
        glyphs: Sequence[_Glyph],
        clusters: Sequence[tuple[int, int]],
        cluster_flags: int = ...,
    ) -> None: ...
    def show_page(self) -> None: ...
    def copy_page(self) -> None: ...
    def tag_begin(self, tag_name: str, attributes: str | None = ...) -> None: ...
    def tag_end(self, tag_name: str) -> None: ...
