from collections.abc import Sequence
from typing import Any, BinaryIO, overload, type_check_only

from typing_extensions import Literal, Protocol, SupportsIndex

from .fonts import FontOptions
@type_check_only
class FFIBuffer(Protocol):
    def __bytes__(self) -> bytes: ...
    def __len__(self) -> int: ...
    def __getitem__(self, index: SupportsIndex) -> bytes: ...
    def __setitem__(self, index: SupportsIndex, value: bytes) -> None: ...

_MIMEType = Literal["image/png", "image/jpeg", "image/jp2", "text/x-uri"]
_Rectangle = tuple[float, float, float, float]

class KeepAlive:
    instances: Any
    objects: Sequence[object]
    closure: Any
    def __init__(self, *objects: object) -> None: ...
    def save(self) -> None: ...

class Surface:
    def __init__(self, pointer: Any, target_keep_alive: Any = ...) -> None: ...
    def create_similar(self, content: str, width: int, height: int) -> Surface: ...
    def create_similar_image(
        self, content: str, width: int, height: int
    ) -> ImageSurface: ...
    def create_for_rectangle(
        self, x: float, y: float, width: float, height: float
    ) -> Surface: ...
    def get_content(self) -> int: ...
    def has_show_text_glyphs(self) -> bool: ...
    def set_device_offset(self, x_offset: float, y_offset: float) -> None: ...
    def get_device_offset(self) -> tuple[float, float]: ...
    def set_fallback_resolution(
        self, x_pixels_per_inch: float, y_pixels_per_inch: float
    ) -> None: ...
    def get_fallback_resolution(self) -> tuple[float, float]: ...
    def get_font_options(self) -> FontOptions: ...
    def set_device_scale(self, x_scale: float, y_scale: float) -> None: ...
    def get_device_scale(self) -> tuple[float, float]: ...
    def set_mime_data(self, mime_type: _MIMEType, data: bytes,) -> None: ...
    def get_mime_data(self, mime_type: _MIMEType) -> FFIBuffer: ...
    def supports_mime_type(self, mime_type: _MIMEType) -> bool: ...
    def mark_dirty(self) -> None: ...
    def mark_dirty_rectangle(
        self, x: float, y: float, width: float, height: float
    ) -> None: ...
    def show_page(self) -> None: ...
    def copy_page(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    @overload
    def write_to_png(self, target: str | BinaryIO) -> None: ...
    @overload
    def write_to_png(self, target: None = ...) -> bytes: ...

class ImageSurface(Surface):
    def __init__(
        self,
        format: int,
        width: int,
        height: int,
        data: Any | None = ...,
        stride: int | None = ...,
    ) -> None: ...
    @classmethod
    def create_for_data(
        cls, data: Any, format: int, width: int, height: int, stride: Any | None = ...,
    ) -> ImageSurface: ...
    @staticmethod
    def format_stride_for_width(format: int, width: int) -> int: ...
    @classmethod
    def create_from_png(cls, source: str | BinaryIO) -> ImageSurface: ...
    def get_data(self) -> FFIBuffer: ...
    def get_format(self) -> int: ...
    def get_width(self) -> int: ...
    def get_height(self) -> int: ...
    def get_stride(self) -> int: ...

class PDFSurface(Surface):
    def __init__(
        self,
        target: str | BinaryIO | None,
        width_in_points: float,
        height_in_points: float,
    ) -> None: ...
    def set_size(self, width_in_points: float, height_in_points: float) -> None: ...
    def add_outline(
        self, parent_id: int, utf8: str, link_attribs: int, flags: int | None = ...
    ) -> int: ...
    def set_metadata(self, metadata: int, utf8: str) -> None: ...
    def set_page_label(self, utf8: str) -> None: ...
    def set_thumbnail_size(self, width: int, height: int) -> None: ...
    def restrict_to_version(self, version: int) -> None: ...
    @staticmethod
    def get_versions() -> list[int]: ...
    @staticmethod
    def version_to_string(version: int) -> str: ...

class PSSurface(Surface):
    def __init__(
        self,
        target: str | BinaryIO | None,
        width_in_points: float,
        height_in_points: float,
    ) -> None: ...
    def dsc_comment(self, comment: str) -> None: ...
    def dsc_begin_setup(self) -> None: ...
    def dsc_begin_page_setup(self) -> None: ...
    def set_eps(self, eps: bool) -> None: ...
    def get_eps(self) -> bool: ...
    def set_size(self, width_in_points: float, height_in_points: float) -> None: ...
    def restrict_to_level(self, level: int) -> None: ...
    @staticmethod
    def get_levels() -> list[int]: ...
    @staticmethod
    def ps_level_to_string(level: int) -> str: ...

class SVGSurface(Surface):
    def __init__(
        self,
        target: str | BinaryIO | None,
        width_in_points: float,
        height_in_points: float,
    ) -> None: ...
    def restrict_to_version(self, version: int) -> None: ...
    def set_document_unit(self, unit: int) -> None: ...
    def get_document_unit(self) -> int: ...
    @staticmethod
    def get_versions() -> list[int]: ...
    @staticmethod
    def version_to_string(version: int) -> str: ...

class RecordingSurface(Surface):
    def __init__(self, content: int, extents: _Rectangle) -> None: ...
    def get_extents(self) -> _Rectangle: ...
    def ink_extents(self) -> _Rectangle: ...

class Win32Surface(Surface):
    def __init__(self, hdc: int) -> None: ...

class Win32PrintingSurface(Surface):
    def __init__(self, hdc: int) -> None: ...
