#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['rmtoo',
 'rmtoo.gui1',
 'rmtoo.imports',
 'rmtoo.inputs',
 'rmtoo.lib',
 'rmtoo.lib.analytics',
 'rmtoo.lib.configuration',
 'rmtoo.lib.digraph',
 'rmtoo.lib.logging',
 'rmtoo.lib.main',
 'rmtoo.lib.storagebackend',
 'rmtoo.lib.storagebackend.txtfile',
 'rmtoo.lib.vcs',
 'rmtoo.lib.xmlutils',
 'rmtoo.outputs']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['setuptools',
 'numpy>=1.12.0',
 'scipy>=0.19.0',
 'six>=1.10.0',
 'future>=0.16.0',
 'gitdb==0.6.4',
 'gitpython==1.0.2',
 'pyyaml>=3.12',
 'stevedore>=1.21',
 'pylint>=1.7.1',
 'odfpy==1.3.4',
 'jinja2>=2.10',
 'openpyxl>=2.5.6']

extras_require = \
{'test': ['pytest', 'pytest-cov', 'tox', 'flake8', 'xmldiff==2.4']}

entry_points = \
{'console_scripts': ['rmtoo = rmtoo.lib.RmtooMain:main',
                     'sltoo = rmtoo.lib.RmtooMain:main',
                     'sltoo-normalize-dependencies = '
                     'rmtoo.lib.main.NormalizeDependencies:main',
                     'sltoo-pricing-graph = rmtoo.lib.main.PricingGraph:main'],
 'rmtoo.imports.plugin': ['xls = rmtoo.imports.xls:XlsImport'],
 'rmtoo.input.plugin': ['RDepConstraints = '
                        'rmtoo.inputs.RDepConstraints:RDepConstraints',
                        'RDepDependsOn = '
                        'rmtoo.inputs.RDepDependsOn:RDepDependsOn',
                        'RDepMasterNodes = '
                        'rmtoo.inputs.RDepMasterNodes:RDepMasterNodes',
                        'RDepNoDirectedCircles = '
                        'rmtoo.inputs.RDepNoDirectedCircles:RDepNoDirectedCircles',
                        'RDepOneComponent = '
                        'rmtoo.inputs.RDepOneComponent:RDepOneComponent',
                        'RDepPriority = rmtoo.inputs.RDepPriority:RDepPriority',
                        'RDepSolvedBy = rmtoo.inputs.RDepSolvedBy:RDepSolvedBy',
                        'ReqCE3 = rmtoo.inputs.ReqCE3:ReqCE3',
                        'ReqClass = rmtoo.inputs.ReqClass:ReqClass',
                        'ReqConstraints = '
                        'rmtoo.inputs.ReqConstraints:ReqConstraints',
                        'ReqDescription = '
                        'rmtoo.inputs.ReqDescription:ReqDescription',
                        'ReqEffortEst = rmtoo.inputs.ReqEffortEst:ReqEffortEst',
                        'ReqExpectedResult = '
                        'rmtoo.inputs.ReqExpectedResult:ReqExpectedResult',
                        'ReqHistory = rmtoo.inputs.ReqHistory:ReqHistory',
                        'ReqInventedBy = '
                        'rmtoo.inputs.ReqInventedBy:ReqInventedBy',
                        'ReqInventedOn = '
                        'rmtoo.inputs.ReqInventedOn:ReqInventedOn',
                        'ReqName = rmtoo.inputs.ReqName:ReqName',
                        'ReqNote = rmtoo.inputs.ReqNote:ReqNote',
                        'ReqOwner = rmtoo.inputs.ReqOwner:ReqOwner',
                        'ReqPriority = rmtoo.inputs.ReqPriority:ReqPriority',
                        'ReqRationale = rmtoo.inputs.ReqRationale:ReqRationale',
                        'ReqStatus = rmtoo.inputs.ReqStatus:ReqStatus',
                        'ReqTestCase = rmtoo.inputs.ReqTestCase:ReqTestCase',
                        'ReqTopic = rmtoo.inputs.ReqTopic:ReqTopic',
                        'ReqType = rmtoo.inputs.ReqType:ReqType'],
 'rmtoo.input.requirement_status': ['assigned = '
                                    'rmtoo.lib.RequirementStatus:RequirementStatusAssigned',
                                    'finished = '
                                    'rmtoo.lib.RequirementStatus:RequirementStatusFinished',
                                    'not done = '
                                    'rmtoo.lib.RequirementStatus:RequirementStatusNotDone'],
 'rmtoo.output.markup': ['html = rmtoo.lib.Markup:Html',
                         'latex = rmtoo.lib.Markup:LaTeX',
                         'txt = rmtoo.lib.Markup:Txt'],
 'rmtoo.output.plugin': ['LatexJinja2 = rmtoo.outputs.LatexJinja2:LatexJinja2',
                         'graph = rmtoo.outputs.graph:graph',
                         'graph2 = rmtoo.outputs.graph2:graph2',
                         'html = rmtoo.outputs.html:Html',
                         'latex2 = rmtoo.outputs.latex2:latex2',
                         'oopricing1 = rmtoo.outputs.oopricing1:oopricing1',
                         'prios = rmtoo.outputs.prios:prios',
                         'stats_burndown1 = '
                         'rmtoo.outputs.stats_burndown1:stats_burndown1',
                         'stats_reqs_cnt = '
                         'rmtoo.outputs.stats_reqs_cnt:stats_reqs_cnt',
                         'stats_sprint_burndown1 = '
                         'rmtoo.outputs.stats_sprint_burndown1:stats_sprint_burndown1',
                         'tlp1 = rmtoo.outputs.tlp1:Tlp1',
                         'version1 = rmtoo.outputs.version1:version1',
                         'xls = rmtoo.outputs.xls:Xls',
                         'xml1 = rmtoo.outputs.xml1:Xml1',
                         'xml_ganttproject_2 = '
                         'rmtoo.outputs.xml_ganttproject_2:xml_ganttproject_2']}

setup(name='sltoo',
      version='24.4.1',
      description='rmtoo',
      author='Kristoffer Nordström',
      author_email='kristoffer@nordstroem.ch',
      url='https://github.com/kown7/rmtoo',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
     )
