/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.tree;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.sampler.WeightedPoint;
import com.amazon.randomcutforest.tree.BoundingBox;
import com.amazon.randomcutforest.tree.Cut;
import com.amazon.randomcutforest.tree.Node;
import com.amazon.randomcutforest.tree.RandomCutTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;

public class HyperTree
extends RandomCutTree {
    private final Function<BoundingBox, double[]> gVecBuild;

    public Function<BoundingBox, double[]> getgVec() {
        return this.gVecBuild;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected HyperTree(Builder builder) {
        super(builder);
        this.gVecBuild = builder.gVec;
    }

    public void makeTree(List<double[]> list, int seed) {
        this.root = list.size() > 0 ? this.makeTreeInt(list, seed, 0, this.gVecBuild) : null;
    }

    private Node makeTreeInt(List<double[]> pointList, int seed, int level, Function<BoundingBox, double[]> vecBuild) {
        if (pointList.size() == 0) {
            return null;
        }
        BoundingBox thisBox = new BoundingBox(pointList.get(0));
        for (int i = 1; i < pointList.size(); ++i) {
            thisBox = thisBox.getMergedBox(pointList.get(i));
        }
        if (thisBox.getRangeSum() <= 0.0) {
            double[] first = pointList.get(0);
            Node x = new Node(first);
            x.setMass(pointList.size());
            return x;
        }
        Random ring = new Random(seed);
        int leftSeed = ring.nextInt();
        int rightSeed = ring.nextInt();
        Cut cut = this.getCut(thisBox, ring, vecBuild);
        ArrayList<double[]> leftList = new ArrayList<double[]>();
        ArrayList<double[]> rightList = new ArrayList<double[]>();
        for (int j = 0; j < pointList.size(); ++j) {
            if (Cut.isLeftOf(pointList.get(j), cut)) {
                leftList.add(pointList.get(j));
                continue;
            }
            rightList.add(pointList.get(j));
        }
        Node leftNode = this.makeTreeInt(leftList, leftSeed, level + 1, vecBuild);
        Node rightNode = this.makeTreeInt(rightList, rightSeed, level + 1, vecBuild);
        Node thisNode = new Node(leftNode, rightNode, cut, thisBox);
        leftNode.setParent(thisNode);
        rightNode.setParent(thisNode);
        thisNode.setMass(pointList.size());
        return thisNode;
    }

    private Cut getCut(BoundingBox bb, Random ring, Function<BoundingBox, double[]> vecSeparation) {
        Random rng = new Random(ring.nextInt());
        double cutf = rng.nextDouble();
        double dimf = rng.nextDouble();
        int td = -1;
        double rangeSum = 0.0;
        double[] vector = vecSeparation.apply(bb);
        for (int i = 0; i < bb.getDimensions(); ++i) {
            rangeSum += vector[i];
        }
        double breakPoint = dimf * rangeSum;
        for (int i = 0; i < bb.getDimensions(); ++i) {
            double range = vector[i];
            if (!(range > 0.0)) continue;
            if (breakPoint > 0.0 && breakPoint <= range) {
                td = i;
            }
            breakPoint -= range;
        }
        CommonUtils.checkArgument(td != -1, "Pivot selection failed.");
        return new Cut(td, bb.getMinValue(td) + bb.getRange(td) * cutf);
    }

    @Override
    public void addPoint(WeightedPoint point) {
    }

    @Override
    public void deletePoint(WeightedPoint point) {
    }

    public static class Builder
    extends RandomCutTree.Builder<Builder> {
        private Function<BoundingBox, double[]> gVec;

        public Builder buildGVec(Function<BoundingBox, double[]> gVec) {
            this.gVec = gVec;
            return this;
        }

        @Override
        public HyperTree build() {
            return new HyperTree(this);
        }
    }
}

