"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint.
 *
 * @stability stable
 */
class InstanceEndpoint {
    /**
     * @stability stable
     */
    constructor(instance, options = {}) {
        this.instance = instance;
        this.options = options;
        _util_1.validateWeight(options.weight);
        this.region = instance.env.region;
    }
    /**
     * Render the endpoint to an endpoint configuration.
     *
     * @stability stable
     */
    renderEndpointConfiguration() {
        return {
            endpointId: this.instance.instanceId,
            weight: this.options.weight,
            clientIpPreservationEnabled: this.options.preserveClientIp,
        };
    }
}
exports.InstanceEndpoint = InstanceEndpoint;
_a = JSII_RTTI_SYMBOL_1;
InstanceEndpoint[_a] = { fqn: "@aws-cdk/aws-globalaccelerator-endpoints.InstanceEndpoint", version: "1.113.0" };
//# sourceMappingURL=data:application/json;base64,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