import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoadbalancerFrontendConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the default backend where traffic will be routed. Note, default backend can be overwritten in frontend rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#default_backend_name LoadbalancerFrontend#default_backend_name}
    */
    readonly defaultBackendName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#id LoadbalancerFrontend#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * ID of the load balancer to which the frontend is connected.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#loadbalancer LoadbalancerFrontend#loadbalancer}
    */
    readonly loadbalancer: string;
    /**
    * When load balancer operating in `tcp` mode it acts as a layer 4 proxy. In `http` mode it acts as a layer 7 proxy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#mode LoadbalancerFrontend#mode}
    */
    readonly mode: string;
    /**
    * The name of the frontend must be unique within the load balancer service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#name LoadbalancerFrontend#name}
    */
    readonly name: string;
    /**
    * Port to listen incoming requests
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#port LoadbalancerFrontend#port}
    */
    readonly port: number;
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#properties LoadbalancerFrontend#properties}
    */
    readonly properties?: LoadbalancerFrontendProperties;
}
export interface LoadbalancerFrontendProperties {
    /**
    * Enable or disable inbound proxy protocol support.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#inbound_proxy_protocol LoadbalancerFrontend#inbound_proxy_protocol}
    */
    readonly inboundProxyProtocol?: boolean | cdktf.IResolvable;
    /**
    * Client request timeout in seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend#timeout_client LoadbalancerFrontend#timeout_client}
    */
    readonly timeoutClient?: number;
}
export declare function loadbalancerFrontendPropertiesToTerraform(struct?: LoadbalancerFrontendPropertiesOutputReference | LoadbalancerFrontendProperties): any;
export declare class LoadbalancerFrontendPropertiesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoadbalancerFrontendProperties | undefined;
    set internalValue(value: LoadbalancerFrontendProperties | undefined);
    private _inboundProxyProtocol?;
    get inboundProxyProtocol(): boolean | cdktf.IResolvable;
    set inboundProxyProtocol(value: boolean | cdktf.IResolvable);
    resetInboundProxyProtocol(): void;
    get inboundProxyProtocolInput(): boolean | cdktf.IResolvable | undefined;
    private _timeoutClient?;
    get timeoutClient(): number;
    set timeoutClient(value: number);
    resetTimeoutClient(): void;
    get timeoutClientInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend upcloud_loadbalancer_frontend}
*/
export declare class LoadbalancerFrontend extends cdktf.TerraformResource {
    static readonly tfResourceType = "upcloud_loadbalancer_frontend";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/upcloud/r/loadbalancer_frontend upcloud_loadbalancer_frontend} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoadbalancerFrontendConfig
    */
    constructor(scope: Construct, id: string, config: LoadbalancerFrontendConfig);
    private _defaultBackendName?;
    get defaultBackendName(): string;
    set defaultBackendName(value: string);
    get defaultBackendNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _loadbalancer?;
    get loadbalancer(): string;
    set loadbalancer(value: string);
    get loadbalancerInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    get rules(): string[];
    get tlsConfigs(): string[];
    private _properties;
    get properties(): LoadbalancerFrontendPropertiesOutputReference;
    putProperties(value: LoadbalancerFrontendProperties): void;
    resetProperties(): void;
    get propertiesInput(): LoadbalancerFrontendProperties | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
