"""
    Sendbird Platform SDK

    Sendbird Platform API SDK  https://sendbird.com/docs/chat/v3/platform-api/getting-started/prepare-to-use-api  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@sendbird.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from sendbird_platform_sdk.api_client import ApiClient, Endpoint as _Endpoint
from sendbird_platform_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from sendbird_platform_sdk.model.gc_accept_invitation_data import GcAcceptInvitationData
from sendbird_platform_sdk.model.gc_check_if_member_by_id_response import GcCheckIfMemberByIdResponse
from sendbird_platform_sdk.model.gc_create_channel_data import GcCreateChannelData
from sendbird_platform_sdk.model.gc_decline_invitation_data import GcDeclineInvitationData
from sendbird_platform_sdk.model.gc_hide_or_archive_channel_data import GcHideOrArchiveChannelData
from sendbird_platform_sdk.model.gc_invite_as_members_data import GcInviteAsMembersData
from sendbird_platform_sdk.model.gc_join_channel_data import GcJoinChannelData
from sendbird_platform_sdk.model.gc_leave_channel_data import GcLeaveChannelData
from sendbird_platform_sdk.model.gc_list_channels_response import GcListChannelsResponse
from sendbird_platform_sdk.model.gc_list_members_response import GcListMembersResponse
from sendbird_platform_sdk.model.gc_list_operators_response import GcListOperatorsResponse
from sendbird_platform_sdk.model.gc_register_operators_data import GcRegisterOperatorsData
from sendbird_platform_sdk.model.gc_register_operators_response import GcRegisterOperatorsResponse
from sendbird_platform_sdk.model.gc_reset_chat_history_data import GcResetChatHistoryData
from sendbird_platform_sdk.model.gc_reset_chat_history_response import GcResetChatHistoryResponse
from sendbird_platform_sdk.model.gc_update_channel_by_url_data import GcUpdateChannelByUrlData
from sendbird_platform_sdk.model.oc_delete_channel_by_url200_response import OcDeleteChannelByUrl200Response
from sendbird_platform_sdk.model.send_bird_group_channel import SendBirdGroupChannel


class GroupChannelApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.gc_accept_invitation_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdGroupChannel,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/accept',
                'operation_id': 'gc_accept_invitation',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'gc_accept_invitation_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'gc_accept_invitation_data':
                        (GcAcceptInvitationData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'gc_accept_invitation_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_cancel_the_registration_of_operators_endpoint = _Endpoint(
            settings={
                'response_type': (OcDeleteChannelByUrl200Response,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/operators',
                'operation_id': 'gc_cancel_the_registration_of_operators',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'operator_ids',
                    'delete_all',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                    'operator_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'operator_ids':
                        ([str],),
                    'delete_all':
                        (bool,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                    'operator_ids': 'operator_ids',
                    'delete_all': 'delete_all',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'operator_ids': 'query',
                    'delete_all': 'query',
                },
                'collection_format_map': {
                    'operator_ids': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gc_check_if_member_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (GcCheckIfMemberByIdResponse,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/members/{user_id}',
                'operation_id': 'gc_check_if_member_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'user_id',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gc_create_channel_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdGroupChannel,),
                'auth': [],
                'endpoint_path': '/v3/group_channels',
                'operation_id': 'gc_create_channel',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'gc_create_channel_data',
                ],
                'required': [
                    'api_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'gc_create_channel_data':
                        (GcCreateChannelData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                },
                'location_map': {
                    'api_token': 'header',
                    'gc_create_channel_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_decline_invitation_endpoint = _Endpoint(
            settings={
                'response_type': (OcDeleteChannelByUrl200Response,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/decline',
                'operation_id': 'gc_decline_invitation',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'gc_decline_invitation_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'gc_decline_invitation_data':
                        (GcDeclineInvitationData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'gc_decline_invitation_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_delete_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (OcDeleteChannelByUrl200Response,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}',
                'operation_id': 'gc_delete_channel_by_url',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gc_hide_or_archive_channel_endpoint = _Endpoint(
            settings={
                'response_type': (OcDeleteChannelByUrl200Response,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/hide',
                'operation_id': 'gc_hide_or_archive_channel',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'gc_hide_or_archive_channel_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'gc_hide_or_archive_channel_data':
                        (GcHideOrArchiveChannelData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'gc_hide_or_archive_channel_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_invite_as_members_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdGroupChannel,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/invite',
                'operation_id': 'gc_invite_as_members',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'gc_invite_as_members_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'gc_invite_as_members_data':
                        (GcInviteAsMembersData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'gc_invite_as_members_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_join_channel_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/join',
                'operation_id': 'gc_join_channel',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'gc_join_channel_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'gc_join_channel_data':
                        (GcJoinChannelData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'gc_join_channel_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_leave_channel_endpoint = _Endpoint(
            settings={
                'response_type': (OcDeleteChannelByUrl200Response,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/leave',
                'operation_id': 'gc_leave_channel',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'gc_leave_channel_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'gc_leave_channel_data':
                        (GcLeaveChannelData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'gc_leave_channel_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_list_channels_endpoint = _Endpoint(
            settings={
                'response_type': (GcListChannelsResponse,),
                'auth': [],
                'endpoint_path': '/v3/group_channels',
                'operation_id': 'gc_list_channels',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'token',
                    'limit',
                    'distinct_mode',
                    'public_mode',
                    'super_mode',
                    'created_after',
                    'created_before',
                    'show_empty',
                    'show_member',
                    'show_delivery_receipt',
                    'show_read_receipt',
                    'show_metadata',
                    'show_frozen',
                    'order',
                    'metadata_order_key',
                    'custom_types',
                    'custom_type_startswith',
                    'channel_urls',
                    'name',
                    'name_contains',
                    'name_startswith',
                    'members_exactly_in',
                    'members_include_in',
                    'query_type',
                    'members_nickname',
                    'members_nickname_contains',
                    'metadata_key',
                    'metadata_values',
                    'metadata_value_startswith',
                    'metacounter_key',
                    'metacounter_values',
                    'metacounter_value_gt',
                    'metacounter_value_gte',
                    'metacounter_value_lt',
                    'metacounter_value_lte',
                    'include_sorted_metaarray_in_last_message',
                    'custom_type',
                    'read_receipt',
                    'member',
                    'is_distinct',
                    'members_in',
                    'user_id',
                ],
                'required': [
                    'api_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'token':
                        (str,),
                    'limit':
                        (int,),
                    'distinct_mode':
                        (str,),
                    'public_mode':
                        (str,),
                    'super_mode':
                        (str,),
                    'created_after':
                        (int,),
                    'created_before':
                        (int,),
                    'show_empty':
                        (bool,),
                    'show_member':
                        (bool,),
                    'show_delivery_receipt':
                        (bool,),
                    'show_read_receipt':
                        (bool,),
                    'show_metadata':
                        (bool,),
                    'show_frozen':
                        (bool,),
                    'order':
                        (str,),
                    'metadata_order_key':
                        (str,),
                    'custom_types':
                        (str,),
                    'custom_type_startswith':
                        (str,),
                    'channel_urls':
                        (str,),
                    'name':
                        (str,),
                    'name_contains':
                        (str,),
                    'name_startswith':
                        (str,),
                    'members_exactly_in':
                        (str,),
                    'members_include_in':
                        (str,),
                    'query_type':
                        (str,),
                    'members_nickname':
                        (str,),
                    'members_nickname_contains':
                        (str,),
                    'metadata_key':
                        (str,),
                    'metadata_values':
                        (str,),
                    'metadata_value_startswith':
                        (str,),
                    'metacounter_key':
                        (str,),
                    'metacounter_values':
                        (str,),
                    'metacounter_value_gt':
                        (str,),
                    'metacounter_value_gte':
                        (str,),
                    'metacounter_value_lt':
                        (str,),
                    'metacounter_value_lte':
                        (str,),
                    'include_sorted_metaarray_in_last_message':
                        (bool,),
                    'custom_type':
                        (str,),
                    'read_receipt':
                        (bool,),
                    'member':
                        (bool,),
                    'is_distinct':
                        (bool,),
                    'members_in':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'token': 'token',
                    'limit': 'limit',
                    'distinct_mode': 'distinct_mode',
                    'public_mode': 'public_mode',
                    'super_mode': 'super_mode',
                    'created_after': 'created_after',
                    'created_before': 'created_before',
                    'show_empty': 'show_empty',
                    'show_member': 'show_member',
                    'show_delivery_receipt': 'show_delivery_receipt',
                    'show_read_receipt': 'show_read_receipt',
                    'show_metadata': 'show_metadata',
                    'show_frozen': 'show_frozen',
                    'order': 'order',
                    'metadata_order_key': 'metadata_order_key',
                    'custom_types': 'custom_types',
                    'custom_type_startswith': 'custom_type_startswith',
                    'channel_urls': 'channel_urls',
                    'name': 'name',
                    'name_contains': 'name_contains',
                    'name_startswith': 'name_startswith',
                    'members_exactly_in': 'members_exactly_in',
                    'members_include_in': 'members_include_in',
                    'query_type': 'query_type',
                    'members_nickname': 'members_nickname',
                    'members_nickname_contains': 'members_nickname_contains',
                    'metadata_key': 'metadata_key',
                    'metadata_values': 'metadata_values',
                    'metadata_value_startswith': 'metadata_value_startswith',
                    'metacounter_key': 'metacounter_key',
                    'metacounter_values': 'metacounter_values',
                    'metacounter_value_gt': 'metacounter_value_gt',
                    'metacounter_value_gte': 'metacounter_value_gte',
                    'metacounter_value_lt': 'metacounter_value_lt',
                    'metacounter_value_lte': 'metacounter_value_lte',
                    'include_sorted_metaarray_in_last_message': 'include_sorted_metaarray_in_last_message',
                    'custom_type': 'custom_type',
                    'read_receipt': 'read_receipt',
                    'member': 'member',
                    'is_distinct': 'is_distinct',
                    'members_in': 'members_in',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'token': 'query',
                    'limit': 'query',
                    'distinct_mode': 'query',
                    'public_mode': 'query',
                    'super_mode': 'query',
                    'created_after': 'query',
                    'created_before': 'query',
                    'show_empty': 'query',
                    'show_member': 'query',
                    'show_delivery_receipt': 'query',
                    'show_read_receipt': 'query',
                    'show_metadata': 'query',
                    'show_frozen': 'query',
                    'order': 'query',
                    'metadata_order_key': 'query',
                    'custom_types': 'query',
                    'custom_type_startswith': 'query',
                    'channel_urls': 'query',
                    'name': 'query',
                    'name_contains': 'query',
                    'name_startswith': 'query',
                    'members_exactly_in': 'query',
                    'members_include_in': 'query',
                    'query_type': 'query',
                    'members_nickname': 'query',
                    'members_nickname_contains': 'query',
                    'metadata_key': 'query',
                    'metadata_values': 'query',
                    'metadata_value_startswith': 'query',
                    'metacounter_key': 'query',
                    'metacounter_values': 'query',
                    'metacounter_value_gt': 'query',
                    'metacounter_value_gte': 'query',
                    'metacounter_value_lt': 'query',
                    'metacounter_value_lte': 'query',
                    'include_sorted_metaarray_in_last_message': 'query',
                    'custom_type': 'query',
                    'read_receipt': 'query',
                    'member': 'query',
                    'is_distinct': 'query',
                    'members_in': 'query',
                    'user_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gc_list_members_endpoint = _Endpoint(
            settings={
                'response_type': (GcListMembersResponse,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/members',
                'operation_id': 'gc_list_members',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'token',
                    'limit',
                    'show_delivery_receipt',
                    'show_read_receipt',
                    'order',
                    'operator_filter',
                    'member_state_filter',
                    'muted_member_filter',
                    'nickname_startswith',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'token':
                        (str,),
                    'limit':
                        (int,),
                    'show_delivery_receipt':
                        (bool,),
                    'show_read_receipt':
                        (bool,),
                    'order':
                        (str,),
                    'operator_filter':
                        (str,),
                    'member_state_filter':
                        (str,),
                    'muted_member_filter':
                        (str,),
                    'nickname_startswith':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                    'token': 'token',
                    'limit': 'limit',
                    'show_delivery_receipt': 'show_delivery_receipt',
                    'show_read_receipt': 'show_read_receipt',
                    'order': 'order',
                    'operator_filter': 'operator_filter',
                    'member_state_filter': 'member_state_filter',
                    'muted_member_filter': 'muted_member_filter',
                    'nickname_startswith': 'nickname_startswith',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'token': 'query',
                    'limit': 'query',
                    'show_delivery_receipt': 'query',
                    'show_read_receipt': 'query',
                    'order': 'query',
                    'operator_filter': 'query',
                    'member_state_filter': 'query',
                    'muted_member_filter': 'query',
                    'nickname_startswith': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gc_list_operators_endpoint = _Endpoint(
            settings={
                'response_type': (GcListOperatorsResponse,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/operators',
                'operation_id': 'gc_list_operators',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'token',
                    'limit',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'token':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                    'token': 'token',
                    'limit': 'limit',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'token': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gc_register_operators_endpoint = _Endpoint(
            settings={
                'response_type': (GcRegisterOperatorsResponse,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/operators',
                'operation_id': 'gc_register_operators',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'gc_register_operators_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'gc_register_operators_data':
                        (GcRegisterOperatorsData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'gc_register_operators_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_reset_chat_history_endpoint = _Endpoint(
            settings={
                'response_type': (GcResetChatHistoryResponse,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/reset_user_history',
                'operation_id': 'gc_reset_chat_history',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'gc_reset_chat_history_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'gc_reset_chat_history_data':
                        (GcResetChatHistoryData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'gc_reset_chat_history_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_unhide_or_unarchive_channel_endpoint = _Endpoint(
            settings={
                'response_type': (OcDeleteChannelByUrl200Response,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}/hide',
                'operation_id': 'gc_unhide_or_unarchive_channel',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'user_id',
                    'should_unhide_all',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'user_id':
                        (str,),
                    'should_unhide_all':
                        (bool,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                    'user_id': 'user_id',
                    'should_unhide_all': 'should_unhide_all',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'user_id': 'query',
                    'should_unhide_all': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.gc_update_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdGroupChannel,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}',
                'operation_id': 'gc_update_channel_by_url',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'gc_update_channel_by_url_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'gc_update_channel_by_url_data':
                        (GcUpdateChannelByUrlData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'gc_update_channel_by_url_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.gc_view_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdGroupChannel,),
                'auth': [],
                'endpoint_path': '/v3/group_channels/{channel_url}',
                'operation_id': 'gc_view_channel_by_url',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'show_delivery_receipt',
                    'show_read_receipt',
                    'show_member',
                    'read_receipt',
                    'member',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'show_delivery_receipt':
                        (bool,),
                    'show_read_receipt':
                        (bool,),
                    'show_member':
                        (bool,),
                    'read_receipt':
                        (bool,),
                    'member':
                        (bool,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                    'show_delivery_receipt': 'show_delivery_receipt',
                    'show_read_receipt': 'show_read_receipt',
                    'show_member': 'show_member',
                    'read_receipt': 'read_receipt',
                    'member': 'member',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'show_delivery_receipt': 'query',
                    'show_read_receipt': 'query',
                    'show_member': 'query',
                    'read_receipt': 'query',
                    'member': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def gc_accept_invitation(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Accept an invitation  # noqa: E501

        ## Accept an invitation  Accepts an invitation from a [private](#4-private-vs-public) group channel for a user to join. Since a user is allowed to join up to 2,000 group channels, the invitation to a user who already belongs to a maximum number of group channels will be canceled automatically.  > __Note__: This action is effective only when the `auto_accept` property of an application is set to false. You can change the value of the property using the [update default channel invitation preference](https://sendbird.com/docs/chat/v3/platform-api/guides/application#2-update-default-channel-invitation-preference) action, or [update a user's channel invitation preference](https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-update-channel-invitation-preference) action.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-accept-an-invitation ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_accept_invitation(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            gc_accept_invitation_data (GcAcceptInvitationData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdGroupChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_accept_invitation_endpoint.call_with_http_info(**kwargs)

    def gc_cancel_the_registration_of_operators(
        self,
        api_token,
        channel_url,
        operator_ids,
        **kwargs
    ):
        """Cancel the registration of operators  # noqa: E501

        ## Cancel the registration of operators  Cancels the registration of operators from a group channel but leave them as members.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-cancel-the-registration-of-operators ----------------------------   `channel_url`      Type: string      Description: Specifies the URL of the channel to cancel the registration of operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_cancel_the_registration_of_operators(api_token, channel_url, operator_ids, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):
            operator_ids ([str]):

        Keyword Args:
            delete_all (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcDeleteChannelByUrl200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        kwargs['operator_ids'] = \
            operator_ids
        return self.gc_cancel_the_registration_of_operators_endpoint.call_with_http_info(**kwargs)

    def gc_check_if_member_by_id(
        self,
        api_token,
        channel_url,
        user_id,
        **kwargs
    ):
        """Check if member  # noqa: E501

        ## Check if member  Checks whether the user is a member of the group channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-check-if-member ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_check_if_member_by_id(api_token, channel_url, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):
            user_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GcCheckIfMemberByIdResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        kwargs['user_id'] = \
            user_id
        return self.gc_check_if_member_by_id_endpoint.call_with_http_info(**kwargs)

    def gc_create_channel(
        self,
        api_token,
        **kwargs
    ):
        """Create a channel  # noqa: E501

        ## Create a channel  Creates a new group channel.  > If you are creating a 1-on-1 direct messaging channel for a user, it is recommended that you turn on the `distinct` property. If the property is turned off, a user can create a new channel even if they have had the previous chat between them, and therefore can't see previously sent messages or data in the new channel. On the other hand, if the `distinct` property is turned on, every 1-on-1 conversation between the same two users occurs within the same channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-create-a-channel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_create_channel(api_token, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):

        Keyword Args:
            gc_create_channel_data (GcCreateChannelData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdGroupChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        return self.gc_create_channel_endpoint.call_with_http_info(**kwargs)

    def gc_decline_invitation(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Decline an invitation  # noqa: E501

        ## Decline an invitation  Declines an invitation for a user to not join a [private](#4-private-vs-public) group channel.  > __Note__: This action is effective only when the `auto_accept` property of an application is set to false. You can change the value of the property using the [update default channel invitation preference](https://sendbird.com/docs/chat/v3/platform-api/guides/application#2-update-default-channel-invitation-preference) action, or [update a user's channel invitation preference](https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-update-channel-invitation-preference) action.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-decline-an-invitation ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_decline_invitation(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            gc_decline_invitation_data (GcDeclineInvitationData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcDeleteChannelByUrl200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_decline_invitation_endpoint.call_with_http_info(**kwargs)

    def gc_delete_channel_by_url(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Delete a channel  # noqa: E501

        ## Delete a channel  Deletes a group channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-delete-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_delete_channel_by_url(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcDeleteChannelByUrl200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_delete_channel_by_url_endpoint.call_with_http_info(**kwargs)

    def gc_hide_or_archive_channel(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Hide or archive a channel  # noqa: E501

        ## Hide or archive a channel  Hides or archives a channel from the channel list of either a specific user or entire channel members. Normally, a hidden channel comes back and shows up in the channel list when a member in the channel sends a new message. This automatically-triggered behavior is intended for users who want to temporarily remove a channel from their list because [leaving the channel](#2-leave-the-channel) would delete all the past messages and stored data.  You can also leave out a channel from the list and archive the channel. The channel doesn't appear even when receiving a new message from other member.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-hide-or-archive-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_hide_or_archive_channel(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            gc_hide_or_archive_channel_data (GcHideOrArchiveChannelData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcDeleteChannelByUrl200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_hide_or_archive_channel_endpoint.call_with_http_info(**kwargs)

    def gc_invite_as_members(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Invite as members  # noqa: E501

        ## Invite as members  Invites one or more users as members into the group channel.  > __Note__: By default, users in your application automatically join a [private](#4-private-vs-public) group channel promptly from an invitation without having to accept it. If you want to give them the option to decide whether to accept or decline an invitation, you should set the value of channel invitation preference to false through the [update default channel invitation preference](https://sendbird.com/docs/chat/v3/platform-api/guides/application#2-update-default-channel-invitation-preference) action. Or using the [update a user's channel invitation preference](https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-update-channel-invitation-preference) action, you can also allow the option individually by user.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-invite-as-members ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_invite_as_members(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            gc_invite_as_members_data (GcInviteAsMembersData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdGroupChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_invite_as_members_endpoint.call_with_http_info(**kwargs)

    def gc_join_channel(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Join a channel  # noqa: E501

        ## Join a channel  Allows a user to join a [public](#4-private-vs-public) group channel. Since a user is allowed to join up to 2,000 group channels, a user who already belongs to a maximum number of group channels can't join a new channel.  > __Note__: This action is only permitted for public group channels where the `is_public` property is true.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-join-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_join_channel(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            gc_join_channel_data (GcJoinChannelData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_join_channel_endpoint.call_with_http_info(**kwargs)

    def gc_leave_channel(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Leave a channel  # noqa: E501

        ## Leave a channel  Makes one or more members leave a group channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-leave-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_leave_channel(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            gc_leave_channel_data (GcLeaveChannelData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcDeleteChannelByUrl200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_leave_channel_endpoint.call_with_http_info(**kwargs)

    def gc_list_channels(
        self,
        api_token,
        **kwargs
    ):
        """List channels  # noqa: E501

        ## List channels  Retrieves a list of group channels in the application.  > __Note__: If you want to get a list of a specific user's group channels, use the [list my group channels](https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-list-my-group-channels) action instead.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-list-channels ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_list_channels(api_token, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):

        Keyword Args:
            token (str): [optional]
            limit (int): [optional]
            distinct_mode (str): [optional]
            public_mode (str): [optional]
            super_mode (str): [optional]
            created_after (int): [optional]
            created_before (int): [optional]
            show_empty (bool): [optional]
            show_member (bool): [optional]
            show_delivery_receipt (bool): [optional]
            show_read_receipt (bool): [optional]
            show_metadata (bool): [optional]
            show_frozen (bool): [optional]
            order (str): [optional]
            metadata_order_key (str): [optional]
            custom_types (str): [optional]
            custom_type_startswith (str): [optional]
            channel_urls (str): [optional]
            name (str): [optional]
            name_contains (str): [optional]
            name_startswith (str): [optional]
            members_exactly_in (str): [optional]
            members_include_in (str): [optional]
            query_type (str): [optional]
            members_nickname (str): [optional]
            members_nickname_contains (str): [optional]
            metadata_key (str): [optional]
            metadata_values (str): [optional]
            metadata_value_startswith (str): [optional]
            metacounter_key (str): [optional]
            metacounter_values (str): [optional]
            metacounter_value_gt (str): [optional]
            metacounter_value_gte (str): [optional]
            metacounter_value_lt (str): [optional]
            metacounter_value_lte (str): [optional]
            include_sorted_metaarray_in_last_message (bool): [optional]
            custom_type (str): [optional]
            read_receipt (bool): [optional]
            member (bool): [optional]
            is_distinct (bool): [optional]
            members_in (str): [optional]
            user_id (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GcListChannelsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        return self.gc_list_channels_endpoint.call_with_http_info(**kwargs)

    def gc_list_members(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """List members  # noqa: E501

        ## List members  Retrieves a list of members of a group channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-list-members ----------------------------   `channel_url`      Type: string      Description: Specifies the URL of the channel to retrieve a list of members of.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_list_members(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            token (str): [optional]
            limit (int): [optional]
            show_delivery_receipt (bool): [optional]
            show_read_receipt (bool): [optional]
            order (str): [optional]
            operator_filter (str): [optional]
            member_state_filter (str): [optional]
            muted_member_filter (str): [optional]
            nickname_startswith (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GcListMembersResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_list_members_endpoint.call_with_http_info(**kwargs)

    def gc_list_operators(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """List operators  # noqa: E501

        ## List operators  Retrieves a list of operators of a group channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-list-operators ----------------------------   `channel_url`      Type: string      Description: Specifies the URL of the channel to retrieve a list of operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_list_operators(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            token (str): [optional]
            limit (int): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GcListOperatorsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_list_operators_endpoint.call_with_http_info(**kwargs)

    def gc_register_operators(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Register operators  # noqa: E501

        ## Register operators  Registers one or more operators to a group channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-register-operators ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_register_operators(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            gc_register_operators_data (GcRegisterOperatorsData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GcRegisterOperatorsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_register_operators_endpoint.call_with_http_info(**kwargs)

    def gc_reset_chat_history(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Reset chat history  # noqa: E501

        ## Reset chat history  Resets the properties related to a user's chat history in a group channel, then clears the existing messages in the channel on the user's side only. A user can no longer see the messages in a group channel once this action is called, but those messages are not deleted from the database of the Sendbird system. All other members in the channel can retrieve and see the messages.  This action simply clears the messages for the user by updating the `last_message` and `read_receipt` properties of the [channel](#2-types-of-a-channel-3-resource-representation) resource in addition to other internally managed data such as the number of the user's unread message.  Using the `reset_all` property, you can also reset the properties related to all users' chat history in a group channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-reset-chat-history ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_reset_chat_history(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            gc_reset_chat_history_data (GcResetChatHistoryData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GcResetChatHistoryResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_reset_chat_history_endpoint.call_with_http_info(**kwargs)

    def gc_unhide_or_unarchive_channel(
        self,
        api_token,
        channel_url,
        user_id,
        **kwargs
    ):
        """Unhide or unarchive a channel  # noqa: E501

        ## Unhide or unarchive a channel  Makes a hidden or archived channel reappear in the channel list of either a specific user or entire channel members.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-unhide-or-unarchive-a-channel ----------------------------   `channel_url`      Type: string      Description: Specifies the URL of the channel to unhide or unarchive.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_unhide_or_unarchive_channel(api_token, channel_url, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):
            user_id (str):

        Keyword Args:
            should_unhide_all (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcDeleteChannelByUrl200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        kwargs['user_id'] = \
            user_id
        return self.gc_unhide_or_unarchive_channel_endpoint.call_with_http_info(**kwargs)

    def gc_update_channel_by_url(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Update a channel  # noqa: E501

        ## Update a channel  Updates information on a group channel.  > __Note__: You can't change the members of the channel here. To do so, see [invite as members](#2-invite-as-members) action below.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-update-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_update_channel_by_url(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            gc_update_channel_by_url_data (GcUpdateChannelByUrlData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdGroupChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_update_channel_by_url_endpoint.call_with_http_info(**kwargs)

    def gc_view_channel_by_url(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """View a channel  # noqa: E501

        ## View a channel  Retrieves information on a group channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#2-view-a-channel ----------------------------   `channel_url`      Type: string      Description: Specifies the URL of the channel to retrieve.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.gc_view_channel_by_url(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            show_delivery_receipt (bool): [optional]
            show_read_receipt (bool): [optional]
            show_member (bool): [optional]
            read_receipt (bool): [optional]
            member (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdGroupChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.gc_view_channel_by_url_endpoint.call_with_http_info(**kwargs)

