"""
    Sendbird Platform SDK

    Sendbird Platform API SDK  https://sendbird.com/docs/chat/v3/platform-api/getting-started/prepare-to-use-api  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@sendbird.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from sendbird_platform_sdk.api_client import ApiClient, Endpoint as _Endpoint
from sendbird_platform_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from sendbird_platform_sdk.model.create_channel_metacounter_data import CreateChannelMetacounterData
from sendbird_platform_sdk.model.create_channel_metadata_data import CreateChannelMetadataData
from sendbird_platform_sdk.model.create_channel_metadata_response import CreateChannelMetadataResponse
from sendbird_platform_sdk.model.create_user_metadata_data import CreateUserMetadataData
from sendbird_platform_sdk.model.create_user_metadata_response import CreateUserMetadataResponse
from sendbird_platform_sdk.model.update_channel_metacounter_by_key_response import UpdateChannelMetacounterByKeyResponse
from sendbird_platform_sdk.model.update_channel_metacounter_data import UpdateChannelMetacounterData
from sendbird_platform_sdk.model.update_channel_metadata_by_key_response import UpdateChannelMetadataByKeyResponse
from sendbird_platform_sdk.model.update_channel_metadata_data import UpdateChannelMetadataData
from sendbird_platform_sdk.model.update_channel_metadata_response import UpdateChannelMetadataResponse
from sendbird_platform_sdk.model.update_user_metadata_by_key_response import UpdateUserMetadataByKeyResponse
from sendbird_platform_sdk.model.update_user_metadata_data import UpdateUserMetadataData
from sendbird_platform_sdk.model.update_user_metadata_response import UpdateUserMetadataResponse
from sendbird_platform_sdk.model.view_channel_metacounter_response import ViewChannelMetacounterResponse
from sendbird_platform_sdk.model.view_channel_metadata_by_key_response import ViewChannelMetadataByKeyResponse
from sendbird_platform_sdk.model.view_channel_metadata_response import ViewChannelMetadataResponse
from sendbird_platform_sdk.model.view_user_metadata_by_key_response import ViewUserMetadataByKeyResponse
from sendbird_platform_sdk.model.view_user_metadata_response import ViewUserMetadataResponse


class MetadataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_channel_metacounter_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metacounter',
                'operation_id': 'create_channel_metacounter',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'create_channel_metacounter_data',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'create_channel_metacounter_data':
                        (CreateChannelMetacounterData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'create_channel_metacounter_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_channel_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (CreateChannelMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metadata',
                'operation_id': 'create_channel_metadata',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'create_channel_metadata_data',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'create_channel_metadata_data':
                        (CreateChannelMetadataData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'create_channel_metadata_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_user_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (CreateUserMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/metadata',
                'operation_id': 'create_user_metadata',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'create_user_metadata_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'create_user_metadata_data':
                        (CreateUserMetadataData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'create_user_metadata_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_channel_metacounter_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metacounter',
                'operation_id': 'delete_channel_metacounter',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_channel_metacounter_by_key_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metacounter/{key}',
                'operation_id': 'delete_channel_metacounter_by_key',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_channel_metadata_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metadata',
                'operation_id': 'delete_channel_metadata',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'key': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_channel_metadata_by_key_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metadata/{key}',
                'operation_id': 'delete_channel_metadata_by_key',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_user_metadata_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/metadata',
                'operation_id': 'delete_user_metadata',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'key',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'key': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_user_metadata_by_key_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/metadata/{key}',
                'operation_id': 'delete_user_metadata_by_key',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'key',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_channel_metacounter_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metacounter',
                'operation_id': 'update_channel_metacounter',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'update_channel_metacounter_data',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'update_channel_metacounter_data':
                        (UpdateChannelMetacounterData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'update_channel_metacounter_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_channel_metacounter_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateChannelMetacounterByKeyResponse,),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metacounter/{key}',
                'operation_id': 'update_channel_metacounter_by_key',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                    'body',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'key':
                        (str,),
                    'body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'key': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_channel_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateChannelMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metadata',
                'operation_id': 'update_channel_metadata',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'update_channel_metadata_data',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'update_channel_metadata_data':
                        (UpdateChannelMetadataData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'update_channel_metadata_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_channel_metadata_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateChannelMetadataByKeyResponse,),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metadata/{key}',
                'operation_id': 'update_channel_metadata_by_key',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                    'body',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'key':
                        (str,),
                    'body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'key': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_user_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateUserMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/metadata',
                'operation_id': 'update_user_metadata',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'update_user_metadata_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'update_user_metadata_data':
                        (UpdateUserMetadataData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'update_user_metadata_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_user_metadata_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateUserMetadataByKeyResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/metadata/{key}',
                'operation_id': 'update_user_metadata_by_key',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'key',
                    'body',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'key':
                        (str,),
                    'body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'key': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.view_channel_metacounter_endpoint = _Endpoint(
            settings={
                'response_type': (ViewChannelMetacounterResponse,),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metacounter',
                'operation_id': 'view_channel_metacounter',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                    'keys',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'key':
                        (str,),
                    'keys':
                        ([str],),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                    'key': 'key',
                    'keys': 'keys',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'key': 'query',
                    'keys': 'query',
                },
                'collection_format_map': {
                    'keys': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_channel_metacounter_by_key_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metacounter/{key}',
                'operation_id': 'view_channel_metacounter_by_key',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_channel_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (ViewChannelMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metadata',
                'operation_id': 'view_channel_metadata',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                    'keys',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'key':
                        (str,),
                    'keys':
                        ([str],),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                    'key': 'key',
                    'keys': 'keys',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'key': 'query',
                    'keys': 'query',
                },
                'collection_format_map': {
                    'keys': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_channel_metadata_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (ViewChannelMetadataByKeyResponse,),
                'auth': [],
                'endpoint_path': '/v3/{channel_type}/{channel_url}/metadata/{key}',
                'operation_id': 'view_channel_metadata_by_key',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'required': [
                    'api_token',
                    'channel_type',
                    'channel_url',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_type':
                        (str,),
                    'channel_url':
                        (str,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_type': 'channel_type',
                    'channel_url': 'channel_url',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_type': 'path',
                    'channel_url': 'path',
                    'key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_user_metadata_endpoint = _Endpoint(
            settings={
                'response_type': (ViewUserMetadataResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/metadata',
                'operation_id': 'view_user_metadata',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'key',
                    'keys',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'key':
                        (str,),
                    'keys':
                        ([str],),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'key': 'key',
                    'keys': 'keys',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'key': 'query',
                    'keys': 'query',
                },
                'collection_format_map': {
                    'keys': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_user_metadata_by_key_endpoint = _Endpoint(
            settings={
                'response_type': (ViewUserMetadataByKeyResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/metadata/{key}',
                'operation_id': 'view_user_metadata_by_key',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'key',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'key',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'key':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'key': 'key',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'key': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def create_channel_metacounter(
        self,
        api_token,
        channel_type,
        channel_url,
        **kwargs
    ):
        """Create a channel metacounter  # noqa: E501

        ## Create a channel metacounter  Creates a channel metacounter's items to store in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-create-a-channel-metacounter ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_channel_metacounter(api_token, channel_type, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):

        Keyword Args:
            create_channel_metacounter_data (CreateChannelMetacounterData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        return self.create_channel_metacounter_endpoint.call_with_http_info(**kwargs)

    def create_channel_metadata(
        self,
        api_token,
        channel_type,
        channel_url,
        **kwargs
    ):
        """Create a channel metadata  # noqa: E501

        ## Create a channel metadata  Creates a channel metadata's items to store in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-create-a-channel-metadata ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_channel_metadata(api_token, channel_type, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):

        Keyword Args:
            create_channel_metadata_data (CreateChannelMetadataData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateChannelMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        return self.create_channel_metadata_endpoint.call_with_http_info(**kwargs)

    def create_user_metadata(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Create a user metadata  # noqa: E501

        ## Create a user metadata  Creates a user metadata's items to store in a user.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-create-a-user-metadata ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_metadata(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            create_user_metadata_data (CreateUserMetadataData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateUserMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.create_user_metadata_endpoint.call_with_http_info(**kwargs)

    def delete_channel_metacounter(
        self,
        api_token,
        channel_type,
        channel_url,
        **kwargs
    ):
        """Delete a channel metacounter - When deleting all items of a channel metacounter  # noqa: E501

        ## Delete a channel metacounter  Deletes a channel metacounter's item that is stored in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-delete-a-channel-metacounter ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the channel which has the metacounter to delete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_channel_metacounter(api_token, channel_type, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        return self.delete_channel_metacounter_endpoint.call_with_http_info(**kwargs)

    def delete_channel_metacounter_by_key(
        self,
        api_token,
        channel_type,
        channel_url,
        key,
        **kwargs
    ):
        """Delete a channel metacounter - When deleting a specific item of a channel metacounter by its key  # noqa: E501

        ## Delete a channel metacounter  Deletes a channel metacounter's item that is stored in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-delete-a-channel-metacounter ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the channel which has the metacounter to delete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_channel_metacounter_by_key(api_token, channel_type, channel_url, key, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):
            key (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        kwargs['key'] = \
            key
        return self.delete_channel_metacounter_by_key_endpoint.call_with_http_info(**kwargs)

    def delete_channel_metadata(
        self,
        api_token,
        channel_type,
        channel_url,
        **kwargs
    ):
        """Delete a channel metadata - When deleting all items of a channel metadata  # noqa: E501

        ## Delete a channel metadata  Deletes a channel metadata's one or all items that are stored in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-delete-a-channel-metadata ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the channel which has the metadata to delete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_channel_metadata(api_token, channel_type, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):

        Keyword Args:
            key (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        return self.delete_channel_metadata_endpoint.call_with_http_info(**kwargs)

    def delete_channel_metadata_by_key(
        self,
        api_token,
        channel_type,
        channel_url,
        key,
        **kwargs
    ):
        """Delete a channel metadata - When deleting a specific item of a channel metadata by its key  # noqa: E501

        ## Delete a channel metadata  Deletes a channel metadata's one or all items that are stored in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-delete-a-channel-metadata ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the channel which has the metadata to delete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_channel_metadata_by_key(api_token, channel_type, channel_url, key, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):
            key (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        kwargs['key'] = \
            key
        return self.delete_channel_metadata_by_key_endpoint.call_with_http_info(**kwargs)

    def delete_user_metadata(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Delete a user metadata - When deleting all items of a user metadata  # noqa: E501

        ## Delete a user metadata  Deletes a user metadata's one or all items that are stored in a user.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-delete-a-user-metadata ----------------------------   `user_id`      Type: string      Description: Specifies the ID of the user who has the metadata to delete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_metadata(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            key (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.delete_user_metadata_endpoint.call_with_http_info(**kwargs)

    def delete_user_metadata_by_key(
        self,
        api_token,
        user_id,
        key,
        **kwargs
    ):
        """Delete a user metadata - When deleting a specific item of a user metadata by its key  # noqa: E501

        ## Delete a user metadata  Deletes a user metadata's one or all items that are stored in a user.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-delete-a-user-metadata ----------------------------   `user_id`      Type: string      Description: Specifies the ID of the user who has the metadata to delete.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_metadata_by_key(api_token, user_id, key, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            key (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['key'] = \
            key
        return self.delete_user_metadata_by_key_endpoint.call_with_http_info(**kwargs)

    def update_channel_metacounter(
        self,
        api_token,
        channel_type,
        channel_url,
        **kwargs
    ):
        """Update a channel metacounter - When updating existing items of a channel metacounter by their keys or adding new items to the metacounter  # noqa: E501

        ## Update a channel metacounter  Updates existing items of a channel metacounter by their keys, or adds new items to the metacounter.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-update-a-channel-metacounter ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the target channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_channel_metacounter(api_token, channel_type, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):

        Keyword Args:
            update_channel_metacounter_data (UpdateChannelMetacounterData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        return self.update_channel_metacounter_endpoint.call_with_http_info(**kwargs)

    def update_channel_metacounter_by_key(
        self,
        api_token,
        channel_type,
        channel_url,
        key,
        **kwargs
    ):
        """Update a channel metacounter - When updating a specific item of a channel metacounter by its key  # noqa: E501

        ## Update a channel metacounter  Updates existing items of a channel metacounter by their keys, or adds new items to the metacounter.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-update-a-channel-metacounter ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the target channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_channel_metacounter_by_key(api_token, channel_type, channel_url, key, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):
            key (str):

        Keyword Args:
            body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateChannelMetacounterByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        kwargs['key'] = \
            key
        return self.update_channel_metacounter_by_key_endpoint.call_with_http_info(**kwargs)

    def update_channel_metadata(
        self,
        api_token,
        channel_type,
        channel_url,
        **kwargs
    ):
        """Update a channel metadata - When updating existing items of a channel metadata by their keys or adding new items to the metadata  # noqa: E501

        ## Update a channel metadata  Updates existing items of a channel metadata by their keys, or adds new items to the metadata.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-update-a-channel-metadata ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the target channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_channel_metadata(api_token, channel_type, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):

        Keyword Args:
            update_channel_metadata_data (UpdateChannelMetadataData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateChannelMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        return self.update_channel_metadata_endpoint.call_with_http_info(**kwargs)

    def update_channel_metadata_by_key(
        self,
        api_token,
        channel_type,
        channel_url,
        key,
        **kwargs
    ):
        """Update a channel metadata - When updating a specific item of a channel metadata by its key  # noqa: E501

        ## Update a channel metadata  Updates existing items of a channel metadata by their keys, or adds new items to the metadata.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-update-a-channel-metadata ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the target channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_channel_metadata_by_key(api_token, channel_type, channel_url, key, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):
            key (str):

        Keyword Args:
            body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateChannelMetadataByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        kwargs['key'] = \
            key
        return self.update_channel_metadata_by_key_endpoint.call_with_http_info(**kwargs)

    def update_user_metadata(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Update a user metadata - When updating existing items of a user metadata by their keys or adding new items to the metadata  # noqa: E501

        ## Update a user metadata  Updates existing items of a user metadata by their keys, or adds new items to the metadata.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-update-a-user-metadata ----------------------------   `user_id`      Type: string      Description: Specifies the ID of the user to update the metadata in.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_metadata(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            update_user_metadata_data (UpdateUserMetadataData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateUserMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.update_user_metadata_endpoint.call_with_http_info(**kwargs)

    def update_user_metadata_by_key(
        self,
        api_token,
        user_id,
        key,
        **kwargs
    ):
        """Update a user metadata - When updating a specific item of a user metadata by its key  # noqa: E501

        ## Update a user metadata  Updates existing items of a user metadata by their keys, or adds new items to the metadata.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-update-a-user-metadata ----------------------------   `user_id`      Type: string      Description: Specifies the ID of the user to update the metadata in.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_metadata_by_key(api_token, user_id, key, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            key (str):

        Keyword Args:
            body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateUserMetadataByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['key'] = \
            key
        return self.update_user_metadata_by_key_endpoint.call_with_http_info(**kwargs)

    def view_channel_metacounter(
        self,
        api_token,
        channel_type,
        channel_url,
        **kwargs
    ):
        """View a channel metacounter - When retrieving all items of a channel metacounter  # noqa: E501

        ## View a channel metacounter  Retrieves channel metacounter's one or more items that are stored in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-view-a-channel-metacounter ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the target channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_channel_metacounter(api_token, channel_type, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):

        Keyword Args:
            key (str): [optional]
            keys ([str]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewChannelMetacounterResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        return self.view_channel_metacounter_endpoint.call_with_http_info(**kwargs)

    def view_channel_metacounter_by_key(
        self,
        api_token,
        channel_type,
        channel_url,
        key,
        **kwargs
    ):
        """View a channel metacounter - When retrieving a specific item of a channel metacounter by its key  # noqa: E501

        ## View a channel metacounter  Retrieves channel metacounter's one or more items that are stored in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-view-a-channel-metacounter ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the target channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_channel_metacounter_by_key(api_token, channel_type, channel_url, key, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):
            key (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        kwargs['key'] = \
            key
        return self.view_channel_metacounter_by_key_endpoint.call_with_http_info(**kwargs)

    def view_channel_metadata(
        self,
        api_token,
        channel_type,
        channel_url,
        **kwargs
    ):
        """View a channel metadata - When retrieving all items of a channel metadata  # noqa: E501

        ## View a channel metadata  Retrieves a channel metadata's one or more items that are stored in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-view-a-channel-metadata ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the target channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_channel_metadata(api_token, channel_type, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):

        Keyword Args:
            key (str): [optional]
            keys ([str]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewChannelMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        return self.view_channel_metadata_endpoint.call_with_http_info(**kwargs)

    def view_channel_metadata_by_key(
        self,
        api_token,
        channel_type,
        channel_url,
        key,
        **kwargs
    ):
        """View a channel metadata - When retrieving a specific item of a channel metadata by its key  # noqa: E501

        ## View a channel metadata  Retrieves a channel metadata's one or more items that are stored in a channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-view-a-channel-metadata ----------------------------   `channel_type`      Type: string      Description: Specifies the type of the channel. Either open_channels or group_channels.  `channel_url`      Type: string      Description: Specifies the URL of the target channel.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_channel_metadata_by_key(api_token, channel_type, channel_url, key, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_type (str):
            channel_url (str):
            key (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewChannelMetadataByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_type'] = \
            channel_type
        kwargs['channel_url'] = \
            channel_url
        kwargs['key'] = \
            key
        return self.view_channel_metadata_by_key_endpoint.call_with_http_info(**kwargs)

    def view_user_metadata(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """View a user metadata - When retrieving all items of a user metadata  # noqa: E501

        ## View a user metadata  Retrieves a user metadata's one or more items that are stored in a user.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-view-a-user-metadata ----------------------------   `user_id`      Type: string      Description: Specifies the ID of the user to retrieve the metadata in.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_user_metadata(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            key (str): [optional]
            keys ([str]): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewUserMetadataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.view_user_metadata_endpoint.call_with_http_info(**kwargs)

    def view_user_metadata_by_key(
        self,
        api_token,
        user_id,
        key,
        **kwargs
    ):
        """View a user metadata - When retrieving a specific item of a user metadata by its key  # noqa: E501

        ## View a user metadata  Retrieves a user metadata's one or more items that are stored in a user.  https://sendbird.com/docs/chat/v3/platform-api/guides/user-and-channel-metadata#2-view-a-user-metadata ----------------------------   `user_id`      Type: string      Description: Specifies the ID of the user to retrieve the metadata in.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_user_metadata_by_key(api_token, user_id, key, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            key (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewUserMetadataByKeyResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['key'] = \
            key
        return self.view_user_metadata_by_key_endpoint.call_with_http_info(**kwargs)

