"""
    Sendbird Platform SDK

    Sendbird Platform API SDK  https://sendbird.com/docs/chat/v3/platform-api/getting-started/prepare-to-use-api  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@sendbird.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from sendbird_platform_sdk.api_client import ApiClient, Endpoint as _Endpoint
from sendbird_platform_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from sendbird_platform_sdk.model.oc_create_channel_data import OcCreateChannelData
from sendbird_platform_sdk.model.oc_delete_channel_by_url200_response import OcDeleteChannelByUrl200Response
from sendbird_platform_sdk.model.oc_list_channels_response import OcListChannelsResponse
from sendbird_platform_sdk.model.oc_list_operators_response import OcListOperatorsResponse
from sendbird_platform_sdk.model.oc_list_participants_response import OcListParticipantsResponse
from sendbird_platform_sdk.model.oc_register_operators_data import OcRegisterOperatorsData
from sendbird_platform_sdk.model.oc_update_channel_by_url_data import OcUpdateChannelByUrlData
from sendbird_platform_sdk.model.send_bird_open_channel import SendBirdOpenChannel


class OpenChannelApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.oc_cancel_the_registration_of_operators_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/v3/open_channels/{channel_url}/operators',
                'operation_id': 'oc_cancel_the_registration_of_operators',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'operator_ids',
                    'delete_all',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                    'operator_ids',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'operator_ids':
                        ([str],),
                    'delete_all':
                        (bool,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                    'operator_ids': 'operator_ids',
                    'delete_all': 'delete_all',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'operator_ids': 'query',
                    'delete_all': 'query',
                },
                'collection_format_map': {
                    'operator_ids': 'multi',
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.oc_create_channel_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdOpenChannel,),
                'auth': [],
                'endpoint_path': '/v3/open_channels',
                'operation_id': 'oc_create_channel',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'oc_create_channel_data',
                ],
                'required': [
                    'api_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'oc_create_channel_data':
                        (OcCreateChannelData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                },
                'location_map': {
                    'api_token': 'header',
                    'oc_create_channel_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.oc_delete_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (OcDeleteChannelByUrl200Response,),
                'auth': [],
                'endpoint_path': '/v3/open_channels/{channel_url}',
                'operation_id': 'oc_delete_channel_by_url',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.oc_list_channels_endpoint = _Endpoint(
            settings={
                'response_type': (OcListChannelsResponse,),
                'auth': [],
                'endpoint_path': '/v3/open_channels',
                'operation_id': 'oc_list_channels',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'token',
                    'limit',
                    'custom_types',
                    'name_contains',
                    'url_contains',
                    'show_frozen',
                    'show_metadata',
                    'custom_type',
                ],
                'required': [
                    'api_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'token':
                        (str,),
                    'limit':
                        (int,),
                    'custom_types':
                        (str,),
                    'name_contains':
                        (str,),
                    'url_contains':
                        (str,),
                    'show_frozen':
                        (bool,),
                    'show_metadata':
                        (bool,),
                    'custom_type':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'token': 'token',
                    'limit': 'limit',
                    'custom_types': 'custom_types',
                    'name_contains': 'name_contains',
                    'url_contains': 'url_contains',
                    'show_frozen': 'show_frozen',
                    'show_metadata': 'show_metadata',
                    'custom_type': 'custom_type',
                },
                'location_map': {
                    'api_token': 'header',
                    'token': 'query',
                    'limit': 'query',
                    'custom_types': 'query',
                    'name_contains': 'query',
                    'url_contains': 'query',
                    'show_frozen': 'query',
                    'show_metadata': 'query',
                    'custom_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.oc_list_operators_endpoint = _Endpoint(
            settings={
                'response_type': (OcListOperatorsResponse,),
                'auth': [],
                'endpoint_path': '/v3/open_channels/{channel_url}/operators',
                'operation_id': 'oc_list_operators',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'token',
                    'limit',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'token':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                    'token': 'token',
                    'limit': 'limit',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'token': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.oc_list_participants_endpoint = _Endpoint(
            settings={
                'response_type': (OcListParticipantsResponse,),
                'auth': [],
                'endpoint_path': '/v3/open_channels/{channel_url}/participants',
                'operation_id': 'oc_list_participants',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'token',
                    'limit',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'token':
                        (str,),
                    'limit':
                        (int,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                    'token': 'token',
                    'limit': 'limit',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'token': 'query',
                    'limit': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.oc_register_operators_endpoint = _Endpoint(
            settings={
                'response_type': (OcDeleteChannelByUrl200Response,),
                'auth': [],
                'endpoint_path': '/v3/open_channels/{channel_url}/operators',
                'operation_id': 'oc_register_operators',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'oc_register_operators_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'oc_register_operators_data':
                        (OcRegisterOperatorsData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'oc_register_operators_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.oc_update_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdOpenChannel,),
                'auth': [],
                'endpoint_path': '/v3/open_channels/{channel_url}',
                'operation_id': 'oc_update_channel_by_url',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                    'oc_update_channel_by_url_data',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                    'oc_update_channel_by_url_data':
                        (OcUpdateChannelByUrlData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                    'oc_update_channel_by_url_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.oc_view_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdOpenChannel,),
                'auth': [],
                'endpoint_path': '/v3/open_channels/{channel_url}',
                'operation_id': 'oc_view_channel_by_url',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'channel_url',
                ],
                'required': [
                    'api_token',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'channel_url':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'channel_url': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def oc_cancel_the_registration_of_operators(
        self,
        api_token,
        channel_url,
        operator_ids,
        **kwargs
    ):
        """Cancel the registration of operators  # noqa: E501

        ## Cancel the registration of operators  Cancels the registration of operators from an open channel but leave them as participants.  https://sendbird.com/docs/chat/v3/platform-api/guides/open-channel#2-cancel-the-registration-of-operators ----------------------------   `channel_url`      Type: string      Description: Specifies the URL of the channel to cancel the registration of operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.oc_cancel_the_registration_of_operators(api_token, channel_url, operator_ids, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):
            operator_ids ([str]):

        Keyword Args:
            delete_all (bool): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        kwargs['operator_ids'] = \
            operator_ids
        return self.oc_cancel_the_registration_of_operators_endpoint.call_with_http_info(**kwargs)

    def oc_create_channel(
        self,
        api_token,
        **kwargs
    ):
        """Create a channel  # noqa: E501

        ## Create a channel  Creates an open channel.  >__Note__: Classic open channels created before the deprecation date of March 2021 will maintain their original form and functions. However, new applications created after December 15, 2020, will be able to create dynamic partitioning open channels only.  https://sendbird.com/docs/chat/v3/platform-api/guides/open-channel#2-create-a-channel  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.oc_create_channel(api_token, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):

        Keyword Args:
            oc_create_channel_data (OcCreateChannelData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdOpenChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        return self.oc_create_channel_endpoint.call_with_http_info(**kwargs)

    def oc_delete_channel_by_url(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Delete a channel  # noqa: E501

        ## Delete a channel  Deletes an open channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/open-channel#2-delete-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.oc_delete_channel_by_url(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcDeleteChannelByUrl200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.oc_delete_channel_by_url_endpoint.call_with_http_info(**kwargs)

    def oc_list_channels(
        self,
        api_token,
        **kwargs
    ):
        """List channels  # noqa: E501

        ## List channels  Retrieves a list of open channels. You can query the list using various parameters.  https://sendbird.com/docs/chat/v3/platform-api/guides/open-channel#2-list-channels ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.oc_list_channels(api_token, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):

        Keyword Args:
            token (str): [optional]
            limit (int): [optional]
            custom_types (str): [optional]
            name_contains (str): [optional]
            url_contains (str): [optional]
            show_frozen (bool): [optional]
            show_metadata (bool): [optional]
            custom_type (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcListChannelsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        return self.oc_list_channels_endpoint.call_with_http_info(**kwargs)

    def oc_list_operators(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """List operators  # noqa: E501

        ## List operators  Retrieves a list of operators of an open channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/open-channel#2-list-operators ----------------------------   `channel_url`      Type: string      Description: Specifies the URL of the channel to retrieve a list of operators.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.oc_list_operators(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            token (str): [optional]
            limit (int): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcListOperatorsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.oc_list_operators_endpoint.call_with_http_info(**kwargs)

    def oc_list_participants(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """List participants  # noqa: E501

        ## List participants  Retrieves a list of the participants of an open channel. A participant refers to a user who has entered the open channel and is currently online.  https://sendbird.com/docs/chat/v3/platform-api/guides/open-channel#2-list-participants ----------------------------   `channel_url`      Type: string      Description: Specifies the URL of the channel to retrieve a list of participants in.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.oc_list_participants(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            token (str): [optional]
            limit (int): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcListParticipantsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.oc_list_participants_endpoint.call_with_http_info(**kwargs)

    def oc_register_operators(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Register operators  # noqa: E501

        ## Register operators  Registers one or more operators to an open channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/open-channel#2-register-operators ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.oc_register_operators(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            oc_register_operators_data (OcRegisterOperatorsData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            OcDeleteChannelByUrl200Response
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.oc_register_operators_endpoint.call_with_http_info(**kwargs)

    def oc_update_channel_by_url(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """Update a channel  # noqa: E501

        ## Update a channel  Updates information on an open channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/open-channel#2-update-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.oc_update_channel_by_url(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            oc_update_channel_by_url_data (OcUpdateChannelByUrlData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdOpenChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.oc_update_channel_by_url_endpoint.call_with_http_info(**kwargs)

    def oc_view_channel_by_url(
        self,
        api_token,
        channel_url,
        **kwargs
    ):
        """View a channel  # noqa: E501

        ## View a channel  Retrieves information on a specific open channel.  https://sendbird.com/docs/chat/v3/platform-api/guides/open-channel#2-view-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.oc_view_channel_by_url(api_token, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            channel_url (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdOpenChannel
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['channel_url'] = \
            channel_url
        return self.oc_view_channel_by_url_endpoint.call_with_http_info(**kwargs)

