"""
    Sendbird Platform SDK

    Sendbird Platform API SDK  https://sendbird.com/docs/chat/v3/platform-api/getting-started/prepare-to-use-api  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@sendbird.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from sendbird_platform_sdk.api_client import ApiClient, Endpoint as _Endpoint
from sendbird_platform_sdk.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from sendbird_platform_sdk.model.add_registration_or_device_token_data import AddRegistrationOrDeviceTokenData
from sendbird_platform_sdk.model.add_registration_or_device_token_response import AddRegistrationOrDeviceTokenResponse
from sendbird_platform_sdk.model.choose_push_notification_content_template_response import ChoosePushNotificationContentTemplateResponse
from sendbird_platform_sdk.model.create_user_data import CreateUserData
from sendbird_platform_sdk.model.create_user_token_data import CreateUserTokenData
from sendbird_platform_sdk.model.create_user_token_response import CreateUserTokenResponse
from sendbird_platform_sdk.model.leave_my_group_channels_data import LeaveMyGroupChannelsData
from sendbird_platform_sdk.model.list_my_group_channels_response import ListMyGroupChannelsResponse
from sendbird_platform_sdk.model.list_registration_or_device_tokens_response import ListRegistrationOrDeviceTokensResponse
from sendbird_platform_sdk.model.list_users_response import ListUsersResponse
from sendbird_platform_sdk.model.mark_all_messages_as_read_data import MarkAllMessagesAsReadData
from sendbird_platform_sdk.model.register_as_operator_to_channels_with_custom_channel_types_data import RegisterAsOperatorToChannelsWithCustomChannelTypesData
from sendbird_platform_sdk.model.remove_registration_or_device_token_by_token_response import RemoveRegistrationOrDeviceTokenByTokenResponse
from sendbird_platform_sdk.model.remove_registration_or_device_token_from_owner_by_token_response import RemoveRegistrationOrDeviceTokenFromOwnerByTokenResponse
from sendbird_platform_sdk.model.remove_registration_or_device_token_response import RemoveRegistrationOrDeviceTokenResponse
from sendbird_platform_sdk.model.reset_push_preferences_response import ResetPushPreferencesResponse
from sendbird_platform_sdk.model.send_bird_user import SendBirdUser
from sendbird_platform_sdk.model.update_channel_invitation_preference_data import UpdateChannelInvitationPreferenceData
from sendbird_platform_sdk.model.update_channel_invitation_preference_response import UpdateChannelInvitationPreferenceResponse
from sendbird_platform_sdk.model.update_count_preference_of_channel_by_url_data import UpdateCountPreferenceOfChannelByUrlData
from sendbird_platform_sdk.model.update_count_preference_of_channel_by_url_response import UpdateCountPreferenceOfChannelByUrlResponse
from sendbird_platform_sdk.model.update_push_preferences_data import UpdatePushPreferencesData
from sendbird_platform_sdk.model.update_push_preferences_for_channel_by_url_data import UpdatePushPreferencesForChannelByUrlData
from sendbird_platform_sdk.model.update_push_preferences_for_channel_by_url_response import UpdatePushPreferencesForChannelByUrlResponse
from sendbird_platform_sdk.model.update_push_preferences_response import UpdatePushPreferencesResponse
from sendbird_platform_sdk.model.update_user_by_id_data import UpdateUserByIdData
from sendbird_platform_sdk.model.view_channel_invitation_preference_response import ViewChannelInvitationPreferenceResponse
from sendbird_platform_sdk.model.view_count_preference_of_channel_by_url_response import ViewCountPreferenceOfChannelByUrlResponse
from sendbird_platform_sdk.model.view_number_of_channels_by_join_status_response import ViewNumberOfChannelsByJoinStatusResponse
from sendbird_platform_sdk.model.view_number_of_channels_with_unread_messages_response import ViewNumberOfChannelsWithUnreadMessagesResponse
from sendbird_platform_sdk.model.view_number_of_unread_items_response import ViewNumberOfUnreadItemsResponse
from sendbird_platform_sdk.model.view_number_of_unread_messages_response import ViewNumberOfUnreadMessagesResponse
from sendbird_platform_sdk.model.view_push_preferences_for_channel_by_url_response import ViewPushPreferencesForChannelByUrlResponse
from sendbird_platform_sdk.model.view_push_preferences_response import ViewPushPreferencesResponse
from sendbird_platform_sdk.model.view_who_owns_registration_or_device_token_by_token_response import ViewWhoOwnsRegistrationOrDeviceTokenByTokenResponse


class UserApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.add_registration_or_device_token_endpoint = _Endpoint(
            settings={
                'response_type': (AddRegistrationOrDeviceTokenResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push/{token_type}',
                'operation_id': 'add_registration_or_device_token',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'token_type',
                    'add_registration_or_device_token_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'token_type',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'token_type':
                        (str,),
                    'add_registration_or_device_token_data':
                        (AddRegistrationOrDeviceTokenData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'token_type': 'token_type',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'token_type': 'path',
                    'add_registration_or_device_token_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.choose_push_notification_content_template_endpoint = _Endpoint(
            settings={
                'response_type': (ChoosePushNotificationContentTemplateResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push/template',
                'operation_id': 'choose_push_notification_content_template',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'body',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_user_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdUser,),
                'auth': [],
                'endpoint_path': '/v3/users',
                'operation_id': 'create_user',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'create_user_data',
                ],
                'required': [
                    'api_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'create_user_data':
                        (CreateUserData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                },
                'location_map': {
                    'api_token': 'header',
                    'create_user_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_user_token_endpoint = _Endpoint(
            settings={
                'response_type': (CreateUserTokenResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/token',
                'operation_id': 'create_user_token',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'create_user_token_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'create_user_token_data':
                        (CreateUserTokenData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'create_user_token_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_user_by_id_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}',
                'operation_id': 'delete_user_by_id',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.leave_my_group_channels_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/my_group_channels/leave',
                'operation_id': 'leave_my_group_channels',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'leave_my_group_channels_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'leave_my_group_channels_data':
                        (LeaveMyGroupChannelsData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'leave_my_group_channels_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.list_my_group_channels_endpoint = _Endpoint(
            settings={
                'response_type': (ListMyGroupChannelsResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/my_group_channels',
                'operation_id': 'list_my_group_channels',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'token',
                    'limit',
                    'distinct_mode',
                    'public_mode',
                    'super_mode',
                    'hidden_mode',
                    'member_state_filter',
                    'unread_filter',
                    'created_after',
                    'created_before',
                    'show_empty',
                    'show_frozen',
                    'show_member',
                    'show_delivery_receipt',
                    'show_read_receipt',
                    'order',
                    'metadata_order_key',
                    'custom_types',
                    'custom_type_startswith',
                    'channel_urls',
                    'name',
                    'name_contains',
                    'name_startswith',
                    'members_exactly_in',
                    'members_include_in',
                    'query_type',
                    'members_nickname',
                    'members_nickname_contains',
                    'search_query',
                    'search_fields',
                    'metadata_key',
                    'metadata_values',
                    'metadata_value_startswith',
                    'metacounter_key',
                    'metacounter_values',
                    'metacounter_value_gt',
                    'metacounter_value_gte',
                    'metacounter_value_lt',
                    'metacounter_value_lte',
                    'custom_type',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'token':
                        (str,),
                    'limit':
                        (int,),
                    'distinct_mode':
                        (str,),
                    'public_mode':
                        (str,),
                    'super_mode':
                        (str,),
                    'hidden_mode':
                        (str,),
                    'member_state_filter':
                        (str,),
                    'unread_filter':
                        (str,),
                    'created_after':
                        (int,),
                    'created_before':
                        (int,),
                    'show_empty':
                        (bool,),
                    'show_frozen':
                        (bool,),
                    'show_member':
                        (bool,),
                    'show_delivery_receipt':
                        (bool,),
                    'show_read_receipt':
                        (bool,),
                    'order':
                        (str,),
                    'metadata_order_key':
                        (str,),
                    'custom_types':
                        (str,),
                    'custom_type_startswith':
                        (str,),
                    'channel_urls':
                        (str,),
                    'name':
                        (str,),
                    'name_contains':
                        (str,),
                    'name_startswith':
                        (str,),
                    'members_exactly_in':
                        (str,),
                    'members_include_in':
                        (str,),
                    'query_type':
                        (str,),
                    'members_nickname':
                        (str,),
                    'members_nickname_contains':
                        (str,),
                    'search_query':
                        (str,),
                    'search_fields':
                        (str,),
                    'metadata_key':
                        (str,),
                    'metadata_values':
                        (str,),
                    'metadata_value_startswith':
                        (str,),
                    'metacounter_key':
                        (str,),
                    'metacounter_values':
                        (str,),
                    'metacounter_value_gt':
                        (str,),
                    'metacounter_value_gte':
                        (str,),
                    'metacounter_value_lt':
                        (str,),
                    'metacounter_value_lte':
                        (str,),
                    'custom_type':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'token': 'token',
                    'limit': 'limit',
                    'distinct_mode': 'distinct_mode',
                    'public_mode': 'public_mode',
                    'super_mode': 'super_mode',
                    'hidden_mode': 'hidden_mode',
                    'member_state_filter': 'member_state_filter',
                    'unread_filter': 'unread_filter',
                    'created_after': 'created_after',
                    'created_before': 'created_before',
                    'show_empty': 'show_empty',
                    'show_frozen': 'show_frozen',
                    'show_member': 'show_member',
                    'show_delivery_receipt': 'show_delivery_receipt',
                    'show_read_receipt': 'show_read_receipt',
                    'order': 'order',
                    'metadata_order_key': 'metadata_order_key',
                    'custom_types': 'custom_types',
                    'custom_type_startswith': 'custom_type_startswith',
                    'channel_urls': 'channel_urls',
                    'name': 'name',
                    'name_contains': 'name_contains',
                    'name_startswith': 'name_startswith',
                    'members_exactly_in': 'members_exactly_in',
                    'members_include_in': 'members_include_in',
                    'query_type': 'query_type',
                    'members_nickname': 'members_nickname',
                    'members_nickname_contains': 'members_nickname_contains',
                    'search_query': 'search_query',
                    'search_fields': 'search_fields',
                    'metadata_key': 'metadata_key',
                    'metadata_values': 'metadata_values',
                    'metadata_value_startswith': 'metadata_value_startswith',
                    'metacounter_key': 'metacounter_key',
                    'metacounter_values': 'metacounter_values',
                    'metacounter_value_gt': 'metacounter_value_gt',
                    'metacounter_value_gte': 'metacounter_value_gte',
                    'metacounter_value_lt': 'metacounter_value_lt',
                    'metacounter_value_lte': 'metacounter_value_lte',
                    'custom_type': 'custom_type',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'token': 'query',
                    'limit': 'query',
                    'distinct_mode': 'query',
                    'public_mode': 'query',
                    'super_mode': 'query',
                    'hidden_mode': 'query',
                    'member_state_filter': 'query',
                    'unread_filter': 'query',
                    'created_after': 'query',
                    'created_before': 'query',
                    'show_empty': 'query',
                    'show_frozen': 'query',
                    'show_member': 'query',
                    'show_delivery_receipt': 'query',
                    'show_read_receipt': 'query',
                    'order': 'query',
                    'metadata_order_key': 'query',
                    'custom_types': 'query',
                    'custom_type_startswith': 'query',
                    'channel_urls': 'query',
                    'name': 'query',
                    'name_contains': 'query',
                    'name_startswith': 'query',
                    'members_exactly_in': 'query',
                    'members_include_in': 'query',
                    'query_type': 'query',
                    'members_nickname': 'query',
                    'members_nickname_contains': 'query',
                    'search_query': 'query',
                    'search_fields': 'query',
                    'metadata_key': 'query',
                    'metadata_values': 'query',
                    'metadata_value_startswith': 'query',
                    'metacounter_key': 'query',
                    'metacounter_values': 'query',
                    'metacounter_value_gt': 'query',
                    'metacounter_value_gte': 'query',
                    'metacounter_value_lt': 'query',
                    'metacounter_value_lte': 'query',
                    'custom_type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_registration_or_device_tokens_endpoint = _Endpoint(
            settings={
                'response_type': (ListRegistrationOrDeviceTokensResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push/{token_type}',
                'operation_id': 'list_registration_or_device_tokens',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'token_type',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'token_type',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'token_type':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'token_type': 'token_type',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'token_type': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_users_endpoint = _Endpoint(
            settings={
                'response_type': (ListUsersResponse,),
                'auth': [],
                'endpoint_path': '/v3/users',
                'operation_id': 'list_users',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'token',
                    'limit',
                    'active_mode',
                    'show_bot',
                    'user_ids',
                    'nickname',
                    'nickname_startswith',
                    'metadatakey',
                    'metadatavalues_in',
                ],
                'required': [
                    'api_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'token':
                        (str,),
                    'limit':
                        (int,),
                    'active_mode':
                        (str,),
                    'show_bot':
                        (bool,),
                    'user_ids':
                        (str,),
                    'nickname':
                        (str,),
                    'nickname_startswith':
                        (str,),
                    'metadatakey':
                        (str,),
                    'metadatavalues_in':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'token': 'token',
                    'limit': 'limit',
                    'active_mode': 'active_mode',
                    'show_bot': 'show_bot',
                    'user_ids': 'user_ids',
                    'nickname': 'nickname',
                    'nickname_startswith': 'nickname_startswith',
                    'metadatakey': 'metadatakey',
                    'metadatavalues_in': 'metadatavalues_in',
                },
                'location_map': {
                    'api_token': 'header',
                    'token': 'query',
                    'limit': 'query',
                    'active_mode': 'query',
                    'show_bot': 'query',
                    'user_ids': 'query',
                    'nickname': 'query',
                    'nickname_startswith': 'query',
                    'metadatakey': 'query',
                    'metadatavalues_in': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.mark_all_messages_as_read_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/mark_as_read_all',
                'operation_id': 'mark_all_messages_as_read',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'mark_all_messages_as_read_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'mark_all_messages_as_read_data':
                        (MarkAllMessagesAsReadData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'mark_all_messages_as_read_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.register_as_operator_to_channels_with_custom_channel_types_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/operating_channel_custom_types',
                'operation_id': 'register_as_operator_to_channels_with_custom_channel_types',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'register_as_operator_to_channels_with_custom_channel_types_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'register_as_operator_to_channels_with_custom_channel_types_data':
                        (RegisterAsOperatorToChannelsWithCustomChannelTypesData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'register_as_operator_to_channels_with_custom_channel_types_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.remove_registration_or_device_token_endpoint = _Endpoint(
            settings={
                'response_type': (RemoveRegistrationOrDeviceTokenResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push',
                'operation_id': 'remove_registration_or_device_token',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_registration_or_device_token_by_token_endpoint = _Endpoint(
            settings={
                'response_type': (RemoveRegistrationOrDeviceTokenByTokenResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push/{token_type}/{token}',
                'operation_id': 'remove_registration_or_device_token_by_token',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'token_type',
                    'token',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'token_type',
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'token_type':
                        (str,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'token_type': 'token_type',
                    'token': 'token',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'token_type': 'path',
                    'token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.remove_registration_or_device_token_from_owner_by_token_endpoint = _Endpoint(
            settings={
                'response_type': (RemoveRegistrationOrDeviceTokenFromOwnerByTokenResponse,),
                'auth': [],
                'endpoint_path': '/v3/push/device_tokens/{token_type}/{token}',
                'operation_id': 'remove_registration_or_device_token_from_owner_by_token',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'token_type',
                    'token',
                ],
                'required': [
                    'api_token',
                    'token_type',
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'token_type':
                        (str,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'token_type': 'token_type',
                    'token': 'token',
                },
                'location_map': {
                    'api_token': 'header',
                    'token_type': 'path',
                    'token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.reset_push_preferences_endpoint = _Endpoint(
            settings={
                'response_type': (ResetPushPreferencesResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push_preference',
                'operation_id': 'reset_push_preferences',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_channel_invitation_preference_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateChannelInvitationPreferenceResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/channel_invitation_preference',
                'operation_id': 'update_channel_invitation_preference',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'update_channel_invitation_preference_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'update_channel_invitation_preference_data':
                        (UpdateChannelInvitationPreferenceData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'update_channel_invitation_preference_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_count_preference_of_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (UpdateCountPreferenceOfChannelByUrlResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/count_preference/{channel_url}',
                'operation_id': 'update_count_preference_of_channel_by_url',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'channel_url',
                    'update_count_preference_of_channel_by_url_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'channel_url':
                        (str,),
                    'update_count_preference_of_channel_by_url_data':
                        (UpdateCountPreferenceOfChannelByUrlData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'channel_url': 'path',
                    'update_count_preference_of_channel_by_url_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_push_preferences_endpoint = _Endpoint(
            settings={
                'response_type': (UpdatePushPreferencesResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push_preference',
                'operation_id': 'update_push_preferences',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'update_push_preferences_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'update_push_preferences_data':
                        (UpdatePushPreferencesData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'update_push_preferences_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_push_preferences_for_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (UpdatePushPreferencesForChannelByUrlResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push_preference/{channel_url}',
                'operation_id': 'update_push_preferences_for_channel_by_url',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'channel_url',
                    'update_push_preferences_for_channel_by_url_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'channel_url':
                        (str,),
                    'update_push_preferences_for_channel_by_url_data':
                        (UpdatePushPreferencesForChannelByUrlData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'channel_url': 'path',
                    'update_push_preferences_for_channel_by_url_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_user_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdUser,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}',
                'operation_id': 'update_user_by_id',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'update_user_by_id_data',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'update_user_by_id_data':
                        (UpdateUserByIdData,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'update_user_by_id_data': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.view_channel_invitation_preference_endpoint = _Endpoint(
            settings={
                'response_type': (ViewChannelInvitationPreferenceResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/channel_invitation_preference',
                'operation_id': 'view_channel_invitation_preference',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_count_preference_of_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (ViewCountPreferenceOfChannelByUrlResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/count_preference/{channel_url}',
                'operation_id': 'view_count_preference_of_channel_by_url',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'channel_url',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'channel_url':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'channel_url': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_number_of_channels_by_join_status_endpoint = _Endpoint(
            settings={
                'response_type': (ViewNumberOfChannelsByJoinStatusResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/group_channel_count',
                'operation_id': 'view_number_of_channels_by_join_status',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'state',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'state':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'state': 'state',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'state': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_number_of_channels_with_unread_messages_endpoint = _Endpoint(
            settings={
                'response_type': (ViewNumberOfChannelsWithUnreadMessagesResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/unread_channel_count',
                'operation_id': 'view_number_of_channels_with_unread_messages',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'custom_types',
                    'super_mode',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'custom_types':
                        ([str],),
                    'super_mode':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'custom_types': 'custom_types',
                    'super_mode': 'super_mode',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'custom_types': 'query',
                    'super_mode': 'query',
                },
                'collection_format_map': {
                    'custom_types': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_number_of_unread_items_endpoint = _Endpoint(
            settings={
                'response_type': (ViewNumberOfUnreadItemsResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/unread_item_count',
                'operation_id': 'view_number_of_unread_items',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'custom_type',
                    'item_keys',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'custom_type':
                        (str,),
                    'item_keys':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'custom_type': 'custom_type',
                    'item_keys': 'item_keys',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'custom_type': 'query',
                    'item_keys': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_number_of_unread_messages_endpoint = _Endpoint(
            settings={
                'response_type': (ViewNumberOfUnreadMessagesResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/unread_message_count',
                'operation_id': 'view_number_of_unread_messages',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'custom_types',
                    'super_mode',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'custom_types':
                        (str,),
                    'super_mode':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'custom_types': 'custom_types',
                    'super_mode': 'super_mode',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'custom_types': 'query',
                    'super_mode': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_push_preferences_endpoint = _Endpoint(
            settings={
                'response_type': (ViewPushPreferencesResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push_preference',
                'operation_id': 'view_push_preferences',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_push_preferences_for_channel_by_url_endpoint = _Endpoint(
            settings={
                'response_type': (ViewPushPreferencesForChannelByUrlResponse,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}/push_preference/{channel_url}',
                'operation_id': 'view_push_preferences_for_channel_by_url',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'channel_url',
                ],
                'required': [
                    'api_token',
                    'user_id',
                    'channel_url',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'channel_url':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'channel_url': 'channel_url',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'channel_url': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_user_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (SendBirdUser,),
                'auth': [],
                'endpoint_path': '/v3/users/{user_id}',
                'operation_id': 'view_user_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'user_id',
                    'include_unread_count',
                    'custom_types',
                    'super_mode',
                ],
                'required': [
                    'api_token',
                    'user_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'user_id':
                        (str,),
                    'include_unread_count':
                        (bool,),
                    'custom_types':
                        (str,),
                    'super_mode':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'user_id': 'user_id',
                    'include_unread_count': 'include_unread_count',
                    'custom_types': 'custom_types',
                    'super_mode': 'super_mode',
                },
                'location_map': {
                    'api_token': 'header',
                    'user_id': 'path',
                    'include_unread_count': 'query',
                    'custom_types': 'query',
                    'super_mode': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.view_who_owns_registration_or_device_token_by_token_endpoint = _Endpoint(
            settings={
                'response_type': (ViewWhoOwnsRegistrationOrDeviceTokenByTokenResponse,),
                'auth': [],
                'endpoint_path': '/v3/push/device_tokens/{token_type}/{token}',
                'operation_id': 'view_who_owns_registration_or_device_token_by_token',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'api_token',
                    'token_type',
                    'token',
                ],
                'required': [
                    'api_token',
                    'token_type',
                    'token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'api_token':
                        (str,),
                    'token_type':
                        (str,),
                    'token':
                        (str,),
                },
                'attribute_map': {
                    'api_token': 'Api-Token',
                    'token_type': 'token_type',
                    'token': 'token',
                },
                'location_map': {
                    'api_token': 'header',
                    'token_type': 'path',
                    'token': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def add_registration_or_device_token(
        self,
        api_token,
        user_id,
        token_type,
        **kwargs
    ):
        """Add a registration or device token  # noqa: E501

        ## Add a registration or device token  > __Note__: A user can have up to 20 FCM registration tokens, 20 HMS device tokens, and 20 APNs device tokens each. The oldest token will be deleted before a new token is added for a user who already has 20 registration or device tokens. Only the 20 newest tokens will be maintained for users who already have more than 20 of each token type.  To send notification requests to push notification services on behalf of your server, adds a specific user's FCM registration token, HMS device token, or APNs device token to Sendbird server. Depending on which push service you are using, you can pass one of two values in `token_type`: `gcm`, `huawei`, or `apns`.  A FCM registration token and an APNs device token allow identification of each client app instance on each device, and are generated and registered by Android and iOS apps through the corresponding SDKs. Use this method if you need to register a token via your own server.  > __Note__: For more information on the registration token and device token, visit the Google's [FCM](https://firebase.google.com/docs/auth/admin/verify-id-tokens) page, Huawei's [Push kit](https://developer.huawei.com/consumer/en/doc/development/HMSCore-Guides/service-introduction-0000001050040060) and Apple's [APNs](https://developer.apple.com/library/content/documentation/NetworkingInternet/Conceptual/RemoteNotificationsPG/APNSOverview.html) page.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-add-a-registration-or-device-token ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_registration_or_device_token(api_token, user_id, token_type, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            token_type (str):

        Keyword Args:
            add_registration_or_device_token_data (AddRegistrationOrDeviceTokenData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AddRegistrationOrDeviceTokenResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['token_type'] = \
            token_type
        return self.add_registration_or_device_token_endpoint.call_with_http_info(**kwargs)

    def choose_push_notification_content_template(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Choose a push notification content template  # noqa: E501

        ## Choose a push notification content template  Chooses a push notification content template of a user's own. The push notifications feature is only available for group channels.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-choose-a-push-notification-content-template ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.choose_push_notification_content_template(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ChoosePushNotificationContentTemplateResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.choose_push_notification_content_template_endpoint.call_with_http_info(**kwargs)

    def create_user(
        self,
        api_token,
        **kwargs
    ):
        """Create a user  # noqa: E501

        ## Create a user  Creates a new user in the application. A user is identified by its unique user ID, and additionally have a changeable nickname, profile image, and so on.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-create-a-user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user(api_token, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):

        Keyword Args:
            create_user_data (CreateUserData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdUser
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        return self.create_user_endpoint.call_with_http_info(**kwargs)

    def create_user_token(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Create user token  # noqa: E501

        ## Create user token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_token(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            create_user_token_data (CreateUserTokenData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            CreateUserTokenResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.create_user_token_endpoint.call_with_http_info(**kwargs)

    def delete_user_by_id(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Delete a user  # noqa: E501

        ## Delete a user  Deletes a user.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-delete-a-user ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_by_id(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.delete_user_by_id_endpoint.call_with_http_info(**kwargs)

    def leave_my_group_channels(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Leave my group channels  # noqa: E501

        ## Leave my group channels  Makes a user leave all joined group channels.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-leave-my-group-channels ----------------------------   `user_id`      Type: string      Description: Specifies the unique ID of the user to leave all joined group channels.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.leave_my_group_channels(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            leave_my_group_channels_data (LeaveMyGroupChannelsData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.leave_my_group_channels_endpoint.call_with_http_info(**kwargs)

    def list_my_group_channels(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """List my group channels  # noqa: E501

        ## List my group channels  Retrieves all group channels that the user has joined. You can create a request based on various query parameters.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-list-my-group-channels ----------------------------   `user_id`      Type: string      Description: Specifies the unique ID of the target user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_my_group_channels(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            token (str): [optional]
            limit (int): [optional]
            distinct_mode (str): [optional]
            public_mode (str): [optional]
            super_mode (str): [optional]
            hidden_mode (str): [optional]
            member_state_filter (str): [optional]
            unread_filter (str): [optional]
            created_after (int): [optional]
            created_before (int): [optional]
            show_empty (bool): [optional]
            show_frozen (bool): [optional]
            show_member (bool): [optional]
            show_delivery_receipt (bool): [optional]
            show_read_receipt (bool): [optional]
            order (str): [optional]
            metadata_order_key (str): [optional]
            custom_types (str): [optional]
            custom_type_startswith (str): [optional]
            channel_urls (str): [optional]
            name (str): [optional]
            name_contains (str): [optional]
            name_startswith (str): [optional]
            members_exactly_in (str): [optional]
            members_include_in (str): [optional]
            query_type (str): [optional]
            members_nickname (str): [optional]
            members_nickname_contains (str): [optional]
            search_query (str): [optional]
            search_fields (str): [optional]
            metadata_key (str): [optional]
            metadata_values (str): [optional]
            metadata_value_startswith (str): [optional]
            metacounter_key (str): [optional]
            metacounter_values (str): [optional]
            metacounter_value_gt (str): [optional]
            metacounter_value_gte (str): [optional]
            metacounter_value_lt (str): [optional]
            metacounter_value_lte (str): [optional]
            custom_type (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListMyGroupChannelsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.list_my_group_channels_endpoint.call_with_http_info(**kwargs)

    def list_registration_or_device_tokens(
        self,
        api_token,
        user_id,
        token_type,
        **kwargs
    ):
        """List registration or device tokens  # noqa: E501

        ## List registration or device tokens  Retrieves a list of a specific user's FCM registration tokens, HMS device tokens, or APNs device tokens. You can specify either `gcm`, `huawei`, or `apns` in the `token_type` parameter, depending on which push notification service you are using.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-list-registration-or-device-tokens ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_registration_or_device_tokens(api_token, user_id, token_type, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            token_type (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListRegistrationOrDeviceTokensResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['token_type'] = \
            token_type
        return self.list_registration_or_device_tokens_endpoint.call_with_http_info(**kwargs)

    def list_users(
        self,
        api_token,
        **kwargs
    ):
        """List users  # noqa: E501

        ## List users  Retrieves a list of users in your application. You can query the list using various parameters.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-list-users ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_users(api_token, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):

        Keyword Args:
            token (str): [optional]
            limit (int): [optional]
            active_mode (str): [optional]
            show_bot (bool): [optional]
            user_ids (str): [optional]
            nickname (str): [optional]
            nickname_startswith (str): [optional]
            metadatakey (str): [optional]
            metadatavalues_in (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ListUsersResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        return self.list_users_endpoint.call_with_http_info(**kwargs)

    def mark_all_messages_as_read(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Mark all messages as read  # noqa: E501

        ## Mark all messages as read  Marks all of a user's unread messages as read in the joined group channels.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-mark-all-messages-as-read ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.mark_all_messages_as_read(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            mark_all_messages_as_read_data (MarkAllMessagesAsReadData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.mark_all_messages_as_read_endpoint.call_with_http_info(**kwargs)

    def register_as_operator_to_channels_with_custom_channel_types(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Register as an operator to channels with custom channel types  # noqa: E501

        ## Register as an operator to channels with custom channel types  Registers a user as an operator to channels with particular custom channel types.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-register-as-an-operator-to-channels-with-custom-channel-types ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.register_as_operator_to_channels_with_custom_channel_types(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            register_as_operator_to_channels_with_custom_channel_types_data (RegisterAsOperatorToChannelsWithCustomChannelTypesData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.register_as_operator_to_channels_with_custom_channel_types_endpoint.call_with_http_info(**kwargs)

    def remove_registration_or_device_token(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Remove a registration or device token - When unregistering all device tokens  # noqa: E501

        ## Remove a registration or device token  Removes a specific user's one or more FCM registration tokens, HMS device tokens, or APNs device tokens.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-remove-a-registration-or-device-token ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_registration_or_device_token(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RemoveRegistrationOrDeviceTokenResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.remove_registration_or_device_token_endpoint.call_with_http_info(**kwargs)

    def remove_registration_or_device_token_by_token(
        self,
        api_token,
        user_id,
        token_type,
        token,
        **kwargs
    ):
        """Remove a registration or device token - When unregistering a specific token  # noqa: E501

        ## Remove a registration or device token  Removes a specific user's one or more FCM registration tokens, HMS device tokens, or APNs device tokens.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-remove-a-registration-or-device-token ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_registration_or_device_token_by_token(api_token, user_id, token_type, token, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            token_type (str):
            token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RemoveRegistrationOrDeviceTokenByTokenResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['token_type'] = \
            token_type
        kwargs['token'] = \
            token
        return self.remove_registration_or_device_token_by_token_endpoint.call_with_http_info(**kwargs)

    def remove_registration_or_device_token_from_owner_by_token(
        self,
        api_token,
        token_type,
        token,
        **kwargs
    ):
        """Remove a registration or device token from an owner  # noqa: E501

        ## Remove a registration or device token from an owner  Removes a registration or device token from a user who owns it. You can pass one of two values in `token_type`: `gcm`, `huawei`, or `apns`, depending on which push service you are using.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-remove-a-registration-or-device-token-from-an-owner ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_registration_or_device_token_from_owner_by_token(api_token, token_type, token, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            token_type (str):
            token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RemoveRegistrationOrDeviceTokenFromOwnerByTokenResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['token_type'] = \
            token_type
        kwargs['token'] = \
            token
        return self.remove_registration_or_device_token_from_owner_by_token_endpoint.call_with_http_info(**kwargs)

    def reset_push_preferences(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Reset push preferences  # noqa: E501

        ## Reset push preferences  Resets a user's push preferences. After performing this action,   `do_not_disturb` and `snooze_enabled` are set to false.  The values of the parameters associated with the time frame are all set to 0.  `timezone` is reset to `UTC`.  `push_sound` is reset to `default`.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-reset-push-preferences ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.reset_push_preferences(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ResetPushPreferencesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.reset_push_preferences_endpoint.call_with_http_info(**kwargs)

    def update_channel_invitation_preference(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Update channel invitation preference  # noqa: E501

        ## Update channel invitation preference  Updates the channel invitation preference for a user's [private](https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#-3-private-vs-public) group channels.  > __Note__: Using the [update default channel invitation preference](https://sendbird.com/docs/chat/v3/platform-api/guides/application#2-update-default-channel-invitation-preference) action, you can update the value of channel invitation preference which is globally applied to all users within the application.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-update-channel-invitation-preference  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_channel_invitation_preference(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            update_channel_invitation_preference_data (UpdateChannelInvitationPreferenceData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateChannelInvitationPreferenceResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.update_channel_invitation_preference_endpoint.call_with_http_info(**kwargs)

    def update_count_preference_of_channel_by_url(
        self,
        api_token,
        user_id,
        channel_url,
        **kwargs
    ):
        """Update count preference of a channel  # noqa: E501

        ## Update count preference of a channel  Updates count preference of a specific group channel of a user.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-update-count-preference-of-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_count_preference_of_channel_by_url(api_token, user_id, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            channel_url (str):

        Keyword Args:
            update_count_preference_of_channel_by_url_data (UpdateCountPreferenceOfChannelByUrlData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdateCountPreferenceOfChannelByUrlResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['channel_url'] = \
            channel_url
        return self.update_count_preference_of_channel_by_url_endpoint.call_with_http_info(**kwargs)

    def update_push_preferences(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Update push preferences  # noqa: E501

        ## Update push preferences  Updates a user's push preferences. Through this action, you can set `do_not_disturb` for a user, and update the time frame in which the setting applies.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-update-push-preferences ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_push_preferences(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            update_push_preferences_data (UpdatePushPreferencesData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdatePushPreferencesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.update_push_preferences_endpoint.call_with_http_info(**kwargs)

    def update_push_preferences_for_channel_by_url(
        self,
        api_token,
        user_id,
        channel_url,
        **kwargs
    ):
        """Update push preferences for a channel  # noqa: E501

        ## Update push preferences for a channel  Updates push preferences for a user's specific group channel. The push notifications feature is only available for group channels.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-update-push-preferences-for-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_push_preferences_for_channel_by_url(api_token, user_id, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            channel_url (str):

        Keyword Args:
            update_push_preferences_for_channel_by_url_data (UpdatePushPreferencesForChannelByUrlData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            UpdatePushPreferencesForChannelByUrlResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['channel_url'] = \
            channel_url
        return self.update_push_preferences_for_channel_by_url_endpoint.call_with_http_info(**kwargs)

    def update_user_by_id(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """Update a user  # noqa: E501

        ## Update a user  Updates information on a user. In addition to changing a user's nickname or profile image, you can issue a new access token for the user. The new access token replaces the previous one as the necessary token for authentication.  You can also deactivate or reactivate a user. If the `leave_all_when_deactivated` is true (which it is by default), a user leaves all joined group channels when deactivated.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-update-a-user ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_by_id(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            update_user_by_id_data (UpdateUserByIdData): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdUser
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.update_user_by_id_endpoint.call_with_http_info(**kwargs)

    def view_channel_invitation_preference(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """View channel invitation preference  # noqa: E501

        ## View channel invitation preference  Retrieves channel invitation preference for a user's [private](https://sendbird.com/docs/chat/v3/platform-api/guides/group-channel#-3-private-vs-public) group channels.  > __Note__: Using the [view default channel invitation preference](https://sendbird.com/docs/chat/v3/platform-api/guides/application#2-view-default-channel-invitation-preference) action, you can retrieve the value of channel invitation preference which is globally applied to all users within the application.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-channel-invitation-preference  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_channel_invitation_preference(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewChannelInvitationPreferenceResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.view_channel_invitation_preference_endpoint.call_with_http_info(**kwargs)

    def view_count_preference_of_channel_by_url(
        self,
        api_token,
        user_id,
        channel_url,
        **kwargs
    ):
        """View count preference of a channel  # noqa: E501

        ## View count preference of a channel  Retrieves count preference of a specific group channel of a user.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-count-preference-of-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_count_preference_of_channel_by_url(api_token, user_id, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            channel_url (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewCountPreferenceOfChannelByUrlResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['channel_url'] = \
            channel_url
        return self.view_count_preference_of_channel_by_url_endpoint.call_with_http_info(**kwargs)

    def view_number_of_channels_by_join_status(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """View number of channels by join status  # noqa: E501

        ## View number of channels by join status  Retrieves the number of a user's group channels by their join status.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-number-of-channels-by-join-status ----------------------------   `user_id`      Type: string      Description: Specifies the unique ID of the user to retrieve the number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_number_of_channels_by_join_status(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            state (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewNumberOfChannelsByJoinStatusResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.view_number_of_channels_by_join_status_endpoint.call_with_http_info(**kwargs)

    def view_number_of_channels_with_unread_messages(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """View number of channels with unread messages  # noqa: E501

        ## View number of channels with unread messages  Retrieves the total number of a user's group channels with unread messages.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-number-of-channels-with-unread-messages ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_number_of_channels_with_unread_messages(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            custom_types ([str]): [optional]
            super_mode (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewNumberOfChannelsWithUnreadMessagesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.view_number_of_channels_with_unread_messages_endpoint.call_with_http_info(**kwargs)

    def view_number_of_unread_items(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """View number of unread items  # noqa: E501

        ## View number of unread items  Retrieves a set of total numbers of a user's unread messages, unread mentioned messages, or received invitations in either super or non-super group channels. This action is only available for the group channels.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-number-of-unread-items ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_number_of_unread_items(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            custom_type (str): [optional]
            item_keys (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewNumberOfUnreadItemsResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.view_number_of_unread_items_endpoint.call_with_http_info(**kwargs)

    def view_number_of_unread_messages(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """View number of unread messages  # noqa: E501

        ## View number of unread messages  Retrieves the total number of a user's currently unread messages in the group channels. The unread counts feature is only available for the group channels.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-number-of-unread-messages ----------------------------   `user_id`      Type: string      Description: Specifies the unique ID of the user to retrieve the number.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_number_of_unread_messages(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            custom_types (str): [optional]
            super_mode (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewNumberOfUnreadMessagesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.view_number_of_unread_messages_endpoint.call_with_http_info(**kwargs)

    def view_push_preferences(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """View push preferences  # noqa: E501

        ## View push preferences  Retrieves a user's push preferences about whether the user has set `do_not_disturb` to pause notifications for a certain period of time, and the time frame in which the user has applied the setting.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-push-preferences ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_push_preferences(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewPushPreferencesResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.view_push_preferences_endpoint.call_with_http_info(**kwargs)

    def view_push_preferences_for_channel_by_url(
        self,
        api_token,
        user_id,
        channel_url,
        **kwargs
    ):
        """View push preferences for a channel  # noqa: E501

        ## View push preferences for a channel  Retrieves whether a user has turned on notification messages for a specific channel. The push notifications feature is only available for group channels.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-push-preferences-for-a-channel ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_push_preferences_for_channel_by_url(api_token, user_id, channel_url, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):
            channel_url (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewPushPreferencesForChannelByUrlResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        kwargs['channel_url'] = \
            channel_url
        return self.view_push_preferences_for_channel_by_url_endpoint.call_with_http_info(**kwargs)

    def view_user_by_id(
        self,
        api_token,
        user_id,
        **kwargs
    ):
        """View a user  # noqa: E501

        ## View a user  Retrieves information on a user.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-a-user ----------------------------   `user_id`      Type: string      Description: Specifies the unique ID of the user to retrieve.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_user_by_id(api_token, user_id, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            user_id (str):

        Keyword Args:
            include_unread_count (bool): [optional]
            custom_types (str): [optional]
            super_mode (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            SendBirdUser
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['user_id'] = \
            user_id
        return self.view_user_by_id_endpoint.call_with_http_info(**kwargs)

    def view_who_owns_registration_or_device_token_by_token(
        self,
        api_token,
        token_type,
        token,
        **kwargs
    ):
        """View who owns a registration or device token  # noqa: E501

        ## View who owns a registration or device token  Retrieves a user who owns a FCM registration token, HMS device token, or APNs device token. You can pass one of two values in `token_type`: `gcm`, `huawei`, or `apns`, depending on which push service you are using.  https://sendbird.com/docs/chat/v3/platform-api/guides/user#2-view-who-owns-a-registration-or-device-token ----------------------------  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.view_who_owns_registration_or_device_token_by_token(api_token, token_type, token, async_req=True)
        >>> result = thread.get()

        Args:
            api_token (str):
            token_type (str):
            token (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            ViewWhoOwnsRegistrationOrDeviceTokenByTokenResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['api_token'] = \
            api_token
        kwargs['token_type'] = \
            token_type
        kwargs['token'] = \
            token
        return self.view_who_owns_registration_or_device_token_by_token_endpoint.call_with_http_info(**kwargs)

