# mypy-boto3-iotanalytics

[![PyPI - mypy-boto3-iotanalytics](https://img.shields.io/pypi/v/mypy-boto3-iotanalytics.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotanalytics)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-iotanalytics.svg?color=blue)](https://pypi.org/project/mypy-boto3-iotanalytics)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.IoTAnalytics 1.17.9](https://boto3.amazonaws.com/v1/documentation/api/1.17.9/reference/services/iotanalytics.html#IoTAnalytics) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-iotanalytics](#mypy-boto3-iotanalytics)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `IoTAnalytics` service.

```bash
python -m pip install boto3-stubs[iotanalytics]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[iotanalytics]` in your environment: `python -m pip install 'boto3-stubs[iotanalytics]'`

Both type checking and auto-complete should work for `IoTAnalytics` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[iotanalytics]` in your environment: `python -m pip install 'boto3-stubs[iotanalytics]'`

Both type checking and auto-complete should work for `IoTAnalytics` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[iotanalytics]` in your environment: `python -m pip install 'boto3-stubs[iotanalytics]'`
- Run `mypy` as usual

Type checking should work for `IoTAnalytics` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[iotanalytics]` in your environment: `python -m pip install 'boto3-stubs[iotanalytics]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IoTAnalytics` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`IoTAnalyticsClient` provides annotations for `boto3.client("iotanalytics")`.

```python
import boto3

from mypy_boto3_iotanalytics import IoTAnalyticsClient

client: IoTAnalyticsClient = boto3.client("iotanalytics")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IoTAnalyticsClient = session.client("iotanalytics")
```

### Paginators annotations

`mypy_boto3_iotanalytics.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_iotanalytics import IoTAnalyticsClient
from mypy_boto3_iotanalytics.paginator import (
    ListChannelsPaginator,
    ListDatasetContentsPaginator,
    ListDatasetsPaginator,
    ListDatastoresPaginator,
    ListPipelinesPaginator,
)

client: IoTAnalyticsClient = boto3.client("iotanalytics")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_channels_paginator: ListChannelsPaginator = client.get_paginator("list_channels")
list_dataset_contents_paginator: ListDatasetContentsPaginator = client.get_paginator("list_dataset_contents")
list_datasets_paginator: ListDatasetsPaginator = client.get_paginator("list_datasets")
list_datastores_paginator: ListDatastoresPaginator = client.get_paginator("list_datastores")
list_pipelines_paginator: ListPipelinesPaginator = client.get_paginator("list_pipelines")
```







### Typed dictionations

`mypy_boto3_iotanalytics.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_iotanalytics.type_defs import (
    AddAttributesActivityTypeDef,
    BatchPutMessageErrorEntryTypeDef,
    ChannelActivityTypeDef,
    ChannelStatisticsTypeDef,
    ChannelStorageSummaryTypeDef,
    ChannelStorageTypeDef,
    ChannelSummaryTypeDef,
    ChannelTypeDef,
    ColumnTypeDef,
    ContainerDatasetActionTypeDef,
    CustomerManagedChannelS3StorageSummaryTypeDef,
    CustomerManagedChannelS3StorageTypeDef,
    CustomerManagedDatastoreS3StorageSummaryTypeDef,
    CustomerManagedDatastoreS3StorageTypeDef,
    DatasetActionSummaryTypeDef,
    DatasetActionTypeDef,
    DatasetContentDeliveryDestinationTypeDef,
    DatasetContentDeliveryRuleTypeDef,
    DatasetContentStatusTypeDef,
    DatasetContentSummaryTypeDef,
    DatasetContentVersionValueTypeDef,
    DatasetEntryTypeDef,
    DatasetSummaryTypeDef,
    DatasetTriggerTypeDef,
    DatasetTypeDef,
    DatastoreActivityTypeDef,
    DatastoreStatisticsTypeDef,
    DatastoreStorageSummaryTypeDef,
    DatastoreStorageTypeDef,
    DatastoreSummaryTypeDef,
    DatastoreTypeDef,
    DeltaTimeSessionWindowConfigurationTypeDef,
    DeltaTimeTypeDef,
    DeviceRegistryEnrichActivityTypeDef,
    DeviceShadowEnrichActivityTypeDef,
    EstimatedResourceSizeTypeDef,
    FileFormatConfigurationTypeDef,
    FilterActivityTypeDef,
    GlueConfigurationTypeDef,
    IotEventsDestinationConfigurationTypeDef,
    LambdaActivityTypeDef,
    LateDataRuleConfigurationTypeDef,
    LateDataRuleTypeDef,
    LoggingOptionsTypeDef,
    MathActivityTypeDef,
    OutputFileUriValueTypeDef,
    ParquetConfigurationTypeDef,
    PipelineActivityTypeDef,
    PipelineSummaryTypeDef,
    PipelineTypeDef,
    QueryFilterTypeDef,
    RemoveAttributesActivityTypeDef,
    ReprocessingSummaryTypeDef,
    ResourceConfigurationTypeDef,
    RetentionPeriodTypeDef,
    S3DestinationConfigurationTypeDef,
    ScheduleTypeDef,
    SchemaDefinitionTypeDef,
    SelectAttributesActivityTypeDef,
    SqlQueryDatasetActionTypeDef,
    TagTypeDef,
    TriggeringDatasetTypeDef,
    VariableTypeDef,
    VersioningConfigurationTypeDef,
    BatchPutMessageResponseTypeDef,
    ChannelMessagesTypeDef,
    CreateChannelResponseTypeDef,
    CreateDatasetContentResponseTypeDef,
    CreateDatasetResponseTypeDef,
    CreateDatastoreResponseTypeDef,
    CreatePipelineResponseTypeDef,
    DescribeChannelResponseTypeDef,
    DescribeDatasetResponseTypeDef,
    DescribeDatastoreResponseTypeDef,
    DescribeLoggingOptionsResponseTypeDef,
    DescribePipelineResponseTypeDef,
    GetDatasetContentResponseTypeDef,
    ListChannelsResponseTypeDef,
    ListDatasetContentsResponseTypeDef,
    ListDatasetsResponseTypeDef,
    ListDatastoresResponseTypeDef,
    ListPipelinesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    MessageTypeDef,
    PaginatorConfigTypeDef,
    RunPipelineActivityResponseTypeDef,
    SampleChannelDataResponseTypeDef,
    StartPipelineReprocessingResponseTypeDef,
)

def get_structure() -> AddAttributesActivityTypeDef:
    return {
      ...
    }
```
