import tkinter as tk

# ************************
# Scrollable Frame Class
# Created by Mark Pointing (https://gist.github.com/mp035)
# ************************

class ScrollFrame(tk.Frame):
	def __init__(self, parent):
		super().__init__(parent) # create a frame (self)		


		self.canvas = tk.Canvas(self, borderwidth=0, background="#ffffff")		  #place canvas on self
		self.viewPort = tk.Frame(self.canvas, background="#ffffff")					#place a frame on the canvas, this frame will hold the child widgets 
		self.vsb = tk.Scrollbar(self, orient="vertical", command=self.canvas.yview) #place a scrollbar on self 
		self.canvas.configure(yscrollcommand=self.vsb.set)						  #attach scrollbar action to scroll of canvas

		self.vsb.pack(side="right", fill="y")									   #pack scrollbar to right of self
		self.canvas.pack(side="left", fill="both", expand=True)					 #pack canvas to left of self and expand to fil
		self.canvas.create_window((4,4), window=self.viewPort, anchor="nw",			#add view port frame to canvas
								  tags="self.viewPort")
		self.canvas_frame = self.canvas.create_window((0,0), window=self.viewPort, anchor = tk.NW)

		self.viewPort.bind("<Configure>", self.onFrameConfigure)					   #bind an event whenever the size of the viewPort frame changes.
		self.canvas.bind('<Configure>', self.FrameWidth)

	def FrameWidth(self, event):
		canvas_width = event.width
		self.canvas.itemconfig(self.canvas_frame, width = canvas_width)

	def onFrameConfigure(self, event):											  
		'''Reset the scroll region to encompass the inner frame'''
		self.canvas.configure(scrollregion=self.canvas.bbox("all"))