# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['zenml',
 'zenml.alerter',
 'zenml.annotators',
 'zenml.artifact_stores',
 'zenml.artifacts',
 'zenml.cli',
 'zenml.config',
 'zenml.container_registries',
 'zenml.data_validators',
 'zenml.entrypoints',
 'zenml.experiment_trackers',
 'zenml.feature_stores',
 'zenml.integrations',
 'zenml.integrations.airflow',
 'zenml.integrations.airflow.flavors',
 'zenml.integrations.airflow.orchestrators',
 'zenml.integrations.aws',
 'zenml.integrations.aws.container_registries',
 'zenml.integrations.aws.flavors',
 'zenml.integrations.aws.secrets_managers',
 'zenml.integrations.aws.step_operators',
 'zenml.integrations.azure',
 'zenml.integrations.azure.artifact_stores',
 'zenml.integrations.azure.flavors',
 'zenml.integrations.azure.secrets_managers',
 'zenml.integrations.azure.step_operators',
 'zenml.integrations.bentoml',
 'zenml.integrations.bentoml.flavors',
 'zenml.integrations.bentoml.materializers',
 'zenml.integrations.bentoml.model_deployers',
 'zenml.integrations.bentoml.services',
 'zenml.integrations.bentoml.steps',
 'zenml.integrations.dash',
 'zenml.integrations.dash.visualizers',
 'zenml.integrations.deepchecks',
 'zenml.integrations.deepchecks.data_validators',
 'zenml.integrations.deepchecks.flavors',
 'zenml.integrations.deepchecks.materializers',
 'zenml.integrations.deepchecks.steps',
 'zenml.integrations.deepchecks.visualizers',
 'zenml.integrations.evidently',
 'zenml.integrations.evidently.data_validators',
 'zenml.integrations.evidently.flavors',
 'zenml.integrations.evidently.materializers',
 'zenml.integrations.evidently.steps',
 'zenml.integrations.evidently.visualizers',
 'zenml.integrations.facets',
 'zenml.integrations.facets.visualizers',
 'zenml.integrations.feast',
 'zenml.integrations.feast.feature_stores',
 'zenml.integrations.feast.flavors',
 'zenml.integrations.gcp',
 'zenml.integrations.gcp.artifact_stores',
 'zenml.integrations.gcp.flavors',
 'zenml.integrations.gcp.orchestrators',
 'zenml.integrations.gcp.orchestrators.vertex_scheduler',
 'zenml.integrations.gcp.secrets_manager',
 'zenml.integrations.gcp.step_operators',
 'zenml.integrations.github',
 'zenml.integrations.github.flavors',
 'zenml.integrations.github.orchestrators',
 'zenml.integrations.github.secrets_managers',
 'zenml.integrations.graphviz',
 'zenml.integrations.graphviz.visualizers',
 'zenml.integrations.great_expectations',
 'zenml.integrations.great_expectations.data_validators',
 'zenml.integrations.great_expectations.flavors',
 'zenml.integrations.great_expectations.materializers',
 'zenml.integrations.great_expectations.steps',
 'zenml.integrations.great_expectations.visualizers',
 'zenml.integrations.huggingface',
 'zenml.integrations.huggingface.materializers',
 'zenml.integrations.kserve',
 'zenml.integrations.kserve.custom_deployer',
 'zenml.integrations.kserve.flavors',
 'zenml.integrations.kserve.model_deployers',
 'zenml.integrations.kserve.secret_schemas',
 'zenml.integrations.kserve.services',
 'zenml.integrations.kserve.steps',
 'zenml.integrations.kubeflow',
 'zenml.integrations.kubeflow.flavors',
 'zenml.integrations.kubeflow.orchestrators',
 'zenml.integrations.kubernetes',
 'zenml.integrations.kubernetes.flavors',
 'zenml.integrations.kubernetes.orchestrators',
 'zenml.integrations.label_studio',
 'zenml.integrations.label_studio.annotators',
 'zenml.integrations.label_studio.flavors',
 'zenml.integrations.label_studio.label_config_generators',
 'zenml.integrations.label_studio.steps',
 'zenml.integrations.lightgbm',
 'zenml.integrations.lightgbm.materializers',
 'zenml.integrations.mlflow',
 'zenml.integrations.mlflow.experiment_trackers',
 'zenml.integrations.mlflow.flavors',
 'zenml.integrations.mlflow.model_deployers',
 'zenml.integrations.mlflow.services',
 'zenml.integrations.mlflow.steps',
 'zenml.integrations.neptune',
 'zenml.integrations.neptune.experiment_trackers',
 'zenml.integrations.neptune.flavors',
 'zenml.integrations.neural_prophet',
 'zenml.integrations.neural_prophet.materializers',
 'zenml.integrations.pillow',
 'zenml.integrations.pillow.materializers',
 'zenml.integrations.plotly',
 'zenml.integrations.plotly.visualizers',
 'zenml.integrations.pytorch',
 'zenml.integrations.pytorch.materializers',
 'zenml.integrations.pytorch_lightning',
 'zenml.integrations.pytorch_lightning.materializers',
 'zenml.integrations.s3',
 'zenml.integrations.s3.artifact_stores',
 'zenml.integrations.s3.flavors',
 'zenml.integrations.scipy',
 'zenml.integrations.scipy.materializers',
 'zenml.integrations.seldon',
 'zenml.integrations.seldon.custom_deployer',
 'zenml.integrations.seldon.flavors',
 'zenml.integrations.seldon.model_deployers',
 'zenml.integrations.seldon.secret_schemas',
 'zenml.integrations.seldon.services',
 'zenml.integrations.seldon.steps',
 'zenml.integrations.sklearn',
 'zenml.integrations.sklearn.materializers',
 'zenml.integrations.slack',
 'zenml.integrations.slack.alerters',
 'zenml.integrations.slack.flavors',
 'zenml.integrations.slack.steps',
 'zenml.integrations.spark',
 'zenml.integrations.spark.flavors',
 'zenml.integrations.spark.materializers',
 'zenml.integrations.spark.step_operators',
 'zenml.integrations.tekton',
 'zenml.integrations.tekton.flavors',
 'zenml.integrations.tekton.orchestrators',
 'zenml.integrations.tensorboard',
 'zenml.integrations.tensorboard.services',
 'zenml.integrations.tensorboard.visualizers',
 'zenml.integrations.tensorflow',
 'zenml.integrations.tensorflow.materializers',
 'zenml.integrations.vault',
 'zenml.integrations.vault.flavors',
 'zenml.integrations.vault.secrets_manager',
 'zenml.integrations.wandb',
 'zenml.integrations.wandb.experiment_trackers',
 'zenml.integrations.wandb.flavors',
 'zenml.integrations.whylogs',
 'zenml.integrations.whylogs.data_validators',
 'zenml.integrations.whylogs.flavors',
 'zenml.integrations.whylogs.materializers',
 'zenml.integrations.whylogs.secret_schemas',
 'zenml.integrations.whylogs.steps',
 'zenml.integrations.whylogs.visualizers',
 'zenml.integrations.xgboost',
 'zenml.integrations.xgboost.materializers',
 'zenml.io',
 'zenml.materializers',
 'zenml.model_deployers',
 'zenml.models',
 'zenml.orchestrators',
 'zenml.orchestrators.local',
 'zenml.orchestrators.local_docker',
 'zenml.pipelines',
 'zenml.post_execution',
 'zenml.post_execution.lineage',
 'zenml.post_execution.lineage.node',
 'zenml.recipes',
 'zenml.secret',
 'zenml.secret.schemas',
 'zenml.secrets_managers',
 'zenml.secrets_managers.local',
 'zenml.services',
 'zenml.services.container',
 'zenml.services.local',
 'zenml.services.terraform',
 'zenml.stack',
 'zenml.step_operators',
 'zenml.steps',
 'zenml.steps.step_interfaces',
 'zenml.utils',
 'zenml.visualizers',
 'zenml.zen_server',
 'zenml.zen_server.deploy',
 'zenml.zen_server.deploy.docker',
 'zenml.zen_server.deploy.local',
 'zenml.zen_server.deploy.terraform',
 'zenml.zen_server.deploy.terraform.providers',
 'zenml.zen_server.routers',
 'zenml.zen_stores',
 'zenml.zen_stores.migrations',
 'zenml.zen_stores.migrations.versions',
 'zenml.zen_stores.schemas']

package_data = \
{'': ['*'],
 'zenml.zen_server': ['dashboard/*',
                      'dashboard/static/css/*',
                      'dashboard/static/js/*',
                      'dashboard/static/media/*'],
 'zenml.zen_server.deploy': ['helm/*',
                             'helm/templates/*',
                             'helm/templates/tests/*'],
 'zenml.zen_server.deploy.terraform': ['recipes/aws/*',
                                       'recipes/azure/*',
                                       'recipes/gcp/*']}

install_requires = \
['alembic>=1.8.1,<1.9.0',
 'analytics-python>=1.4.0,<2.0.0',
 'click-params>=0.3.0,<0.4.0',
 'click>=8.0.1,<9.0.0',
 'distro>=1.6.0,<2.0.0',
 'docker>=6.0.0,<6.1.0',
 'gitpython>=3.1.18,<4.0.0',
 'httplib2>=0.19.1,<0.20',
 'pandas>=1.1.5,<2.0.0',
 'passlib[bcrypt]>=1.7.4,<1.8.0',
 'pydantic>=1.9.0,<1.10.0',
 'pymysql>=1.0.2,<1.1.0',
 'pyparsing>=2.4.0,<3',
 'python-dateutil>=2.8.1,<3.0.0',
 'python-terraform>=0.10.1,<0.11.0',
 'pyyaml>=5.4.1,<6.0.0',
 'rich[jupyter]>=12.0.0,<13.0.0',
 'sqlmodel>=0.0.8,<0.1.0']

extras_require = \
{'server': ['fastapi>=0.75.0,<0.76.0',
            'uvicorn[standard]>=0.17.5,<0.18.0',
            'python-multipart>=0.0.5,<0.1.0',
            'python-jose[cryptography]>=3.3.0,<3.4.0',
            'fastapi-utils>=0.2.1,<0.3.0']}

entry_points = \
{'console_scripts': ['zenml = zenml.cli.cli:cli']}

setup_kwargs = {
    'name': 'zenml',
    'version': '0.30.0',
    'description': 'ZenML: Write production-ready ML code.',
    'long_description': '<!-- PROJECT SHIELDS -->\n<!--\n*** I\'m using markdown "reference style" links for readability.\n*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).\n*** See the bottom of this document for the declaration of the reference variables\n*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.\n*** https://www.markdownguide.org/basic-syntax/#reference-style-links\n-->\n\n[![PyPi][pypi-shield]][pypi-url]\n[![PyPi][pypiversion-shield]][pypi-url]\n[![PyPi][downloads-shield]][downloads-url]\n[![Contributors][contributors-shield]][contributors-url]\n[![License][license-shield]][license-url]\n[![Build][build-shield]][build-url]\n<!-- [![Interrogate][interrogate-shield]][interrogate-url] -->\n<!-- [![CodeCov][codecov-shield]][codecov-url] -->\n\n<!-- MARKDOWN LINKS & IMAGES -->\n<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->\n[pypi-shield]: https://img.shields.io/pypi/pyversions/zenml?style=for-the-badge\n[pypi-url]: https://pypi.org/project/zenml/\n[pypiversion-shield]: https://img.shields.io/pypi/v/zenml?style=for-the-badge\n\n[downloads-shield]: https://img.shields.io/pypi/dm/zenml?style=for-the-badge\n[downloads-url]: https://pypi.org/project/zenml/\n[codecov-shield]: https://img.shields.io/codecov/c/gh/zenml-io/zenml?style=for-the-badge\n[codecov-url]: https://codecov.io/gh/zenml-io/zenml\n[contributors-shield]: https://img.shields.io/github/contributors/zenml-io/zenml?style=for-the-badge\n[contributors-url]: https://github.com/othneildrew/Best-README-Template/graphs/contributors\n[license-shield]: https://img.shields.io/github/license/zenml-io/zenml?style=for-the-badge\n[license-url]: https://github.com/zenml-io/zenml/blob/main/LICENSE\n[linkedin-shield]: https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555\n[linkedin-url]: https://www.linkedin.com/company/zenml/\n[twitter-shield]: https://img.shields.io/twitter/follow/zenml_io?style=for-the-badge\n[twitter-url]: https://twitter.com/zenml_io\n[slack-shield]: https://img.shields.io/badge/-Slack-black.svg?style=for-the-badge&logo=linkedin&colorB=555\n[slack-url]: https://zenml.io/slack-invite\n[build-shield]: https://img.shields.io/github/workflow/status/zenml-io/zenml/Build,%20Lint,%20Unit%20&%20Integration%20Test/develop?logo=github&style=for-the-badge\n[build-url]: https://github.com/zenml-io/zenml/actions/workflows/ci.yml\n[interrogate-shield]: https://img.shields.io/badge/Interrogate-100%25-brightgreen?style=for-the-badge&logo=interrogate\n[interrogate-url]: https://interrogate.readthedocs.io/en/latest/\n\n\n<!-- PROJECT LOGO -->\n<br />\n<div align="center">\n  <a href="https://zenml.io">\n    <img src="docs/book/assets/zenml_logo.png" alt="Logo" width="400">\n  </a>\n\n  <h3 align="center">Build portable, production-ready MLOps pipelines.</h3>\n\n  <p align="center">\n    A simple yet powerful open-source framework that integrates all your ML tools.\n    <br />\n    <a href="https://docs.zenml.io/"><strong>Explore the docs »</strong></a>\n    <br />\n    <div align="center">\n      Join our <a href="https://zenml.io/slack-invite" target="_blank">\n      <img width="25" src="https://cdn3.iconfinder.com/data/icons/logos-and-brands-adobe/512/306_Slack-512.png" alt="Slack"/>\n    <b>Slack Community</b> </a> and be part of the ZenML family.\n    </div>\n    <br />\n    <a href="https://zenml.io/features">Features</a>\n    ·\n    <a href="https://zenml.io/roadmap">Roadmap</a>\n    ·\n    <a href="https://github.com/zenml-io/zenml/issues">Report Bug</a>\n    ·\n    <a href="https://zenml.io/discussion">Vote New Features</a>\n    ·\n    <a href="https://blog.zenml.io/">Read Blog</a>\n    ·\n    <a href="#-meet-the-team">Meet the Team</a>\n    <br />\n    🎉 Version 0.30.0 is out. Check out the release notes\n    <a href="https://github.com/zenml-io/zenml/releases">here</a>.\n    <br />\n    <br />\n    <a href="https://www.linkedin.com/company/zenml/">\n    <img src="https://img.shields.io/badge/-LinkedIn-black.svg?style=for-the-badge&logo=linkedin&colorB=555" alt="Logo">\n    </a>\n    <a href="https://twitter.com/zenml_io">\n    <img src="https://img.shields.io/badge/-Twitter-black.svg?style=for-the-badge&logo=twitter&colorB=555" alt="Logo">\n    </a>\n    <a href="https://www.youtube.com/c/ZenML">\n    <img src="https://img.shields.io/badge/-YouTube-black.svg?style=for-the-badge&logo=youtube&colorB=555" alt="Logo">\n    </a>\n  </p>\n</div>\n\n<!-- TABLE OF CONTENTS -->\n<details>\n  <summary>🏁 Table of Contents</summary>\n  <ol>\n    <li>\n      <a href="#-why-zenml">Why ZenML?</a>\n    </li>\n    <li>\n    <a href="#-what-is-zenml">What is ZenML?</a>\n    </li>\n    <li>\n      <a href="#-getting-started">Getting Started</a>\n      <ul>\n        <li><a href="#-installation">Installation</a></li>\n        <li><a href="#-first-run">First run</a></li>\n        <li><a href="#-collaborate-with-zenml">Collaborate with ZenML</a></li>\n        <li><a href="#-zenbytes">ZenBytes</a></li>\n        <li><a href="#-zenfiles">ZenFiles</a></li>\n      </ul>\n    </li>\n    <li>\n      <a href="#%EF%B8%8F-infrastructure-requirements">Infrastructure Requirements</a>\n      <ul>\n        <li><a href="#-deploy-zenml">Deploy ZenML</a></li>\n        <li><a href="#-open-source-mlops-stack-recipes">MLOps Stack Recipes</a></li>\n      </ul>\n    </li>\n    <li><a href="#-roadmap">Roadmap</a></li>\n    <li><a href="#-contributing-and-community">Contributing and Community</a></li>\n    <li><a href="#-meet-the-team">Meet the Team</a></li>\n    <li><a href="#-getting-help">Getting Help</a></li>\n    <li><a href="#-license">License</a></li>\n    <li><a href="#-learn-more">Learn More</a></li>\n  </ol>\n</details>\n\n<br />\n\n# 🤖 Why ZenML?\n\n🤹 Are you an ML engineer or data scientist shipping models to production and juggling a plethora of tools? ZenML is here to help transition your production ML pipelines to production.\n\n![The long journey from experimentation to production.](docs/book/assets/1-pipeline-hard-reproduce.png)\n\nEveryone loves to train ML models, but few talks about shipping them into production, and even fewer can do it well. At ZenML, we believe the journey from model development to production doesn\'t need to be long and painful.\n\nIf you come from unstructured notebooks or scripts with lots of manual processes, ZenML will make the path to production easier and faster for you and your team. Using ZenML allows you to own the entire pipeline - from experimentation to production.\n\nRead more [here](https://blog.zenml.io/why-zenml/).\n\n\n# 💡 What is ZenML?\n\n<div align="center">\n    <img src="docs/book/assets/stack.gif">\n</div>\n\n\nZenML is an extensible, open-source MLOps framework for creating portable, production-ready MLOps pipelines. It\'s built for Data Scientists, ML Engineers, and MLOps Developers to collaborate as they develop to production. \n\nZenML offers a simple and flexible syntax, is cloud- and tool-agnostic, and has interfaces/abstractions catered toward ML workflows. \nWith ZenML you\'ll have all your favorite tools in one place, so you can tailor a workflow that caters to your specific needs.\n\nRead more on all tools you can readily use in the [integrations](https://zenml.io/integrations) section. Can\'t find your tool? You can always [write your own integration](https://docs.zenml.io/advanced-guide/stacks/custom-flavors) to use it with ZenML.\n\n# 🤸 Getting Started\n\n## 💾 Installation\n**Option 1** - Install ZenML via [PyPI](https://pypi.org/project/zenml/):\n\n```bash\npip install zenml\n```\n> **Note** - ZenML supports Python 3.7, 3.8, and 3.9.\n\nIn order to get access to the dashboard locally, install the optional dependencies for the ZenML server:\n\n```shell\npip install "zenml[server]"\n```\n\n**Option 2** - If you’re feeling adventurous, try out the bleeding-edge installation:\n\n```bash\npip install git+https://github.com/zenml-io/zenml.git@develop --upgrade\n```\n\n> **Warning** - Fire dragons ahead. Proceed at your own risk!\n\n**Option 3** - Install via a Docker image hosted publicly on\n[DockerHub](https://hub.docker.com/r/zenmldocker/zenml):\n\n```shell\ndocker run -it zenmldocker/zenml /bin/bash\n```\n\nor just run the ZenML server directly with Docker:\n\n```shell\ndocker run -it -d -p 8080:80 zenmldocker/zenml-server\n```\n\n> **Warning** \n> #### Known installation issues for M1 Mac users\n>\n> If you have an M1 Mac machine and encounter an installation error, \n> try setting up `brew` and `pyenv` with Rosetta 2 and then install ZenML. The issue arises because some dependencies \n> aren’t fully compatible with the vanilla ARM64 Architecture. The following links may be helpful (Thank you @Reid Falconer) :\n>\n>- [Pyenv with Apple Silicon](http://sixty-north.com/blog/pyenv-apple-silicon.html)\n>- [Install Python Under Rosetta 2](https://medium.com/thinknum/how-to-install-python-under-rosetta-2-f98c0865e012)\n\n\nRead full installation instructions in the [docs](https://docs.zenml.io/getting-started/installation).\n\n## 🏇 First run\n\nIf you\'re here for the first time, we recommend running:\n\n```shell\nzenml go\n```\n\nThis spins up a Jupyter notebook that walks you through various functionalities of ZenML at a high level.\n\nBy the end, you\'ll get a glimpse of how to use ZenML to register a stack:\n\n```shell\n# Register a MLflow experiment tracker\nzenml experiment-tracker register mlflow_tracker --flavor=mlflow\n\n# Register an Airflow orchestrator\nzenml orchestrator register airflow_orchestrator --flavor=airflow\n\n# Create a stack from the components\nzenml stack register airflow_stack -o airflow_orchestrator -a default -e mlflow_tracker\n```\n\nAnd run a simple pipeline on Airflow (or an orchestrator of your choice) creating steps like this:\n\n```python\nimport mlflow\nfrom sklearn.base import ClassifierMixin\nfrom sklearn.svm import SVC\nfrom zenml.client import Client\n\nexperiment_tracker = Client().active_stack.experiment_tracker\n\n@step(experiment_tracker=experiment_tracker.name)\ndef svc_trainer_mlflow(\n    X_train: pd.DataFrame,\n    y_train: pd.Series,\n) -> ClassifierMixin:\n    """Train a sklearn SVC classifier and log to MLflow."""\n    mlflow.sklearn.autolog()  # log all model hparams and metrics to MLflow\n    model = SVC(gamma=0.01)\n    model.fit(X_train.to_numpy(), y_train.to_numpy())\n    train_acc = model.score(X_train.to_numpy(), y_train.to_numpy())\n    print(f"Train accuracy: {train_acc}")\n    return model\n```\n\nYou can also run your first pipeline right in [Google Colab](https://colab.research.google.com/github/zenml-io/zenml/blob/main/examples/quickstart/notebooks/quickstart.ipynb)\n\n## 👭 Collaborate with ZenML\n\nZenML is built to support teams working together. \nThe underlying infrastructure on which your ML workflows run can be shared, as can the data, assets, and artifacts in your workflow. \n\nTo visually see this in action, ZenML ships with a fully-featured dashboard, that can be launched locally with the simple command:\n\n```\nzenml up\n```\n\n![ZenML Dashboard](docs/book/assets/getting_started/zenml-up.gif)\n\nThe dashboard can also be deployed with a server on any cloud service (see Deploy ZenML section).\n\n\n## 🍰 ZenBytes\n\nNew to MLOps? Get up to speed by visiting the [ZenBytes](https://github.com/zenml-io/zenbytes) repo.\n\n>ZenBytes is a series of short practical MLOps lessons taught using ZenML. \n>It covers many of the [core concepts](https://docs.zenml.io/getting-started/core-concepts) widely used in ZenML and MLOps in general.\n\n## 📜 ZenFiles\n\nAlready comfortable with ZenML and wish to elevate your pipeline into production mode? Check out [ZenFiles](https://github.com/zenml-io/zenfiles).\n\n>ZenFiles is a collection of production-grade ML use-cases powered by ZenML. They are fully fleshed out, end-to-end projects that showcase ZenML\'s capabilities. They can also serve as a template from which to start similar projects.\n\n\n# ☁️ Infrastructure Requirements\n\n## 🔋 Deploy ZenML\n\nWhile ZenML works perfectly fine locally, it should be deployed on the cloud to enable collaborative features as the central MLOps interface for teams.\n\nThe easiest and fastest way to get running on the cloud is by using the `deploy` CLI command. It currently only supports deploying to Kubernetes on managed cloud services. Read more about the command [here](https://docs.zenml.io/getting-started/deploying-zenml/deploying-zenml).\n\n```shell\nzenml deploy\n```\n\nNaturally, [the docs](https://docs.zenml.io/getting-started/deploying-zenml/deploying-zenml) contain detailed guides on how to manually set up ZenML on the cloud in case more control is required.\n\nThe following architectural diagram illustrates a common ZenML deployment:\n\n![ZenML Architecture Diagram.](docs/book/assets/getting_started/Scenario3.2.png)\n\n## 👨\u200d🍳 Open Source MLOps Stack Recipes\n\nApart from the infrastructure required to run ZenML itself, ZenML also boasts a ton of [integrations](https://zenml.io/integrations) into popular MLOps tools. The [ZenML Stack](https://docs.zenml.io/starter-guide/stacks/stacks) concept ensures that these tools work nicely together, therefore bringing structure and standardization into the MLOps workflow.\n\nHowever, ZenML assumes that the stack infrastructure for these tools is already provisioned. If you do not have deployed infrastructure, and want to quickly spin up combinations of tools on the cloud, the [MLOps stack sister repository](https://github.com/zenml-io/mlops-stacks) contains a series of Terraform-based recipes to provision such stacks. These recipes can be used directly with ZenML:\n\n```bash\nzenml stack recipe deploy <NAME_OF_STACK_RECIPE> --import\n```\n\nThe above command not only provisions the given tools, but also automatically creates a ZenML stack with the configuration of the deployed recipe!\n\n\n# 🗺 Roadmap\n\nZenML is being built in public. The [roadmap](https://zenml.io/roadmap) is a\nregularly updated source of truth for the ZenML community to understand where\nthe product is going in the short, medium, and long term.\n\nZenML is managed by a [core team](https://zenml.io/company#CompanyTeam) of developers that are\nresponsible for making key decisions and incorporating feedback from the\ncommunity. The team oversees feedback via various channels, and you can directly\ninfluence the roadmap as follows:\n\n- Vote on your most wanted feature on our [Discussion\n  board](https://zenml.io/discussion).\n- Start a thread in our [Slack channel](https://zenml.io/slack-invite).\n- [Create an issue](https://github.com/zenml-io/zenml/issues/new/choose) on our Github repo.\n\n# 🙌 Contributing and Community\n\nWe would love to develop ZenML together with our community! Best way to get\nstarted is to select any issue from the [`good-first-issue`\nlabel](https://github.com/zenml-io/zenml/labels/good%20first%20issue). If you\nwould like to contribute, please review our [Contributing\nGuide](CONTRIBUTING.md) for all relevant details.\n\n<br>\n\n![Repobeats analytics\nimage](https://repobeats.axiom.co/api/embed/635c57b743efe649cadceba6a2e6a956663f96dd.svg\n"Repobeats analytics image")\n\n\n# 👩\u200d👩\u200d👧\u200d👦 Meet the Team\n\n![Meet the Team](./docs/book/assets/meet_the_team.png)\n\nHave a question that\'s too hard to express on our Slack? Is it just too much effort to say everything on a \nlong GitHub issue? Or are you just curious about what ZenML has been up to in the past week? Well, register now for the ZenML Office (Half) Hour to get your answers and more!\nIt\'s free and open to everyone.\n\nEvery week, part of the ZenML [core team](https://zenml.io/company#CompanyTeam) will pop in for 30 minutes to interact directly with the community. Sometimes we\'ll be presenting a feature. Other times we just take questions and have fun. Join us if you are curious about ZenML, or just want to talk shop about MLOps.\n\n\n\nWe will host the gathering every Wednesday 8:30AM PT (5:30PM CET). \nRegister now through [this link](https://www.eventbrite.com/e/zenml-meet-the-community-tickets-354426688767), \nor subscribe to the [public events calendar](https://calendar.google.com/calendar/u/0/r?cid=Y19iaDJ0Zm44ZzdodXBlbnBzaWplY3UwMmNjZ0Bncm91cC5jYWxlbmRhci5nb29nbGUuY29t) to get notified \nbefore every community gathering.\n\n# 🆘 Getting Help\n\nThe first point of call should be [our Slack group](https://zenml.io/slack-invite/).\nAsk your questions about bugs or specific use cases, and someone from the [core team](https://zenml.io/company#CompanyTeam) will respond.\nOr, if you prefer, [open an issue](https://github.com/zenml-io/zenml/issues/new/choose) on our GitHub repo.\n\n\n# 📜 License\n\nZenML is distributed under the terms of the Apache License Version 2.0. \nA complete version of the license is available in the [LICENSE](LICENSE) file in\nthis repository. Any contribution made to this project will be licensed under\nthe Apache License Version 2.0.\n\n# 📖 Learn More\n\n| ZenML Resources | Description |\n| ------------- | - |\n| 🧘\u200d♀️ **[ZenML 101]** | New to ZenML? Here\'s everything you need to know! |\n| ⚛️ **[Core Concepts]** | Some key terms and concepts we use. |\n| 🚀 **[Our latest release]** | New features, bug fixes. |\n| 🗳 **[Vote for Features]** | Pick what we work on next! |\n| 📓 **[Docs]** | Full documentation for creating your own ZenML pipelines. |\n| 📒 **[API Reference]** | Detailed reference on ZenML\'s API. |\n| 🍰 **[ZenBytes]** | A guided and in-depth tutorial on MLOps and ZenML. |\n| 🗂️️ **[ZenFiles]** | End-to-end projects using ZenML. |\n| 👨\u200d🍳 **[MLOps Stacks]** | Terraform based infrastructure recipes for pre-made ZenML stacks. |\n| ⚽️ **[Examples]** | Learn best through examples where ZenML is used? We\'ve got you covered. |\n| 📬 **[Blog]** | Use cases of ZenML and technical deep dives on how we built it. |\n| 🔈 **[Podcast]** | Conversations with leaders in ML, released every 2 weeks. |\n| 📣 **[Newsletter]** | We build ZenML in public. Subscribe to learn how we work. |\n| 💬 **[Join Slack]** | Need help with your specific use case? Say hi on Slack! |\n| 🗺 **[Roadmap]** | See where ZenML is working to build new features. |\n| 🙋\u200d♀️ **[Contribute]** | How to contribute to the ZenML project and code base. |\n\n[ZenML 101]: https://docs.zenml.io/\n[Core Concepts]: https://docs.zenml.io/getting-started/core-concepts\n[Deployment Guide]: TBD\n[Our latest release]: https://github.com/zenml-io/zenml/releases\n[Vote for Features]: https://zenml.io/discussion\n[Docs]: https://docs.zenml.io/\n[API Reference]: https://apidocs.zenml.io/\n[ZenBytes]: https://github.com/zenml-io/zenbytes\n[ZenFiles]: https://github.com/zenml-io/zenfiles\n[MLOps Stacks]: https://github.com/zenml-io/mlops-stacks\n[Examples]: https://github.com/zenml-io/zenml/tree/main/examples\n[Blog]: https://blog.zenml.io/\n[Podcast]: https://podcast.zenml.io/\n[Newsletter]: https://zenml.io/newsletter/\n[Join Slack]: https://zenml.io/slack-invite/\n[Roadmap]: https://zenml.io/roadmap\n[Contribute]: https://github.com/zenml-io/zenml/blob/main/CONTRIBUTING.md\n\n',
    'author': 'ZenML GmbH',
    'author_email': 'info@zenml.io',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://zenml.io',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<3.11',
}


setup(**setup_kwargs)
