"""The aggregator package defines concrete subclasses of
`LabelAggregator` for use in training, evaluating and representing the
results of AutoML training on nPrint data.

In general, these classes take a dataframe generated by the label
aggregation step of the nprintML pipeline. It can be used on its own as
long as it receives a dataframe where each row of the dataframe contains
a single sample and the labels for the samples are contained in a
`label` column in the dataframe.

Subclasses are organized into submodules, such as
`aggregator.index.IndexLabelAggregator`.

A lazy-loading `registry` of these classes is provided for their dynamic
inspection and retrieval.

"""
from .base import (  # noqa: F401
    AggregationLengthError,
    AggregationPathError,
    LabelAggregator,
    LabelError,
    PluginRegistry,
)


registry = PluginRegistry(LabelAggregator,
                          __name__,
                          ignore=['base'])
