EXAMPLES = {
    "metadata": (
        """
        <doi_records>
  <doi_record owner="10.1002" timestamp="2021-11-25 02:23:49">
    <crossref>
      <journal>
        <journal_metadata language="en">
          <full_title>European Journal of Inorganic Chemistry</full_title>
          <abbrev_title>Eur. J. Inorg. Chem.</abbrev_title>
          <issn media_type="print">1434-1948</issn>
          <issn media_type="electronic">1099-0682</issn>
        </journal_metadata>
        <journal_issue>
          <publication_date media_type="print">
            <month>06</month>
            <day>30</day>
            <year>2019</year>
          </publication_date>
          <journal_volume>
            <volume>2019</volume>
          </journal_volume>
          <issue>24</issue>
          <doi_data>
            <doi>10.1002/ejic.v2019.24</doi>
            <resource>https://onlinelibrary.wiley.com/toc/10990682c/2019/24</resource>
          </doi_data>
        </journal_issue>
        <journal_article publication_type="full_text">
          <titles>
            <title>Oxido‐Hydroxido‐ and Oxido‐Aminato‐Osmium(V) Complexes with a Cyclohexanediamine‐Based Tetradentate Ligand as Active Oxidants for Dihydroxylation and Aminohydroxylation of Alkenes</title>
          </titles>
          <contributors>
            <person_name contributor_role="author" sequence="first">
              <given_name>Tomohiro</given_name>
              <surname>Fujimoto</surname>
              <affiliation>Department of Material and Life Science Division of Advanced Science and Biotechnology Graduate School of Engineering Osaka University 2‐1 Yamadaoka 565‐0871 Suita, Osaka Japan</affiliation>
            </person_name>
          </contributors>
          <publication_date media_type="online">
            <month>06</month>
            <day>12</day>
            <year>2019</year>
          </publication_date>
          <publication_date media_type="print">
            <month>06</month>
            <day>30</day>
            <year>2019</year>
          </publication_date>
          <pages>
            <first_page>2891</first_page>
            <last_page>2898</last_page>
          </pages>
          <publisher_item>
            <identifier id_type="doi">10.1002/ejic.201900339</identifier>
          </publisher_item>
          <crossmark>
            <crossmark_version>2</crossmark_version>
            <crossmark_policy>10.1002/crossmark_policy</crossmark_policy>
            <crossmark_domains>
              <crossmark_domain>
                <domain>onlinelibrary.wiley.com</domain>
              </crossmark_domain>
            </crossmark_domains>
            <crossmark_domain_exclusive>true</crossmark_domain_exclusive>
            <custom_metadata>
              <assertion group_label="Publication History" group_name="publication_history" label="Received" name="received" order="0">2019-03-27</assertion>
              <assertion group_label="Publication History" group_name="publication_history" label="Published" name="published" order="2">2019-06-12</assertion>
              <program name="fundref">
                <assertion name="fundgroup">
                  <assertion name="funder_name">
Japan Science and Technology Agency
                    <assertion name="funder_identifier">https://doi.org/10.13039/501100002241</assertion>
                  </assertion>
                  <assertion name="award_number">JPMJCR16P1</assertion>
                </assertion>
              </program>
              <program name="AccessIndicators">
                <license_ref applies_to="am" start_date="2020-05-27">http://onlinelibrary.wiley.com/termsAndConditions#am</license_ref>
                <license_ref applies_to="vor" start_date="2019-06-12">http://onlinelibrary.wiley.com/termsAndConditions#vor</license_ref>
                <license_ref applies_to="tdm">http://doi.wiley.com/10.1002/tdm_license_1.1</license_ref>
              </program>
            </custom_metadata>
          </crossmark>
          <archive_locations>
            <archive name="Portico"/>
          </archive_locations>
          <doi_data>
            <doi>10.1002/ejic.201900339</doi>
            <resource>https://onlinelibrary.wiley.com/doi/10.1002/ejic.201900339</resource>
            <collection property="crawler-based">
              <item crawler="iParadigms">
                <resource>https://onlinelibrary.wiley.com/doi/pdf/10.1002/ejic.201900339</resource>
              </item>
            </collection>
            <collection property="syndication">
              <item>
                <resource content_version="am" mime_type="application/pdf">https://onlinelibrary.wiley.com/doi/am-pdf/10.1002/ejic.201900339</resource>
              </item>
            </collection>
            <collection property="text-mining">
              <item>
                <resource content_version="vor" mime_type="application/pdf">https://api.wiley.com/onlinelibrary/tdm/v1/articles/10.1002%2Fejic.201900339</resource>
              </item>
              <item>
                <resource mime_type="application/pdf">https://onlinelibrary.wiley.com/doi/pdf/10.1002/ejic.201900339</resource>
              </item>
              <item>
                <resource mime_type="application/xml">https://onlinelibrary.wiley.com/doi/full-xml/10.1002/ejic.201900339</resource>
              </item>
            </collection>
          </doi_data>
        </journal_article>
      </journal>
    </crossref>
  </doi_record>
</doi_records>
        """
    ),
    "result_dc": (
        """<resource
  xmlns="http://datacite.org/schema/kernel-4"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xsi:schemaLocation="http://datacite.org/schema/kernel-4 http://schema.datacite.org/meta/kernel-4.3/metadata.xsd">
  <identifier identifierType="DOI">10.1002/ejic.201900339</identifier>
  <creators>
    <creator>
      <creatorName>Fujimoto, Tomohiro</creatorName>
      <affiliation>Department of Material and Life Science Division of Advanced Science and Biotechnology Graduate School of Engineering Osaka University 2‐1 Yamadaoka 565‐0871 Suita, Osaka Japan</affiliation>
    </creator>
  </creators>
  <titles>
    <title>Oxido‐Hydroxido‐ and Oxido‐Aminato‐Osmium(V) Complexes with a Cyclohexanediamine‐Based Tetradentate Ligand as Active Oxidants for Dihydroxylation and Aminohydroxylation of Alkenes</title>
  </titles>
  <publisher>Wiley</publisher>
  <publicationYear>2019</publicationYear>
  <subjects>
    <subject>Eur. J. Inorg. Chem.</subject>
    <subject>chemistry</subject>
    <subject>inorganic</subject>
    <subject>Osmium</subject>
    <subject>alkenes</subject>
  </subjects>
  <contributors>
    <contributor contributorType="Funder">
      <contributorName>Japan Science and Technology Agency</contributorName>
      <nameIdentifier schemeURI="https://doi.org/10.13039/501100002241" nameIdentifierScheme="Crossref Funder ID">JPMJCR16P1</nameIdentifier>
    </contributor>
  </contributors>
  <dates>
    <date dateType="Issued">2019-06-12</date>
    <date dateType="Available">2019-06-12</date>
  </dates>
  <language>en</language>
  <resourceType resourceTypeGeneral="Article">Journal Article</resourceType>
  <relatedIdentifiers>
    <relatedIdentifier relatedIdentifierType="URL" relationType="IsPartOf">https://onlinelibrary.wiley.com/toc/10990682c/2019/24</relatedIdentifier>
  </relatedIdentifiers>
  <descriptions>
    <description descriptionType="Abstract">Abstract text goes here.</description>
  </descriptions>
</resource>
        """),
    "result_schemaorg": (
      """<script type="application/ld+json">
{
  "@context": "http://schema.org",
  "@type": "ScholarlyArticle",
  "mainEntityOfPage": {
    "@type": "WebPage",
    "@id": "https://onlinelibrary.wiley.com/doi/10.1002/ejic.201900339"
  },
  "headline": "Oxido‐Hydroxido‐ and Oxido‐Aminato‐Osmium(V) Complexes with a Cyclohexanediamine‐Based Tetradentate Ligand as Active Oxidants for Dihydroxylation and Aminohydroxylation of Alkenes",
  "description": "Abstract text goes here.",
  "author": {
    "@type": "Person",
    "name": "Tomohiro Fujimoto",
    "affiliation": {
      "@type": "Organization",
      "name": "Department of Material and Life Science Division of Advanced Science and Biotechnology Graduate School of Engineering Osaka University 2‐1 Yamadaoka 565‐0871 Suita, Osaka Japan"
    }
  },
  "publisher": {
    "@type": "Organization",
    "name": "Wiley"
  },
  "datePublished": "2019-06-12",
  "dateModified": "2019-06-12",
  "isPartOf": {
    "@type": "Periodical",
    "name": "European Journal of Inorganic Chemistry",
    "issn": [
      "1434-1948",
      "1099-0682"
    ],
    "volumeNumber": "2019",
    "issueNumber": "24"
  },
  "identifier": {
    "@type": "PropertyValue",
    "propertyID": "DOI",
    "value": "10.1002/ejic.201900339"
  },
  "keywords": "Eur. J. Inorg. Chem., chemistry, inorganic, Osmium, alkenes",
  "funder": {
    "@type": "Organization",
    "name": "Japan Science and Technology Agency",
    "identifier": "https://doi.org/10.13039/501100002241",
    "grantNumber": "JPMJCR16P1"
  }
}
</script>
"""
    )
}

schema_prompt = (
    """You are given the initial metadata file using {initial_schema} schema and a prompt. 
    Convert the metadata file using information from the metadata file to the {target_schema} schema.

    initial schema: {initial_schema}
    target schema: {target_schema}
    metadata file: 
    ```
      {metadata}
    ```
    """
)

schema_fair_prompt = (
    """You are given the initial metadata file using {initial_schema} schema and a prompt. 
    Convert the metadata file using information from the metadata file to the {target_schema} schema.
    Include the FAIR data recommendations in the converted metadata file.

    initial schema: {initial_schema}
    target schema: {target_schema}
    metadata file: 
    {metadata}
    converted metadata file:"""
)

schema_examples_prompt = (
    """You are given the initial metadata file using {initial_schema} schema and a prompt. 
    Convert the metadata file using information from the metadata file to the {target_schema} schema.

    Example:
    initial schema: Datacite
    target schema: Crossref
    metadata file: 
    {metadata_example}
    converted metadata file:
    {result_example}

    initial schema: {initial_schema}
    target schema: {target_schema}
    metadata file: 
    {metadata}
    converted metadata file:"""
)