//     Copyright Toru Niina 2019.
// Distributed under the MIT License.
#ifndef TOML11_LITERAL_HPP
#define TOML11_LITERAL_HPP
#include "parser.hpp"

namespace toml
{
inline namespace literals
{
inline namespace toml_literals
{

inline ::toml::value operator""_toml(const char* str, std::size_t len)
{
    ::toml::detail::location<std::vector<char>>
        loc(/* filename = */ std::string("TOML literal encoded in a C++ code"),
            /* contents = */ std::vector<char>(str, str + len));

    // if there are some comments or empty lines, skip them.
    using skip_line = ::toml::detail::repeat<toml::detail::sequence<
            ::toml::detail::maybe<::toml::detail::lex_ws>,
            ::toml::detail::maybe<::toml::detail::lex_comment>,
            ::toml::detail::lex_newline
        >, ::toml::detail::at_least<1>>;
    skip_line::invoke(loc);

    // if there are some whitespaces before a value, skip them.
    using skip_ws = ::toml::detail::repeat<
        ::toml::detail::lex_ws, ::toml::detail::at_least<1>>;
    skip_ws::invoke(loc);

    // literal may be a bare value. try them first.
    if(auto data = ::toml::detail::parse_value(loc))
    {
        return data.unwrap();
    }

    // literal is a TOML file (i.e. multiline table).
    if(auto data = ::toml::detail::parse_toml_file(loc))
    {
        loc.iter() = loc.begin(); // rollback to the top of the literal
        return ::toml::value(std::move(data.unwrap()),
                ::toml::detail::region<std::vector<char>>(std::move(loc)));
    }
    else // none of them.
    {
        throw ::toml::syntax_error(data.unwrap_err());
    }
}

} // toml_literals
} // literals
} // toml
#endif//TOML11_LITERAL_HPP
