# Ankha's Gets: Functions for user input.

![Tests](https://github.com/FirstlyBoldly/Angets/actions/workflows/tests.yaml/badge.svg)
[![PyPI](https://img.shields.io/pypi/pyversions/angets.svg)](https://pypi.org/project/angets/)
[![License: MIT](https://img.shields.io/badge/License-MIT-red.svg)](https://opensource.org/licenses/MIT)

Ever get tired of fine-tuning user input?
\
Well, this is the package for you!
\
At least it is for me since I made the whole thing in the first place...

## Prerequisites

Python 3.11.x or newer.

## Installation

`pip install angets`

## Usage

Import Module.

```python
import angets
```

Basic usage, One attempt with a prompt to the user.

```python
input0 = angets.get_non_empty_string('Give me a response! ')
```

To get inputs with a bit more control.
> Remember to set `verbose` to True as no warning will be conveyed to the user otherwise.

```python
input1 = angets.get_constrained_float(
    within=(6, 9),
    interval='[]',
    prompt='Now give me a number within said range!',
    warning="Oops! Not within the bounds I'm afraid...",
    verbose=True,
    attempts=10
)
```

That is the gist of the main features.
\
It should be a useful utility tool to mitigate against invalid user inputs.

## <img src="/src/assets/images/troll_face.png" alt="Troll Face" style="height: 24px; width: 24px;" /> Problem?

Actually, I don't expect anyone else other than me to use this package.
\
But if you find it useful enough to want to contribute, be my guest!