# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI.ipynb (unless otherwise specified).

__all__ = ["logger", "app"]

# Cell

from typing import *
import logging

# Internal Cell

import typer

from . import ds, db, model, pred, user, api_key
from .token import token
from .version import version
from ..logger import get_logger, set_level

# Cell

logger = get_logger(__name__)

set_level(logging.WARNING)

# Cell

app = typer.Typer(help="airt CLI for accessing airt services.")

# Internal Cell

# token as root command
app.command()(token)

# Internal Cell

# Datasource root command

app.add_typer(
    ds.app,
    name="ds",
)

# Internal Cell

# Datablob root command

app.add_typer(
    db.app,
    name="db",
)

# Internal Cell

# Model root command

app.add_typer(
    model.app,
    name="model",
)

# Internal Cell

# Pred root command

app.add_typer(
    pred.app,
    name="pred",
)

# Internal Cell

# User root command

app.add_typer(
    user.app,
    name="user",
)

# Internal Cell

# API Keys root command

app.add_typer(
    api_key.app,
    name="api-key",
)

# Internal Cell

# version root command

app.command()(version)
