#!/bin/bash

  # Install oar
  /bin/bash /root/install_oar.sh $*

  # Cigri pull
  cd /root
  git clone https://github.com/oar-team/cigri.git

  # Cigri install
  cd /root/cigri
  make install-cigri 
  make install-autogenerated-cert
  make setup

  # Apache configuration (api activation)
  ln -s /etc/cigri/api-apache.conf /etc/apache2/conf-available/cigri-api.conf
  a2enconf cigri-api
  a2enmod ident
  perl -pi -e 's/OIDENT_BEHIND_PROXY.*=.*yes/OIDENT_BEHIND_PROXY=no/' /etc/default/oidentd
  systemctl enable oidentd

  # Cigri config file customization
  perl -pi -e 's/^DATABASE_HOST.*=.*/DATABASE_HOST = "server"/' /etc/cigri/cigri.conf
  perl -pi -e 's/^LOG_LEVEL.*=.*/LOG_LEVEL = "DEBUG"/' /etc/cigri/cigri.conf
  perl -pi -e 's/^LOG_FILE.*=.*/LOG_FILE = "STDERR"/' /etc/cigri/cigri.conf

  # OARAPI customization for CIGRI

    # SSL config  
    #  cp tools/oardocker/oar-restful-api-secured.conf /etc/apache2/conf-available
    #  a2enconf oar-restful-api-secured
    #  a2enmod ssl
    #  a2ensite default-ssl

    # Unsecure non-SSL config
  perl -pi -e "s@<VirtualHost \*:6668>@<VirtualHost *:6668>

# Unsecure config for CIGRI devel only - begin
ScriptAlias /oarapi-unsecure /usr/local/lib/cgi-bin/oarapi/oarapi.cgi
<Location /oarapi-unsecure>
  Options +ExecCGI -MultiViews +FollowSymLinks
</Location>
<IfModule rewrite_module>
  RewriteEngine On
  RewriteCond %{HTTP:X_REMOTE_IDENT}  (.*)
  RewriteRule .* - [E=HTTP_X_REMOTE_IDENT:%1]
</IfModule>
# Unsecure config for CIGRI devel only - end

@" /etc/apache2/conf-enabled/oar-restful-api.conf

