"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RamAccountAlias = exports.RamAccountAliasProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ram_generated_1 = require("./ram.generated");
Object.defineProperty(exports, "RamAccountAliasProperty", { enumerable: true, get: function () { return ram_generated_1.RosRamAccountAlias; } });
/**
 * A ROS resource type:  `ALIYUN::RAM::RamAccountAlias`
 */
class RamAccountAlias extends ros.Resource {
    /**
     * Create a new `ALIYUN::RAM::RamAccountAlias`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRamAccountAlias = new ram_generated_1.RosRamAccountAlias(this, id, {
            accountAlias: props.accountAlias,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRamAccountAlias;
        this.attrAccountAlias = rosRamAccountAlias.attrAccountAlias;
    }
}
exports.RamAccountAlias = RamAccountAlias;
//# sourceMappingURL=data:application/json;base64,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