# Downstream packaging

TuxMake is design to be a standard Python project, and to be installed using
standard Python tools. Packaging TuxMake should be trivial, and if it's not,
this is probably a bug in TuxMake, please talk to us.

## Build system

TuxMake uses [flit](https://flit.readthedocs.io/), but the source releases
published to PyPI do contain an autogenerated `setup.py`. So if you get
releases from PyPI, you can build using the included setup.py, but if you get
the sources from the git repository, then you will need to use `flit` directly.

You will notice that there is a `Makefile` in the root directory, but that is
mostly used to automate running the tests during development. There are,
though, two targets that might be of interest for packagers:

- `make man` will build a manpage that you can distribute with your binary
  packages (`tuxmake.1` in the root directory).
- `make doc` will build the documentation. The output will be in a directory
  called `public` in the root directly.

## Tests

TuxMake has both unit and integration tests, in `test/test_*.py` and
`test/integration/` respectively. Both are able to run against an installed
version of TuxMake (as opposed to from the TuxMake sources).

The unit test can be executed with `pytest`, and the integration tests can be
run by just calling `scripts/run-tests test/integration`.
